/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.HashMap;
import javax.jms.InvalidClientIDException;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.server.JMSClientEntry;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class ConnectionManager {
    private static HashMap clientIDs = new HashMap();
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public static synchronized void registerClientID(String clientID, JMSClientEntry entry) throws InvalidClientIDException {
        if (clientID == null) {
            return;
        }
        if (clientIDs.containsKey(clientID) && !JMSServerEntry.RI_COMPATIBLE) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6331_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6331_LEVEL, JeusMessage_JMS5._6331, new Object[]{clientID, clientIDs.get(clientID)});
            }
            throw new InvalidClientIDException("clientID [" + clientID + "] is already registered to " + clientIDs.get(clientID));
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6332_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6332_LEVEL, JeusMessage_JMS5._6332, new Object[]{clientID, entry});
        }
        clientIDs.put(clientID, entry);
    }

    public static synchronized boolean unregisterClientID(String clientID) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6333_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6333_LEVEL, JeusMessage_JMS5._6333, clientID);
        }
        return clientIDs.remove(clientID) != null;
    }

    public static synchronized boolean isClientIDActive(String clientID) {
        return clientIDs.containsKey(clientID);
    }

    public static synchronized void updateClientID(String prev, String current, JMSClientEntry entry) throws InvalidClientIDException {
        if (prev != null && prev.equals(current)) {
            return;
        }
        if (clientIDs.containsKey(current)) {
            throw new InvalidClientIDException("clientID [" + current + "] is already registered to " + clientIDs.get(current));
        }
        if (prev != null) {
            ConnectionManager.unregisterClientID(prev);
        }
        ConnectionManager.registerClientID(current, entry);
    }
}

