/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import javax.jms.InvalidSelectorException;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.server.manager.MessageSource;
import jeus.jms.server.manager.QueueManager;
import jeus.jms.server.manager.QueueSubscriptionMessageManager;
import jeus.jms.server.manager.SubscriptionContext;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.message.ServerMessage;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class QueueSubscriptionManager
extends SubscriptionManager {
    private final QueueManager queueManager;

    public QueueSubscriptionManager(SubscriptionContext subscriptionContext, long id, QueueManager manager, String selector, boolean cluster) throws InvalidSelectorException {
        super(subscriptionContext, id, manager, selector, cluster);
        this.queueManager = manager;
        this.topic = false;
        this.initialize();
    }

    void initialize() {
        this.messageManager = new QueueSubscriptionMessageManager(this.destination.getId(), this.subscriptionContext);
        this.setMaxPendingLimit(this.destination.getDestination().getMaxPendingLimit());
        this.setResumeDispatchFactor(this.destination.getDestination().getResumeDispatchFactor());
        super.initialize();
    }

    void updateSelector(String selector) throws InvalidSelectorException {
        super.updateSelector(selector);
        this.queueManager.recoverMessages(this.msgQueue.selectorUpdated(this));
    }

    void dispatchFailed(ServerMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6731_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6731_LEVEL, JeusMessage_JMS5._6731, message);
        }
        this.queueManager.recoverMessage(message);
    }

    void messageDelivered(ServerMessage message) {
        super.messageDelivered(message);
        this.messageManager.completed(message);
        this.destination.messageEvent(message, (byte)6);
    }

    void messageFailed(ServerMessage message) {
        super.messageFailed(message);
        this.destination.messageEvent(message, (byte)40);
    }

    public boolean enqueueMessage(ServerMessage message) {
        return this.isDispatchable() && super.enqueueMessage(message);
    }

    public void syncRequest(AdminMessage message) {
        final SubscriptionManager.DirectMessageRequest request = new SubscriptionManager.DirectMessageRequest(this, message);
        this.msgQueue.handleSyncRequest(request, new MessageSource(){

            public ServerMessage acquireMessage() {
                ServerMessage message = QueueSubscriptionManager.this.queueManager.acquireMessage(QueueSubscriptionManager.this, request);
                if (message != null) {
                    message.setSubscriptionEventListener(QueueSubscriptionManager.this);
                }
                return message;
            }
        });
    }

    public void asyncRequest() {
        this.queueManager.trigger();
        super.asyncRequest();
    }

    public void nacknowledge(MessageID messageID) {
        ServerMessage message;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6732_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6732_LEVEL, JeusMessage_JMS5._6732, new Object[]{messageID, this});
        }
        if ((message = this.msgQueue.removeAcknowledge(messageID)) != null) {
            message.setLocalConsume(true);
            this.queueManager.recoverMessage(message);
        }
    }

    public void consumerClosed() {
        super.consumerClosed();
        if (!this.cluster) {
            this.destination.removeSubscriber(this.id);
        }
        this.handleRemainings();
        this.queueManager.startDistribution();
    }

    public void shutdown() {
        super.shutdown();
        this.destination.removeSubscriber(this.id);
        this.handleRemainings();
        this.queueManager.startDistribution();
    }

    private void handleRemainings() {
        if (this.isXAParticipant()) {
            this.recoverForShutdown();
        } else {
            this.recoverAllForShutdown();
        }
    }

    private void recoverForShutdown() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6733_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6733_LEVEL, JeusMessage_JMS5._6733, this);
        }
        this.queueManager.recoverMessages(this.msgQueue.queue);
        this.msgQueue.clearQueuedMessage();
        this.queueManager.recoverAcknowledges(this.msgQueue.ackQueue);
        this.msgQueue.clearAcknowledges();
    }

    private void recoverAllForShutdown() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6734_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6734_LEVEL, JeusMessage_JMS5._6734, this);
        }
        this.queueManager.recoverMessages(this.msgQueue.queue);
        this.msgQueue.clearQueuedMessage();
        this.queueManager.recoverMessages(this.msgQueue.ackQueue);
        this.msgQueue.clearAcknowledges();
    }

    String createName() {
        StringBuffer buf = new StringBuffer(32);
        buf.append(this.cluster ? "CQSM[" : "QSM[").append(this.id).append(':').append(this.destination).append(']');
        buf.append('[').append(this.consumer == null ? "---" : this.consumer.toString()).append(']');
        return buf.toString();
    }
}

