/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.ArrayList;
import jeus.jms.server.comm.ClusteredPeer;
import jeus.jms.server.comm.JMSServiceChannel;
import jeus.jms.server.manager.ClusterManager;
import jeus.net.SocketStream;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class RelayClientManager {
    private static final int DEFAULT_CONNECTION_INTERVAL = 0;
    private static final int DEFAULT_WEIGHT = 1;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private static short relayClientBrokerID = (short)-1;

    public static ClusteredPeer getClusteredPeer(JMSServiceChannel serverChannel, String brokerName, SocketStream stream) {
        String hostAddress = stream.getHostName();
        int port = stream.getPort();
        ClusteredPeer clusteredPeer = new ClusteredPeer(serverChannel, RelayClientManager.getRelayClientBrokerID(), brokerName, hostAddress, port, 0L, 1);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5971_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5971_LEVEL, JeusMessage_JMS5._5971, clusteredPeer);
        }
        return clusteredPeer;
    }

    private static short getRelayClientBrokerID() {
        if (relayClientBrokerID == -1) {
            short maxBrokerID = ClusterManager.LOCAL_BROKER_ID;
            ArrayList clusteredPeers = ClusterManager.getClusteredPeers();
            for (ClusteredPeer peer : clusteredPeers) {
                if (maxBrokerID >= peer.getBrokerID()) continue;
                maxBrokerID = peer.getBrokerID();
            }
            relayClientBrokerID = (short)(maxBrokerID + 1);
        }
        return relayClientBrokerID;
    }
}

