/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import jeus.jms.server.persistence.DestinationArchive;
import jeus.jms.server.persistence.DurableSubscriberArchive;
import jeus.jms.server.persistence.MessageArchive;
import jeus.jms.server.persistence.Storage;
import jeus.jms.server.persistence.StorageCreator;
import jeus.jms.server.transaction.TransactionManager;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;
import jeus.xml.binding.jeusDD.StorageType;

public class StorageManager {
    private MessageArchive msgArchive;
    private DestinationArchive dmArchive;
    private DurableSubscriberArchive smArchive;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private static StorageManager currentManager;
    private boolean needRecovery;
    private Storage storage;

    public StorageManager(StorageCreator creator) throws Exception {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6191_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6191_LEVEL, JeusMessage_JMS5._6191, new Object[]{this.getClass().getName(), creator});
        }
        this.storage = creator.createStorage();
        this.msgArchive = new MessageArchive(this.storage);
        this.dmArchive = new DestinationArchive(this.storage);
        this.smArchive = new DurableSubscriberArchive(this.storage);
        this.needRecovery = creator.needRecovery();
    }

    private void initDestinationInternal() throws Exception {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6192_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6192_LEVEL, JeusMessage_JMS5._6192);
        }
        this.dmArchive.init();
    }

    private void initSubscriptionInternal() throws Exception {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6193_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6193_LEVEL, JeusMessage_JMS5._6193);
        }
        this.smArchive.init();
    }

    public void startRecoveryInternal(boolean dynamic) throws Exception {
        if (dynamic) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6194_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6194_LEVEL, JeusMessage_JMS5._6194);
            }
            this.msgArchive.init();
        } else if (this.needRecovery) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6195_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6195_LEVEL, JeusMessage_JMS5._6195);
            }
            this.msgArchive.init();
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6196_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6196_LEVEL, JeusMessage_JMS5._6196);
            }
        } else if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6197_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6197_LEVEL, JeusMessage_JMS5._6197);
        }
    }

    public void initInternal() throws Exception {
        this.storage.init();
        this.storage.start();
    }

    public void shutdownInternal() {
        if (this.smArchive != null) {
            this.smArchive.shutdown();
        }
        if (this.dmArchive != null) {
            this.dmArchive.shutdown();
        }
        if (this.msgArchive != null) {
            this.msgArchive.shutdown();
        }
        this.storage.prepareShutdown();
        this.storage.shutdown();
    }

    public Storage getStorage() {
        return this.storage;
    }

    public static void shutdown() {
        if (currentManager != null) {
            currentManager.shutdownInternal();
        }
    }

    public static void startRecovery() throws Exception {
        currentManager.startRecoveryInternal(false);
    }

    public static void initSubscription() throws Exception {
        currentManager.initSubscriptionInternal();
    }

    public static void initStorage(StorageType descriptor) throws Exception {
        StorageCreator creator = StorageCreator.createStorageCreator(descriptor);
        currentManager = new StorageManager(creator);
        currentManager.initInternal();
        TransactionManager.getInstance().init(StorageManager.getCurrentStorage());
    }

    public static void initDestination() throws Exception {
        currentManager.initDestinationInternal();
    }

    public static long getNextEntryID() {
        return StorageManager.currentManager.msgArchive.getNextEntryID();
    }

    public static long getNextMessageID(byte type) {
        return StorageManager.currentManager.msgArchive.createMessageID(type);
    }

    public static MessageArchive getMessageStorage() {
        return StorageManager.currentManager.msgArchive;
    }

    public static DestinationArchive getDestinationStorage() {
        return StorageManager.currentManager.dmArchive;
    }

    public static DurableSubscriberArchive getDurableSubscriberStorage() {
        return StorageManager.currentManager.smArchive;
    }

    public static synchronized Storage getCurrentStorage() {
        return currentManager.getStorage();
    }

    public static synchronized void setCurrentManager(StorageManager currentManager) {
        StorageManager.currentManager = currentManager;
    }
}

