/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.UserMessage;
import jeus.jms.server.AbstractConsumer;
import jeus.jms.server.JMSMessageConsumer;
import jeus.jms.server.manager.AcknowledgeQueue;
import jeus.jms.server.manager.DispatchMessageQueue;
import jeus.jms.server.manager.MessageRequest;
import jeus.jms.server.manager.MessageSelector;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.manager.ThreadPoolManager;
import jeus.jms.server.message.ServerMessage;
import jeus.util.LinkedHashMap;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

class SubscriptionQueue
extends DispatchMessageQueue {
    private final SubscriptionManager manager;

    SubscriptionQueue(SubscriptionManager subscription) {
        super(subscription.getMaxPendingLimit(), subscription.getResumeDispatchFactor());
        this.manager = subscription;
    }

    void dispatchMessage(ServerMessage message, boolean recover) {
        MessageRequest request = this.acquireSyncRequest(message, recover);
        if (request != null) {
            request.execute(message);
        } else {
            this.startExecution();
        }
    }

    ServerMessage acknowledge(MessageID messageID) {
        ServerMessage message = this.removeAcknowledge(messageID);
        if (message != null) {
            this.manager.messageEvent(message, (byte)5);
        }
        return message;
    }

    ServerMessage enqueueMessage(ServerMessage message) {
        message.setObserved(false);
        return super.enqueueMessage(message);
    }

    void recover(MessageID messageID, boolean delivered) {
        ServerMessage message = this.removeAcknowledge(messageID);
        if (message != null) {
            message.setJMSRedelivered(delivered);
            this.recoverMessage(message);
        }
    }

    void returnBack(MessageID messageID) {
        ServerMessage message = this.removeAcknowledge(messageID);
        if (message != null) {
            this.dispatchMessage(message, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledgeAll() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6701_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6701_LEVEL, JeusMessage_JMS5._6701);
        }
        AcknowledgeQueue acknowledgeQueue = this.ackQueue;
        synchronized (acknowledgeQueue) {
            for (ServerMessage message : this.ackQueue.values()) {
                this.manager.messageEvent(message, (byte)5);
            }
            this.clearAcknowledges();
        }
        acknowledgeQueue = this.queue;
        synchronized (acknowledgeQueue) {
            for (ServerMessage message : this.queue.values()) {
                this.manager.messageEvent(message, (byte)5);
            }
            this.clearQueuedMessage();
        }
    }

    public boolean checkExecutor() {
        return this.manager.isDispatchable() && super.checkExecutor();
    }

    void preExecution(ServerMessage message) {
        message.setRequestFlag(false);
        AbstractConsumer consumer = this.manager.getMessageConsumer();
        if (consumer != null && consumer instanceof JMSMessageConsumer) {
            int ackMode = ((JMSMessageConsumer)consumer).getSession().getAcknowledgeMode();
            message.setDirect(ackMode == -1 && message.getMessageType() != 70);
        }
        message.increaseDeliveryCount();
        this.enqueueAcknowledge(message);
    }

    boolean execute(ServerMessage message) throws JMSException {
        return this.manager.dispatch(message);
    }

    void exception(ServerMessage message, JMSException e) {
        this.manager.dispatchFailed(message);
    }

    void failed(ServerMessage message, Throwable t) {
        this.manager.dispatchFailed(message);
    }

    boolean postExecution(ServerMessage message, int result) {
        int ackMode;
        if (0 != result) {
            message.decreaseDeliveryCount();
        }
        switch (result) {
            case 2: 
            case 3: {
                this.removeAcknowledge(message.getMessageID());
                break;
            }
            case 1: {
                this.recover(message.getMessageID(), false);
                return false;
            }
        }
        AbstractConsumer consumer = this.manager.getMessageConsumer();
        if (result == 0 && consumer != null && consumer instanceof JMSMessageConsumer && (ackMode = ((JMSMessageConsumer)consumer).getSession().getAcknowledgeMode()) == -1 && message.getMessageType() != 70) {
            try {
                ThreadPoolManager.execute(new AcknowledgeTask(message.getMessageID()));
            }
            catch (InterruptedException e) {
                this.acknowledge(message.getMessageID());
            }
        }
        return true;
    }

    void workCompleted() {
        this.manager.dispatchCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap selectorUpdated(MessageSelector selector) {
        LinkedHashMap banned = new LinkedHashMap();
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            Iterator it = this.queue.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if (selector.isSelectedMessage((UserMessage)entry.getValue())) continue;
                banned.put(entry.getKey(), entry.getValue());
                it.remove();
            }
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6702_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6702_LEVEL, JeusMessage_JMS5._6702, banned);
        }
        return banned;
    }

    private class AcknowledgeTask
    implements Runnable {
        private MessageID messageID;

        public AcknowledgeTask(MessageID messageID) {
            this.messageID = messageID;
        }

        public void run() {
            SubscriptionQueue.this.acknowledge(this.messageID);
        }
    }
}

