/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import jeus.jms.common.message.MessageID;
import jeus.jms.server.config.DurableSubscriptionConfig;
import jeus.jms.server.config.DurableSubscriptionIdentity;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.manager.DummySubscriptionContext;
import jeus.jms.server.manager.DurableTopicSubscriptionManager;
import jeus.jms.server.manager.StorageManager;
import jeus.jms.server.manager.SubscriptionContext;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.manager.TopicManager;
import jeus.jms.server.persistence.DurableSubscriberArchive;
import jeus.jms.server.persistence.StorageException;
import jeus.util.OpenMap;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;
import jeus.xml.binding.jeusDD.DurableSubscriberType;

public class SubscriptionUtil {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private static Map subscribers = new HashMap();
    private static OpenMap durables = new OpenMap();
    private static DurableSubscriberArchive archive;

    public static void init() {
        archive = StorageManager.getDurableSubscriberStorage();
    }

    public static SubscriptionManager addSubscription(SubscriptionContext subscriptionContext, DestinationManager dest, String selector, boolean noLocal, boolean cluster) throws JMSException {
        long id = archive.createId();
        SubscriptionManager manager = dest.addSubscriber(subscriptionContext, id, selector, noLocal, cluster);
        SubscriptionUtil.addNonDurable(manager);
        return manager;
    }

    public static SubscriptionManager addDurableSubscription(DurableSubscriberType type) throws JMSException {
        TopicManager target = DestinationUtil.getLocalTopicManager(type.getDestinationName());
        return SubscriptionUtil.addDurableSubscription(new DummySubscriptionContext(), target, type.getClientId(), type.getName(), type.getMessageSelector(), false, false);
    }

    public static SubscriptionManager addDurableSubscription(SubscriptionContext subscriptionContext, TopicManager target, String clientID, String durableName, String selector, boolean noLocal, boolean cluster) throws JMSException {
        DurableSubscriptionConfig config = new DurableSubscriptionConfig(target.getDestinationName(), clientID, durableName, selector, noLocal, cluster);
        return SubscriptionUtil.createDurableSubscription(subscriptionContext, target, config);
    }

    public static SubscriptionManager restoredDurableSubscription(DurableSubscriptionConfig config) throws JMSException {
        TopicManager target = DestinationUtil.getLocalTopicManager(config.getDestinationName());
        DurableTopicSubscriptionManager manager = new DurableTopicSubscriptionManager(target, config);
        target.addDurableSubscriber(manager);
        SubscriptionUtil.addDurable(manager, config);
        return manager;
    }

    private static SubscriptionManager createDurableSubscription(SubscriptionContext subscriptionContext, TopicManager target, DurableSubscriptionConfig config) throws JMSException {
        DurableTopicSubscriptionManager manager = SubscriptionUtil.getDurable(config);
        if (manager != null) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6541_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6541_LEVEL, JeusMessage_JMS5._6541, new Object[]{manager, config});
            }
            config.setId(manager.getId());
            archive.update(target.getDestination(), config);
            manager.updateConfiguration(config, target);
            manager.setSubscriptionContext(subscriptionContext);
        } else {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6542_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6542_LEVEL, JeusMessage_JMS5._6542, config);
            }
            config.setId(archive.createId());
            manager = new DurableTopicSubscriptionManager(subscriptionContext, target, config);
            archive.persist(config);
            target.addDurableSubscriber(manager);
        }
        SubscriptionUtil.addDurable(manager, config);
        return manager;
    }

    public static void unsubscribe(String clientID, String durableName) throws JMSException {
        DurableSubscriptionIdentity identity;
        DurableTopicSubscriptionManager manager;
        if (clientID == null) {
            throw new JMSException("ClientID is null.");
        }
        if (durableName == null) {
            throw new JMSException("Durable name is null.");
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6543_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6543_LEVEL, JeusMessage_JMS5._6543, new Object[]{clientID, durableName});
        }
        if ((manager = SubscriptionUtil.getDurable(identity = new DurableSubscriptionIdentity(clientID, durableName))) == null) {
            throw new InvalidDestinationException("not existing durable subscrber [" + clientID + "/" + durableName + "]");
        }
        if (manager.isAdmin()) {
            // empty if block
        }
        manager.unsubscribe();
        SubscriptionUtil.removeDurable(manager, identity);
        archive.delete(manager.getId());
    }

    public static synchronized void removeAllMessage(String clientID, String durableName) throws InvalidDestinationException {
        DurableSubscriptionIdentity identity;
        DurableTopicSubscriptionManager manager;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6544_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6544_LEVEL, JeusMessage_JMS5._6544, new Object[]{clientID, durableName});
        }
        if ((manager = SubscriptionUtil.getDurable(identity = new DurableSubscriptionIdentity(clientID, durableName))) == null) {
            throw new InvalidDestinationException("not existing durable subscrber [" + clientID + "/" + durableName + "]");
        }
        manager.removeAllMessage();
    }

    public static synchronized byte getDurableMessageLifecycle(String clientID, String durableName, MessageID messageID) throws InvalidDestinationException, StorageException {
        DurableSubscriptionIdentity identity;
        DurableTopicSubscriptionManager manager;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6545_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6545_LEVEL, JeusMessage_JMS5._6545, new Object[]{clientID, durableName});
        }
        if ((manager = SubscriptionUtil.getDurable(identity = new DurableSubscriptionIdentity(clientID, durableName))) == null) {
            throw new InvalidDestinationException("not existing durable subscrber [" + clientID + "/" + durableName + "]");
        }
        return archive.getStorage().getDurableMessageLifecycle(manager.getId(), messageID);
    }

    public static synchronized SubscriptionManager removeSubscription(long id) {
        SubscriptionManager manager = SubscriptionUtil.removeNonDurable(id);
        if (manager != null && manager.isDurable()) {
            DurableTopicSubscriptionManager durable = (DurableTopicSubscriptionManager)manager;
            DurableSubscriptionIdentity identity = new DurableSubscriptionIdentity(durable.getClientID(), durable.getDurableName());
            durables.remove((Object)identity);
            archive.delete(manager.getId());
        }
        return manager;
    }

    public static synchronized SubscriptionManager getSubscriptionManager(long id) throws InvalidDestinationException {
        SubscriptionManager manager = (SubscriptionManager)subscribers.get(new Long(id));
        if (manager == null) {
            throw new InvalidDestinationException("failed to get subscription " + id);
        }
        return manager;
    }

    private static synchronized void addDurable(SubscriptionManager manager, DurableSubscriptionIdentity identity) {
        durables.put((Object)identity, (Object)manager);
        subscribers.put(new Long(manager.getId()), manager);
    }

    private static synchronized DurableTopicSubscriptionManager getDurable(DurableSubscriptionIdentity identity) {
        return (DurableTopicSubscriptionManager)durables.get((Object)identity);
    }

    private static synchronized void removeDurable(DurableTopicSubscriptionManager manager, DurableSubscriptionIdentity identity) {
        durables.remove((Object)identity);
        subscribers.remove(new Long(manager.getId()));
    }

    private static synchronized void addNonDurable(SubscriptionManager manager) {
        subscribers.put(new Long(manager.getId()), manager);
    }

    private static synchronized SubscriptionManager removeNonDurable(long id) {
        return (SubscriptionManager)subscribers.remove(new Long(id));
    }

    public static synchronized boolean checkDurableSubscription(String clientID, String durableName) {
        DurableSubscriptionIdentity identity = new DurableSubscriptionIdentity(clientID, durableName);
        return durables.containsKey((Object)identity);
    }

    public static synchronized List getDurableDigest() {
        ArrayList<String> result = new ArrayList<String>();
        for (DurableTopicSubscriptionManager manager : durables.values()) {
            result.add(manager.toString());
        }
        return result;
    }

    public static synchronized List getDigest() {
        ArrayList<String> result = new ArrayList<String>();
        for (SubscriptionManager manager : subscribers.values()) {
            result.add(manager.toString());
        }
        return result;
    }

    public static synchronized void shutdown() {
        SubscriptionManager[] managers = subscribers.values().toArray(new SubscriptionManager[0]);
        for (int i = 0; i < managers.length; ++i) {
            SubscriptionManager manager = managers[i];
            manager.consumerClosed();
            if (manager.isDurable()) {
                DurableTopicSubscriptionManager dtsm = (DurableTopicSubscriptionManager)manager;
                dtsm.unregisterMBean();
                continue;
            }
            manager.shutdown();
        }
        subscribers.clear();
        durables.clear();
    }

    public static void startDistribution() {
        for (DurableTopicSubscriptionManager manager : durables.values()) {
            manager.startDistribution();
        }
    }
}

