/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import javax.jms.InvalidSelectorException;
import jeus.jms.common.message.UserMessage;
import jeus.jms.server.manager.SubscriptionContext;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.manager.TopicManager;
import jeus.jms.server.message.MessageStatsProvider;
import jeus.jms.server.message.ServerMessage;

public abstract class TopicSubscriptionManager
extends SubscriptionManager {
    protected TopicManager manager;
    protected boolean noLocal;

    TopicSubscriptionManager(SubscriptionContext subscriptionContext, long id, TopicManager topicManager, String selector, boolean noLocal, boolean cluster) throws InvalidSelectorException {
        super(subscriptionContext, id, topicManager, selector, cluster);
        this.manager = topicManager;
        this.noLocal = noLocal;
        this.topic = true;
    }

    void initialize() {
        this.stats = new MessageStatsProvider();
        super.initialize();
    }

    void updateSelector(String selector) throws InvalidSelectorException {
        super.updateSelector(selector);
        this.msgQueue.selectorUpdated(this);
    }

    void messageArrived(ServerMessage message) {
        ServerMessage clone = this.copyMessage(message);
        super.messageArrived(clone);
    }

    void messageDelivered(ServerMessage message) {
        super.messageDelivered(message);
        this.messageManager.completed(message);
        if (message.decreaseReference()) {
            this.destination.messageEvent(message, (byte)6);
        }
    }

    public boolean isSelectedMessage(UserMessage message) {
        if (this.noLocal && message.getEntryID() == this.entryID && message.getConnectionID() == this.connectionID) {
            return false;
        }
        return super.isSelectedMessage(message);
    }

    ServerMessage copyRecoveredMessage(ServerMessage message) {
        ServerMessage clone = this.copyMessage(message);
        clone.setDestinationEventListener(this.destination);
        return clone;
    }

    ServerMessage copyMessage(ServerMessage message) {
        ServerMessage clone = message.getShallowCopy();
        clone.setSubscriptionEventListener(this);
        clone.incrementReference();
        return clone;
    }

    ServerMessage setupMessage(ServerMessage message) {
        message.setDestinationEventListener(this.destination);
        message.setSubscriptionEventListener(this);
        return message;
    }
}

