/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.mbean;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Stats;
import jeus.jms.server.JMSClientEntry;
import jeus.jms.server.mbean.JMSClientResourceMBean;
import jeus.jms.server.mbean.JMSServiceChannelMo;
import jeus.jms.server.mbean.stats.JMSClientStatsImpl;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEResource;

public class JMSClientResource
extends J2EEResource
implements JMSClientResourceMBean {
    private final JMSServiceChannelMo parent;
    private final JMSClientEntry target;
    private final JMSClientStatsImpl stats;
    private final Vector connectionNames;
    public static final String PREFIX = "JMSClient-";

    public static JMSClientResource createMBean(String mBeanName, JMSServiceChannelMo parent, JMSClientEntry target) throws InstanceAlreadyExistsException {
        JMSClientResource resource = new JMSClientResource(parent, target);
        resource.createMBean(mBeanName, "JeusService", parent.getObjectName(), JMSClientResourceMBean.parentKeyMap, "JMSClientResource");
        return resource;
    }

    public JMSClientResource(JMSServiceChannelMo parent, JMSClientEntry target) {
        super(parent.getObjectName());
        this.parent = parent;
        this.target = target;
        this.stats = new JMSClientStatsImpl();
        this.connectionNames = new Vector();
    }

    protected String initPermissionName() {
        return this.parent.getPermissionName() + ".client." + this.target.toString();
    }

    public String getName() {
        return this.target.toString();
    }

    public String getHostName() {
        return this.target.getHostName();
    }

    public int getPort() {
        return this.target.getPort();
    }

    public String getDigest() {
        return this.target.getDigest();
    }

    public void addChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType((ObjectName)pChild);
        if (lType.equals("JMSConnectionResource")) {
            this.connectionNames.add(pChild);
        }
        super.addChild(pChild);
    }

    public void removeChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType((ObjectName)pChild);
        if (lType.equals("JMSConnectionResource")) {
            this.connectionNames.remove(pChild);
        }
        super.removeChild(pChild);
    }

    public Stats getstats() {
        return this.stats;
    }

    public CountStatistic getConnectionCount() {
        CountStatistic stat = this.stats.getConnectionCount();
        if (stat != null) {
            return stat;
        }
        return this.stats.getConnectionCount();
    }

    public List getJMSConnectionResourceNames() {
        return new ArrayList(this.connectionNames);
    }

    public void shutdown() {
        this.target.shutdownAll();
    }

    public String toString() {
        return this.target.toString();
    }
}

