/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.mbean;

import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.jms.JMSException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import javax.xml.bind.JAXBException;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.common.logger.JMSLevel;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.server.JMSServer;
import jeus.jms.server.comm.JMSBroker;
import jeus.jms.server.config.ConnectionFactoryUtil;
import jeus.jms.server.config.JMSConfig;
import jeus.jms.server.manager.AdministeredObjectBinder;
import jeus.jms.server.manager.ClusterManager;
import jeus.jms.server.manager.DestinationFactory;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.manager.Scheduler;
import jeus.jms.server.manager.StorageManager;
import jeus.jms.server.manager.SubscriptionUtil;
import jeus.jms.server.manager.TakeoverExecutor;
import jeus.jms.server.manager.ThreadPoolManager;
import jeus.jms.server.mbean.JMSConnectionFactoryResource;
import jeus.jms.server.mbean.JMSResourceMBean;
import jeus.jms.server.mbean.stats.JMSStatsImpl;
import jeus.jms.server.transaction.TransactionManager;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEResource;
import jeus.management.j2ee.J2EEResourceMBean;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.util.PermissionMaker;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.JeusLoggerConfiguration;
import jeus.util.logging.Journal;
import jeus.util.logging.MemoryHandler;
import jeus.util.message.JeusMessage_JMS;
import jeus.xml.binding.jeusDD.ConnectionFactoryType;
import jeus.xml.binding.jeusDD.DestinationType;
import jeus.xml.binding.jeusDD.DurableSubscriberType;
import jeus.xml.binding.jeusDD.JmsServerClusterType;
import jeus.xml.binding.jeusDD.SystemLoggingType;
import org.xml.sax.SAXException;

public class JMSResource
extends J2EEResource
implements JMSResourceMBean {
    public static final String DEAD_LETTER_QUEUE = "_JMS_DLQ";
    public static final String CONNECT_PERMISSION_NAME = "jeus.jms.client.connectionFactory";
    public static final String CREATE_PERMISSION_NAME = "jeus.jms.destination.creation";
    public static final Permission CONNECT_PERMISSION = PermissionMaker.makeResourcePermission((String)"jeus.jms.client.connectionFactory", (String)"createConnection");
    public static final Permission CREATE_PERMISSION = PermissionMaker.makeResourcePermission((String)"jeus.jms.destination.creation", (String)"createDestination");
    private ResourcePermission addDestinationPermission;
    private ResourcePermission removeDestinationPermission;
    private ResourcePermission addConnectionFactoryPermission;
    private ResourcePermission removeConnectionFactoryPermission;
    private JMSConfig config;
    private JMSStatsImpl jmsStats;
    private Journal accessLogger;
    private Vector factoryResourceNameList = new Vector();
    private Vector destinationResourceNameList = new Vector();

    public JMSResource(String engineName, JMSConfig config, ObjectName parent) throws JMSException {
        super(parent);
        this.config = config;
        this.jmsStats = new JMSStatsImpl();
        try {
            this.createMBean(engineName, "JMSResource", parent, J2EEResourceMBean.parentKeyMap, null);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new JMSException("failed to create jms resource mbean");
        }
    }

    public void preStart() throws Exception {
        AdministeredObjectBinder.init();
        ThreadPoolManager.init(this.config.getThreadPool());
        this.initServiceChannel();
        this.initServerCluster();
        this.initAdministeredObjects();
        ClusterManager.start();
    }

    public void postStart() throws Exception {
        ConnectionFactoryUtil.start();
        JMSBroker.getLocalBroker().start();
    }

    protected String initPermissionName() {
        if (!JMSServer.isStandalone()) {
            J2EEManagedObjectMBean parent = (J2EEManagedObjectMBean)JMXUtility.getProxy((MBeanServerConnection)this.mbs, (ObjectName)this.parentObjectName, J2EEManagedObjectMBean.class, (boolean)false);
            return parent.getPermissionName() + ".jms";
        }
        return "jms";
    }

    protected void makePermissions() {
        super.makePermissions();
        this.addDestinationPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"addDestination");
        this.removeDestinationPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"removeDestination");
        this.addConnectionFactoryPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"addConnectionFactory");
        this.removeConnectionFactoryPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"removeConnectionFactory");
    }

    private void initServiceChannel() throws Exception {
        this.initAccessLogger();
        JMSBroker.getLocalBroker().initialize(this, this.config.getServiceConfig());
    }

    private void initServerCluster() throws JMSException {
        JmsServerClusterType cluster = this.config.getCluster();
        if (cluster != null) {
            ClusterManager.initClusteredBroker(cluster);
            ClusterManager.initClusterConfig(this.config.getQueueClusterConfig(), this.config.getTopicClusterConfig());
        }
    }

    private void initFactories() throws JMSException {
        ConnectionFactoryUtil.init(this);
        this.createFactories();
    }

    private void initAdministeredObjects() throws Exception {
        this.initStorage();
        this.initDestination();
        this.initSubscription();
        this.initMessages();
        this.initFactories();
    }

    public void initMessages() throws Exception {
        if (!TransactionManager.getInstance().hasInDoubtTransactions()) {
            StorageManager.startRecovery();
            DestinationUtil.startSweeping();
            DestinationUtil.startDistribution();
        }
    }

    private void initStorage() throws Exception {
        StorageManager.initStorage(this.config.getStorage());
        DestinationUtil.init(this);
        SubscriptionUtil.init();
    }

    private void initDestination() throws Exception {
        StorageManager.initDestination();
        List destnations = this.config.getDestinations();
        if (destnations != null) {
            for (DestinationType type : destnations) {
                this.addDestination(type);
            }
        }
        this.addDestination((byte)81, ClusterManager.LOCAL_BROKER_NAME + DEAD_LETTER_QUEUE, ClusterManager.LOCAL_BROKER_NAME + DEAD_LETTER_QUEUE, null);
    }

    private void initSubscription() throws Exception {
        StorageManager.initSubscription();
        List subscribers = this.config.getDurables();
        if (subscribers != null) {
            for (DurableSubscriberType type : subscribers) {
                SubscriptionUtil.addDurableSubscription(type);
            }
        }
    }

    private void createFactories() throws JMSException {
        List factories = this.config.getFactories();
        if (factories != null) {
            for (ConnectionFactoryType type : factories) {
                this.initConnectionFactory(type);
            }
        }
    }

    public long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public int getRunningThreadCount() {
        return ThreadPoolManager.getThreadPool().getActiveCount();
    }

    public int getTotalThreadCount() {
        return ThreadPoolManager.getThreadPool().getPoolSize();
    }

    public List getJMSConnectionFactoryDigest() {
        return ConnectionFactoryUtil.getDigest();
    }

    public List getJMSDestinationDigest() {
        return DestinationUtil.getDigest();
    }

    public List getJMSSubscriptionDigest() {
        return SubscriptionUtil.getDigest();
    }

    public void unsubscribe(String clientID, String durableName) throws JMSException {
        SubscriptionUtil.unsubscribe(clientID, durableName);
    }

    public void addJMSConnectionStats(Stats stats) {
        this.jmsStats.addJMSConnectionStats(stats);
    }

    public void removeJMSConnectionStats(Stats stats) {
        this.jmsStats.removeJMSConnectionStats(stats);
    }

    public Stats getstats() {
        return this.jmsStats;
    }

    public ArrayList getClusterPeerInfos() {
        return ClusterManager.getClusteredPeersInfo();
    }

    public void setLogLevel(String loggerName, String level) {
        JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)loggerName);
        if (logger != null) {
            logger.setLogLevel(JMSLevel.parse(level));
        }
    }

    public void addChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType((ObjectName)pChild);
        if (lType.equals("JMSConnectionFactoryResource")) {
            this.factoryResourceNameList.add(pChild);
        } else if (lType.equals("JMSDestinationResource")) {
            this.destinationResourceNameList.add(pChild);
        }
        super.addChild(pChild);
    }

    public void removeChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType((ObjectName)pChild);
        if (lType.equals("JMSConnectionFactoryResource")) {
            this.factoryResourceNameList.remove(pChild);
        } else if (lType.equals("JMSDestinationResource")) {
            this.destinationResourceNameList.remove(pChild);
        }
        super.removeChild(pChild);
    }

    public List getJMSConnectionFactoryResourceNames() {
        return new ArrayList(this.factoryResourceNameList);
    }

    public List getJMSDestinationResourceNames() {
        return new ArrayList(this.destinationResourceNameList);
    }

    private ObjectName initConnectionFactory(ConnectionFactoryType type) throws JMSException {
        JMSConnectionFactoryResource mbean = ConnectionFactoryUtil.createFactory(type);
        return mbean.getObjectName();
    }

    public synchronized ObjectName addConnectionFactory(String type, String factoryName, String exportName, int maxThread, String clientID) throws JMSException {
        return this.addConnectionFactory(type, factoryName, exportName, maxThread, clientID, false);
    }

    public synchronized ObjectName addConnectionFactory(String type, String factoryName, String exportName, int maxThread, String clientID, boolean save) throws JMSException {
        JMSConnectionFactoryResource mbean;
        this.checkConnectionfactoryCreationPermission();
        ConnectionFactoryType ftype = ConnectionFactoryUtil.createFactoryType(type, factoryName, exportName, clientID, maxThread);
        if (logger.isLoggable(JeusMessage_JMS._3121_LEVEL)) {
            logger.log(JeusMessage_JMS._3121_LEVEL, JeusMessage_JMS._3121, new Object[]{type, factoryName, exportName, new Integer(maxThread), clientID});
        }
        try {
            ConnectionFactoryType desc = ftype.cloneConnectionFactoryType();
            desc.fillDefault();
            mbean = ConnectionFactoryUtil.createFactory(desc);
            mbean.start();
        }
        catch (JAXBException e) {
            throw JMSExceptionFactory.createJMSException(e.getMessage(), (Exception)((Object)e));
        }
        if (save) {
            try {
                this.config.getFactories().add(ftype);
                this.config.save(logger.isLoggable(Level.INFO));
            }
            catch (JAXBException e) {
                throw new JMSException(e.getMessage());
            }
            catch (IOException e) {
                throw new JMSException(e.getMessage());
            }
            catch (SAXException e) {
                throw new JMSException(e.getMessage());
            }
        }
        return mbean.getObjectName();
    }

    public ObjectName addConnectionFactory(ConnectionFactoryType type) throws JMSException {
        JMSConnectionFactoryResource mbean = ConnectionFactoryUtil.createFactory(type);
        mbean.start();
        return mbean.getObjectName();
    }

    public synchronized void removeConnectionFactory(String factoryName) throws JMSException {
        this.removeConnectionFactory(factoryName, false);
    }

    public void removeConnectionFactory(String factoryName, boolean save) throws JMSException {
        this.checkConnectionfactoryRemovalPermission();
        ConnectionFactoryUtil.destroyConnectionFactory(factoryName);
        Iterator i = this.config.getFactories().iterator();
        while (i.hasNext()) {
            ConnectionFactoryType descriptor = (ConnectionFactoryType)i.next();
            if (!descriptor.getName().equals(factoryName)) continue;
            i.remove();
            break;
        }
        if (save) {
            try {
                this.config.save(logger.isLoggable(Level.INFO));
            }
            catch (JAXBException e) {
                throw new JMSException(e.getMessage());
            }
            catch (IOException e) {
                throw new JMSException(e.getMessage());
            }
            catch (SAXException e) {
                throw new JMSException(e.getMessage());
            }
        }
    }

    public ObjectName addConnectionFactory(String factoryName, String exportName, int maxThread, String clientID) throws JMSException {
        return this.addConnectionFactory("nonxa", factoryName, exportName, maxThread, clientID);
    }

    public ObjectName addConnectionFactory(String factoryName, String exportName, int maxThread, String clientID, boolean save) throws JMSException {
        return this.addConnectionFactory("nonxa", factoryName, exportName, maxThread, clientID, save);
    }

    public ObjectName addQueueConnectionFactory(String factoryName, String exportName, int maxThread) throws JMSException {
        return this.addConnectionFactory("queue", factoryName, exportName, maxThread, null);
    }

    public ObjectName addQueueConnectionFactory(String factoryName, String exportName, int maxThread, boolean save) throws JMSException {
        return this.addConnectionFactory("queue", factoryName, exportName, maxThread, null, save);
    }

    public ObjectName addTopicConnectionFactory(String factoryName, String exportName, int maxThread, String clientID) throws JMSException {
        return this.addConnectionFactory("topic", factoryName, exportName, maxThread, clientID);
    }

    public ObjectName addTopicConnectionFactory(String factoryName, String exportName, int maxThread, String clientID, boolean save) throws JMSException {
        return this.addConnectionFactory("topic", factoryName, exportName, maxThread, clientID, save);
    }

    public ObjectName addXAConnectionFactory(String factoryName, String exportName, int maxThread, String clientID) throws JMSException {
        return this.addConnectionFactory("xa", factoryName, exportName, maxThread, clientID);
    }

    public ObjectName addXAConnectionFactory(String factoryName, String exportName, int maxThread, String clientID, boolean save) throws JMSException {
        return this.addConnectionFactory("xa", factoryName, exportName, maxThread, clientID, save);
    }

    public ObjectName addXAQueueConnectionFactory(String factoryName, String exportName, int maxThread) throws JMSException {
        return this.addConnectionFactory("xaqueue", factoryName, exportName, maxThread, null);
    }

    public ObjectName addXAQueueConnectionFactory(String factoryName, String exportName, int maxThread, boolean save) throws JMSException {
        return this.addConnectionFactory("xaqueue", factoryName, exportName, maxThread, null, save);
    }

    public ObjectName addXATopicConnectionFactory(String factoryName, String exportName, int maxThread, String clientID) throws JMSException {
        return this.addConnectionFactory("xatopic", factoryName, exportName, maxThread, clientID);
    }

    public ObjectName addXATopicConnectionFactory(String factoryName, String exportName, int maxThread, String clientID, boolean save) throws JMSException {
        return this.addConnectionFactory("xatopic", factoryName, exportName, maxThread, clientID, save);
    }

    public ObjectName addQueueDestination(String destinationName, String jndiName, String brokerName) throws JMSException {
        return this.addDestination((byte)81, destinationName, jndiName, brokerName);
    }

    public ObjectName addQueueDestination(String destinationName, String jndiName, String brokerName, boolean save) throws JMSException {
        return this.addDestination((byte)81, destinationName, jndiName, brokerName, save);
    }

    public ObjectName addTopicDestination(String destinationName, String jndiName, String brokerName) throws JMSException {
        return this.addDestination((byte)84, destinationName, jndiName, brokerName);
    }

    public ObjectName addTopicDestination(String destinationName, String jndiName, String brokerName, boolean save) throws JMSException {
        return this.addDestination((byte)84, destinationName, jndiName, brokerName, save);
    }

    public synchronized ObjectName addDestination(byte type, String name, String exportName, String brokerNameForServerRouting) throws JMSException {
        return this.addDestination(type, name, exportName, brokerNameForServerRouting, false);
    }

    public ObjectName addDestination(byte type, String name, String exportName, String brokerNameForServerRouting, boolean save) throws JMSException {
        this.checkDestinationCreationPermission();
        DestinationManager manager = DestinationUtil.findLocalDestinationManager(name);
        if (manager != null) {
            if (name.endsWith(DEAD_LETTER_QUEUE)) {
                return manager.getObjectName();
            }
            throw new JMSException("Destination '" + name + "' already exists.");
        }
        ObjectName result = this.createDestinationManager(type, name, exportName, brokerNameForServerRouting);
        if (save) {
            try {
                DestinationType descriptor = DestinationUtil.createDestinationType(type, name, exportName, brokerNameForServerRouting);
                this.config.getDestinations().add(descriptor);
                this.config.save(logger.isLoggable(Level.INFO));
            }
            catch (IOException e) {
                throw new JMSException(e.getMessage());
            }
            catch (SAXException e) {
                throw new JMSException(e.getMessage());
            }
            catch (JAXBException e) {
                throw new JMSException(e.getMessage());
            }
        }
        return result;
    }

    private ObjectName createDestinationManager(byte type, String name, String exportName, String brokerName) throws JMSException {
        JeusDestination destination = DestinationFactory.createDestination(type, name, exportName, true, brokerName);
        DestinationManager manager = DestinationUtil.createDestinationManager(destination);
        return manager.getObjectName();
    }

    public ObjectName addDestination(DestinationType destinationType) throws JMSException {
        DestinationManager manager = DestinationUtil.findLocalDestinationManager(destinationType.getName());
        if (manager == null) {
            return this.createDestinationManager(destinationType);
        }
        return manager.getObjectName();
    }

    private ObjectName createDestinationManager(DestinationType destinationType) throws JMSException {
        try {
            destinationType.fillDefault();
        }
        catch (JAXBException e) {
            throw new JMSException(e.getMessage());
        }
        JeusDestination destination = DestinationFactory.createDestination(destinationType);
        DestinationManager manager = DestinationUtil.createDestinationManager(destination);
        return manager.getObjectName();
    }

    public synchronized void removeDestination(String destinationName) throws JMSException {
        this.removeDestination(destinationName, false);
    }

    public void removeDestination(String destinationName, boolean save) throws JMSException {
        this.checkDestinationRemovalPermission();
        DestinationUtil.removeDestination(destinationName);
        Iterator i = this.config.getDestinations().iterator();
        while (i.hasNext()) {
            DestinationType descriptor = (DestinationType)i.next();
            if (!descriptor.getName().equals(destinationName)) continue;
            i.remove();
            break;
        }
        if (save) {
            try {
                this.config.save(logger.isLoggable(Level.INFO));
            }
            catch (JAXBException e) {
                throw new JMSException(e.getMessage());
            }
            catch (IOException e) {
                throw new JMSException(e.getMessage());
            }
            catch (SAXException e) {
                throw new JMSException(e.getMessage());
            }
        }
    }

    public long takeover(String brokerName) throws Exception {
        TakeoverExecutor executor = new TakeoverExecutor(brokerName);
        return executor.takeover();
    }

    public Object[][] getQueuedWorkSizes() {
        DestinationManager[] destManagers = DestinationUtil.getAllDestinationManagers();
        Object[][] pairs = new Object[destManagers.length][2];
        for (int i = 0; i < destManagers.length; ++i) {
            pairs[i][0] = destManagers[i].toString();
            pairs[i][1] = new Integer(destManagers[i].getQueuedWorkSize());
        }
        return pairs;
    }

    public void initAccessLogger() {
        this.accessLogger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms.access");
        try {
            SystemLoggingType logging = this.config.getAccessLog();
            if (logging != null) {
                JeusLoggerConfiguration.configLogger((JeusLogger)((JeusLogger)this.accessLogger), (SystemLoggingType)logging);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Journal getAccessLogger() {
        return this.accessLogger;
    }

    private void checkDestinationCreationPermission() throws JMSException {
        try {
            LoginService.checkPermission((Permission)this.addDestinationPermission);
        }
        catch (Exception e) {
            throw new JMSException(e.toString());
        }
    }

    private void checkDestinationRemovalPermission() throws JMSException {
        try {
            LoginService.checkPermission((Permission)this.removeDestinationPermission);
        }
        catch (Exception e) {
            throw new JMSException(e.toString());
        }
    }

    private void checkConnectionfactoryCreationPermission() throws JMSException {
        try {
            LoginService.checkPermission((Permission)this.addConnectionFactoryPermission);
        }
        catch (Exception e) {
            throw new JMSException("not enough permission to remove connection factory");
        }
    }

    private void checkConnectionfactoryRemovalPermission() throws JMSException {
        try {
            LoginService.checkPermission((Permission)this.removeConnectionFactoryPermission);
        }
        catch (Exception e) {
            throw new JMSException("not enough permission to remove connection factory");
        }
    }

    public void shutdown() {
        Scheduler.shutdown();
        JMSBroker.getLocalBroker().shutdown();
        TransactionManager.getInstance().shutdown();
        SubscriptionUtil.shutdown();
        DestinationUtil.shutdown();
        StorageManager.shutdown();
        ConnectionFactoryUtil.shutdown();
        AdministeredObjectBinder.shutdown();
        ThreadPoolManager.shutdown();
        this.destroyMBean();
    }

    public void printMemoryLogs() {
        Handler[] handlers = JeusLogger.getLogger((String)"jeus.jms").getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            if (!(handler instanceof MemoryHandler)) continue;
            ((MemoryHandler)((Object)handler)).printRecords();
        }
    }

    public void setStorageDebug(boolean enable, String level) {
        StorageManager.getCurrentStorage().setDebug(enable, level);
    }
}

