/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.mbean;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.JMSEndpointStats;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.TimeStatistic;
import jeus.jms.server.JMSSession;
import jeus.jms.server.mbean.JMSConnectionResource;
import jeus.jms.server.mbean.JMSSessionResourceMBean;
import jeus.jms.server.mbean.stats.JMSSessionStatsImpl;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEResource;
import jeus.management.j2ee.statistics.StatisticImpl;

public class JMSSessionResource
extends J2EEResource
implements JMSSessionResourceMBean {
    private final JMSConnectionResource parent;
    private final JMSSession target;
    private final JMSSessionStatsImpl stats;
    private final Vector consumers;
    private final Vector producers;

    public static JMSSessionResource createMBean(String mBeanName, JMSConnectionResource parent, JMSSession target) throws InstanceAlreadyExistsException {
        JMSSessionResource resource = new JMSSessionResource(parent, target);
        resource.createMBean(mBeanName, "JeusService", parent.getObjectName(), JMSSessionResourceMBean.parentKeyMap, "JMSSessionResource");
        return resource;
    }

    public JMSSessionResource(JMSConnectionResource parent, JMSSession target) {
        this.parent = parent;
        this.target = target;
        this.stats = new JMSSessionStatsImpl();
        this.consumers = new Vector();
        this.producers = new Vector();
    }

    protected String initPermissionName() {
        return this.parent.getPermissionName() + ".S" + this.target.getSessionID();
    }

    public Stats getstats() {
        return this.stats;
    }

    public void addChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType((ObjectName)pChild);
        if (lType.equals("JMSConsumerResource")) {
            this.consumers.add(pChild);
        } else {
            this.producers.add(pChild);
        }
        super.addChild(pChild);
    }

    public void removeChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType((ObjectName)pChild);
        if (lType.equals("JMSConsumerResource")) {
            this.consumers.remove(pChild);
        } else {
            this.producers.remove(pChild);
        }
        super.removeChild(pChild);
    }

    public List getJMSEndPointConsumerNames() {
        return new ArrayList(this.consumers);
    }

    public List getJMSEndPointProducerNames() {
        return new ArrayList(this.producers);
    }

    public void addJMSProducerStats(JMSEndpointStats stats) {
        this.stats.addJMSProducerStats(stats);
    }

    public void removeJMSProducerStats(JMSEndpointStats stats) {
        this.stats.removeJMSProducerStats(stats);
    }

    public void addJMSConsumerStats(JMSEndpointStats stats) {
        this.stats.addJMSConsumerStats(stats);
    }

    public void removeJMSConsumerStats(JMSEndpointStats stats) {
        this.stats.removeJMSConsumerStats(stats);
    }

    public void setStatistic(StatisticImpl statistic) {
        this.stats.setStatistic((Statistic)statistic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getDurableSubscriptionCount() {
        CountStatistic stat = this.stats.getDurableSubscriptionCount();
        if (stat != null) {
            return stat;
        }
        JMSSessionStatsImpl jMSSessionStatsImpl = this.stats;
        synchronized (jMSSessionStatsImpl) {
            stat = this.stats.getDurableSubscriptionCount();
            if (stat != null) {
                return stat;
            }
            return this.stats.createDurableSubscriptionCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getExpiredMessageCount() {
        CountStatistic stat = this.stats.getExpiredMessageCount();
        if (stat != null) {
            return stat;
        }
        JMSSessionStatsImpl jMSSessionStatsImpl = this.stats;
        synchronized (jMSSessionStatsImpl) {
            stat = this.stats.getExpiredMessageCount();
            if (stat != null) {
                return stat;
            }
            return this.stats.createExpiredMessageCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getMessageCount() {
        CountStatistic stat = this.stats.getMessageCount();
        if (stat != null) {
            return stat;
        }
        JMSSessionStatsImpl jMSSessionStatsImpl = this.stats;
        synchronized (jMSSessionStatsImpl) {
            stat = this.stats.getMessageCount();
            if (stat != null) {
                return stat;
            }
            return this.stats.createMessageCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getPendingMessageCount() {
        CountStatistic stat = this.stats.getPendingMessageCount();
        if (stat != null) {
            return stat;
        }
        JMSSessionStatsImpl jMSSessionStatsImpl = this.stats;
        synchronized (jMSSessionStatsImpl) {
            stat = this.stats.getPendingMessageCount();
            if (stat != null) {
                return stat;
            }
            return this.stats.createPendingMessageCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeStatistic getMessageWaitTime() {
        TimeStatistic stat = this.stats.getMessageWaitTime();
        if (stat != null) {
            return stat;
        }
        JMSSessionStatsImpl jMSSessionStatsImpl = this.stats;
        synchronized (jMSSessionStatsImpl) {
            stat = this.stats.getMessageWaitTime();
            if (stat != null) {
                return stat;
            }
            return this.stats.createMessageWaitTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeStatistic getSendTime() {
        TimeStatistic stat = this.stats.getSendTime();
        if (stat != null) {
            return stat;
        }
        JMSSessionStatsImpl jMSSessionStatsImpl = this.stats;
        synchronized (jMSSessionStatsImpl) {
            stat = this.stats.getSendTime();
            if (stat != null) {
                return stat;
            }
            return this.stats.createSendTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getCommitCount() {
        CountStatistic stat = this.stats.getCommitCount();
        if (stat != null) {
            return stat;
        }
        JMSSessionStatsImpl jMSSessionStatsImpl = this.stats;
        synchronized (jMSSessionStatsImpl) {
            stat = this.stats.getCommitCount();
            if (stat != null) {
                return stat;
            }
            return this.stats.createCommitCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getRollbackCount() {
        CountStatistic stat = this.stats.getRollbackCount();
        if (stat != null) {
            return stat;
        }
        JMSSessionStatsImpl jMSSessionStatsImpl = this.stats;
        synchronized (jMSSessionStatsImpl) {
            stat = this.stats.getRollbackCount();
            if (stat != null) {
                return stat;
            }
            return this.stats.createRollbackCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getTransactionCount() {
        CountStatistic stat = this.stats.getTransactionCount();
        if (stat != null) {
            return stat;
        }
        JMSSessionStatsImpl jMSSessionStatsImpl = this.stats;
        synchronized (jMSSessionStatsImpl) {
            stat = this.stats.getTransactionCount();
            if (stat != null) {
                return stat;
            }
            return this.stats.createTransactionCount();
        }
    }

    public String getName() {
        return this.target.toString();
    }

    public String getDigest() {
        return this.target.getDigest();
    }

    public String toString() {
        return this.target.toString();
    }
}

