/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.message;

import java.io.IOException;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageFactory;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.util.MemoryBufferInputStream;
import jeus.jms.server.message.ServerMessage;
import jeus.nio.ByteBufferWrapper;

public class ServerMessageFactory
extends MessageFactory {
    public static MessageContainer createMessage(byte[] data) throws IOException {
        ByteBufferWrapper buffer = ByteBufferWrapper.wrap(false, data);
        return ServerMessageFactory.createMessage(buffer);
    }

    public static MessageContainer createMessage(ByteBufferWrapper buffer) throws IOException {
        MemoryBufferInputStream in = new MemoryBufferInputStream(buffer);
        MetaHeader metaHeader = new MetaHeader(in);
        return ServerMessageFactory.createMessage(metaHeader, buffer);
    }

    public static MessageContainer createMessage(MetaHeader metaHeader, ByteBufferWrapper buffer) throws IOException {
        if (metaHeader.isAdminMessage()) {
            MemoryBufferInputStream in = new MemoryBufferInputStream(buffer);
            return ServerMessageFactory.createAdminMessage(metaHeader, in);
        }
        return ServerMessageFactory.createServerMessage(metaHeader, buffer);
    }

    public static ServerMessage createServerMessage(MetaHeader metaHeader, ByteBufferWrapper buffer) throws IOException {
        return new ServerMessage(metaHeader, buffer);
    }

    public static ServerMessage createServerMessage(ByteBufferWrapper buffer) throws IOException {
        return new ServerMessage(new MetaHeader(), buffer);
    }
}

