/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence;

import javax.jms.JMSException;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.server.config.DurableSubscriptionConfig;
import jeus.jms.server.manager.SubscriptionUtil;
import jeus.jms.server.persistence.CommonArchive;
import jeus.jms.server.persistence.DurableSubscriberRecoveryListener;
import jeus.jms.server.persistence.Storage;
import jeus.jms.server.persistence.StorageException;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class DurableSubscriberArchive
extends CommonArchive
implements DurableSubscriberRecoveryListener {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public DurableSubscriberArchive(Storage storage) throws Exception {
        super(storage);
    }

    public void init() throws Exception {
        super.init();
        this.storage.recover(this);
    }

    public void recovered(long id, DurableSubscriptionConfig config) {
        block3: {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5651_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5651_LEVEL, JeusMessage_JMS5._5651, new Long(id));
            }
            this.sequencer.set(Math.max(this.sequencer.get(), id));
            try {
                SubscriptionUtil.restoredDurableSubscription(config);
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5652_LEVEL)) break block3;
                LogUtils.log(logger, JeusMessage_JMS5._5652_LEVEL, JeusMessage_JMS5._5652, new Long(id));
            }
        }
    }

    public void beginRecovery() {
    }

    public void endRecovery() throws Exception {
    }

    public void persist(DurableSubscriptionConfig config) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5653_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5653_LEVEL, JeusMessage_JMS5._5653, config.toString());
        }
        try {
            this.storage.persist(config);
        }
        catch (StorageException e) {
            throw JMSExceptionFactory.createJMSException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void update(JeusDestination destination, DurableSubscriptionConfig config) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5654_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5654_LEVEL, JeusMessage_JMS5._5654, config.toString());
        }
        try {
            this.storage.update(destination, config);
        }
        catch (StorageException e) {
            throw JMSExceptionFactory.createJMSException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public boolean delete(long id) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5655_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5655_LEVEL, JeusMessage_JMS5._5655, new Long(id));
        }
        try {
            this.storage.deleteDurableSubscriber(id);
            return true;
        }
        catch (StorageException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5656_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5656_LEVEL, JeusMessage_JMS5._5656, (Throwable)((Object)e));
            }
            return false;
        }
    }
}

