/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence;

import java.io.IOException;
import javax.transaction.xa.XAException;
import jeus.jms.common.LifeCycle;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.common.message.MessageID;
import jeus.jms.server.config.DurableSubscriptionConfig;
import jeus.jms.server.message.ServerMessage;
import jeus.jms.server.persistence.DestinationRecoveryListener;
import jeus.jms.server.persistence.DurableSubscriberRecoveryListener;
import jeus.jms.server.persistence.GlobalTransactionContext;
import jeus.jms.server.persistence.LocalTransactionContext;
import jeus.jms.server.persistence.MessageRecoveryListener;
import jeus.jms.server.persistence.StorageCursor;
import jeus.jms.server.persistence.StorageException;
import jeus.jms.server.persistence.StorageTransactionContext;
import jeus.jms.server.persistence.XALogger;
import jeus.jms.server.transaction.TransactionalWorks;

public interface Storage
extends LifeCycle {
    public void recover(DestinationRecoveryListener var1) throws StorageException;

    public void recover(DurableSubscriberRecoveryListener var1) throws StorageException;

    public void recover(MessageRecoveryListener var1) throws StorageException;

    public void persist(JeusDestination var1) throws StorageException;

    public void persist(DurableSubscriptionConfig var1) throws StorageException;

    public StorageCursor createStorageCursor(ServerMessage var1);

    public void update(JeusDestination var1) throws StorageException;

    public void update(JeusDestination var1, DurableSubscriptionConfig var2) throws StorageException;

    public void deleteDestination(JeusDestination var1) throws StorageException;

    public void deleteDurableSubscriber(long var1) throws StorageException;

    public void deleteAllMessages(JeusDestination var1) throws StorageException;

    public void deleteAllMessages(long var1) throws StorageException;

    public void deleteStaleMessages(JeusDestination var1) throws StorageException;

    public boolean deleteMessage(long var1, boolean var3);

    public boolean deleteDurableMessage(long var1, long var3);

    public boolean enqueue(long var1, long var3, boolean var5);

    public boolean enqueued(long var1);

    public void prepareProduce(StorageTransactionContext var1, long var2, long var4, ServerMessage var6, byte var7) throws StorageException;

    public boolean distributed(long var1);

    public boolean dispatched(long var1);

    public boolean dispatched(long var1, long var3);

    public boolean expired(long var1, boolean var3);

    public boolean completed(long var1, boolean var3);

    public boolean prepareConsume(StorageTransactionContext var1, long var2) throws StorageException;

    public boolean completed(long var1, long var3);

    public boolean prepareConsume(StorageTransactionContext var1, long var2, long var4) throws StorageException;

    public boolean supportsXA();

    public boolean supportsLocalTransaction();

    public LocalTransactionContext createLocalTransactionContext() throws StorageException;

    public byte getMessageLifecycle(MessageID var1) throws StorageException;

    public byte getDurableMessageLifecycle(long var1, MessageID var3) throws StorageException;

    public GlobalTransactionContext createGlobalTransactionContext(TransactionalWorks var1) throws XAException;

    public XALogger getXALogger();

    public long sync() throws IOException;

    public long getLastSyncTime();

    public boolean isDeleteInvalidDestinations();

    public void handleXAException(XAException var1);

    public boolean isNull();

    public void setDebug(boolean var1, String var2);
}

