/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database;

import java.io.IOException;
import jeus.jms.server.persistence.StorageCursor;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.command.GetMessageContentCommand;
import jeus.nio.ByteBufferWrapper;

public class DatabaseCursor
implements StorageCursor {
    private DatabaseStorage storage;
    private long id;
    private ByteBufferWrapper buffer;

    public DatabaseCursor(DatabaseStorage storage, long id) {
        this.storage = storage;
        this.id = id;
    }

    public boolean isPersistent() {
        return true;
    }

    public ByteBufferWrapper getContent(final boolean direct) throws IOException {
        if (this.buffer == null) {
            GetMessageContentCommand command = new GetMessageContentCommand(this.storage, this.id, new GetMessageContentCommand.ContentListener(){

                public void contentLoaded(byte[] content) {
                    if (content == null) {
                        content = new byte[]{};
                    }
                    DatabaseCursor.this.buffer = ByteBufferWrapper.wrap(direct, content);
                }
            });
            this.storage.executeWithIOException(command);
        }
        return this.buffer;
    }

    public void clear() {
        this.buffer = null;
    }
}

