/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import jeus.jms.server.persistence.GlobalTransactionContext;
import jeus.jms.server.persistence.database.DatabasePlatformFinder;
import jeus.jms.server.persistence.database.LongString;
import jeus.util.logging.JeusLogger;

public class DatabasePlatform {
    protected static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms.persistence");
    protected int majorDriverVersion;
    protected int minorDriverVersion;
    protected int majorDatabaseVersion;
    protected int minorDatabaseVersion;
    private Map typeNames;
    private Map sqlTypes;
    private boolean supportsXA;
    private boolean supportsLocalTransaction;

    protected DatabasePlatform() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DatabasePlatform getPlatform(DataSource dataSource) throws Exception {
        Connection conn = dataSource.getConnection();
        try {
            String productName = conn.getMetaData().getDatabaseProductName();
            DatabasePlatform databasePlatform = DatabasePlatform.getPlatform(dataSource, conn, productName);
            return databasePlatform;
        }
        finally {
            conn.close();
        }
    }

    static DatabasePlatform getPlatform(DataSource dataSource, Connection conn, String vendorName) throws Exception {
        String platformClassName = DatabasePlatformFinder.findPlatform(vendorName);
        Class<?> cls = DatabasePlatform.class.getClassLoader().loadClass(platformClassName);
        DatabasePlatform platform = (DatabasePlatform)cls.newInstance();
        platform.init(dataSource, conn);
        return platform;
    }

    public void init(DataSource dataSource, Connection con) throws Exception {
        DatabaseMetaData metaData = con.getMetaData();
        this.majorDriverVersion = metaData.getDriverMajorVersion();
        this.minorDriverVersion = metaData.getDriverMinorVersion();
        this.majorDatabaseVersion = metaData.getDatabaseMajorVersion();
        this.minorDatabaseVersion = metaData.getDatabaseMinorVersion();
        this.supportsLocalTransaction = metaData.supportsTransactions();
        this.supportsXA = this.supportsXA(dataSource);
    }

    protected boolean supportsXA(DataSource dataSource) {
        return dataSource instanceof XADataSource;
    }

    public boolean supportsSetTransactionTimeout() {
        return true;
    }

    public String getTypeName(Class c) {
        String fieldType;
        if (c == null) {
            throw new IllegalArgumentException("Type class is null.");
        }
        if (this.typeNames == null) {
            this.typeNames = this.buildTypeNames();
        }
        if ((fieldType = (String)this.typeNames.get(c)) == null) {
            throw new IllegalArgumentException("Unble to find database field type for '" + c.getName() + "'.");
        }
        return fieldType;
    }

    protected Map buildTypeNames() {
        HashMap<Class<Time>, String> fieldTypeMapping = new HashMap<Class<Time>, String>();
        fieldTypeMapping.put(Boolean.class, "BIT");
        fieldTypeMapping.put(Integer.class, "INTEGER");
        fieldTypeMapping.put(Long.class, "BIGINT");
        fieldTypeMapping.put(Float.class, "FLOAT");
        fieldTypeMapping.put(Double.class, "DOUBLE");
        fieldTypeMapping.put(Short.class, "SMALLINT");
        fieldTypeMapping.put(Byte.class, "TINYINT");
        fieldTypeMapping.put(BigInteger.class, "NUMERIC(19)");
        fieldTypeMapping.put(BigDecimal.class, "NUMERIC(19)");
        fieldTypeMapping.put(LongString.class, "VARCHAR(" + this.getMaxStringLength() + ")");
        fieldTypeMapping.put(String.class, "VARCHAR(255)");
        fieldTypeMapping.put(Character.class, "CHAR(1)");
        fieldTypeMapping.put(Byte[].class, "BLOB");
        fieldTypeMapping.put(Character[].class, "CLOB");
        fieldTypeMapping.put(byte[].class, "BLOB");
        fieldTypeMapping.put(char[].class, "CLOB");
        fieldTypeMapping.put(Blob.class, "BLOB");
        fieldTypeMapping.put(Clob.class, "CLOB");
        fieldTypeMapping.put(Date.class, "DATE");
        fieldTypeMapping.put(Timestamp.class, "TIMESTAMP");
        fieldTypeMapping.put(Time.class, "TIME");
        return fieldTypeMapping;
    }

    public int getSqlType(Class c) {
        Integer sqlType;
        if (c == null) {
            throw new IllegalArgumentException("Type class is null.");
        }
        if (this.sqlTypes == null) {
            this.sqlTypes = this.buildSqlTypes();
        }
        if ((sqlType = (Integer)this.sqlTypes.get(c)) == null) {
            throw new IllegalArgumentException("Unble to find database field type for '" + c.getName() + "'.");
        }
        return sqlType;
    }

    protected Map buildSqlTypes() {
        HashMap<Class<Time>, Integer> sqlTypeMapping = new HashMap<Class<Time>, Integer>();
        sqlTypeMapping.put(Boolean.class, new Integer(-6));
        sqlTypeMapping.put(Integer.class, new Integer(4));
        sqlTypeMapping.put(Long.class, new Integer(-5));
        sqlTypeMapping.put(Float.class, new Integer(6));
        sqlTypeMapping.put(Double.class, new Integer(8));
        sqlTypeMapping.put(Short.class, new Integer(5));
        sqlTypeMapping.put(Byte.class, new Integer(-6));
        sqlTypeMapping.put(BigInteger.class, new Integer(2));
        sqlTypeMapping.put(BigDecimal.class, new Integer(2));
        sqlTypeMapping.put(LongString.class, new Integer(12));
        sqlTypeMapping.put(String.class, new Integer(12));
        sqlTypeMapping.put(Character.class, new Integer(1));
        sqlTypeMapping.put(Byte[].class, new Integer(2004));
        sqlTypeMapping.put(Character[].class, new Integer(2005));
        sqlTypeMapping.put(byte[].class, new Integer(2004));
        sqlTypeMapping.put(char[].class, new Integer(2005));
        sqlTypeMapping.put(Blob.class, new Integer(2004));
        sqlTypeMapping.put(Clob.class, new Integer(2005));
        sqlTypeMapping.put(Date.class, new Integer(91));
        sqlTypeMapping.put(Timestamp.class, new Integer(93));
        sqlTypeMapping.put(Time.class, new Integer(92));
        return sqlTypeMapping;
    }

    public String getTrue() {
        return "1";
    }

    public String getFalse() {
        return "0";
    }

    public String getTableAlias(String tableName, String alias) {
        return tableName + " " + alias;
    }

    public boolean checkTable(String name, Connection con) throws SQLException {
        return false;
    }

    public void writeBlobData(Blob blob, byte[] data) throws Exception {
    }

    public void setEmptyBlob(PreparedStatement stmt, int index) throws Exception {
        stmt.setBytes(index, new byte[0]);
    }

    public boolean canSetBytes(byte[] data) {
        return true;
    }

    public void handleXAException(XAException e) {
        e.printStackTrace();
    }

    public Connection getConnection(DataSource dataSource) throws SQLException {
        return dataSource.getConnection();
    }

    public XAConnection getXAConnection(DataSource dataSource) throws SQLException {
        return ((XADataSource)((Object)dataSource)).getXAConnection();
    }

    public void releaseConnection(DataSource dataSource, Connection connection) throws SQLException {
        connection.close();
    }

    public void releaseXAConnection(DataSource dataSource, XAConnection xaConnection, Connection connection) throws SQLException {
        if (connection != null) {
            connection.close();
        }
        if (xaConnection != null) {
            xaConnection.close();
        }
    }

    public boolean supportsXA() {
        return this.supportsXA;
    }

    public boolean supportsLocalTransaction() {
        return this.supportsLocalTransaction;
    }

    public Xid createXid(Xid xid) throws XAException {
        return xid;
    }

    public Xid[] recover(GlobalTransactionContext context) throws XAException {
        return context.recover(0x1800000);
    }

    public void exclusiveLockOnTable(Connection conn, String tableName) throws SQLException {
    }

    public int getMaxStringLength() {
        return 255;
    }

    public void setDebug(boolean enable, String level) {
    }
}

