/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class DatabasePlatformFinder {
    private static final String DEFAULTPLATFORM = "jeus.jms.server.persistence.database.DatabasePlatform";
    private static final String PROPERTY_PATH = "jeus/jms/server/persistence/database/";
    private static final String PLATFORM_RESOURCE_NAME = "jeus/jms/server/persistence/database/platform.properties";
    private static Properties props = null;

    public static String findPlatform(String vendorName) {
        DatabasePlatformFinder.initializeNameToVendorPlatform();
        String detectedDbPlatform = null;
        if (vendorName != null) {
            detectedDbPlatform = DatabasePlatformFinder.matchVendorNameInProperties(vendorName, props);
        }
        if (detectedDbPlatform == null) {
            detectedDbPlatform = DEFAULTPLATFORM;
        }
        return detectedDbPlatform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties initializeNameToVendorPlatform() {
        Class<DatabasePlatformFinder> clazz = DatabasePlatformFinder.class;
        synchronized (DatabasePlatformFinder.class) {
            if (props == null) {
                props = new Properties();
                try {
                    DatabasePlatformFinder.loadFromResource(props, PLATFORM_RESOURCE_NAME, DatabasePlatformFinder.class.getClassLoader());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return props;
        }
    }

    private static String matchVendorNameInProperties(String vendorName, Properties nameToVendorPlatform) {
        String dbPlatform = null;
        Iterator<Map.Entry<Object, Object>> iterator = nameToVendorPlatform.entrySet().iterator();
        while (dbPlatform == null && iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String regExpr = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!vendorName.equals(regExpr) && vendorName.toLowerCase().indexOf(regExpr) == -1) continue;
            dbPlatform = value;
        }
        return dbPlatform;
    }

    private static void loadFromResource(Properties properties, String resourceName, ClassLoader classLoader) throws IOException {
        DatabasePlatformFinder.load(properties, resourceName, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(Properties properties, String resourceName, ClassLoader classLoader) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(DatabasePlatformFinder.openResourceInputStream(resourceName, classLoader));
        try {
            properties.load(bin);
        }
        finally {
            try {
                ((InputStream)bin).close();
            }
            catch (Exception e) {}
        }
    }

    private static InputStream openResourceInputStream(final String resourceName, final ClassLoader classLoader) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(resourceName);
                }
                return ClassLoader.getSystemResourceAsStream(resourceName);
            }
        });
    }
}

