/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.jms.InvalidDestinationException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import jeus.jms.common.LifeCycle;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.util.BooleanAdaptor;
import jeus.jms.common.util.ByteAdaptor;
import jeus.jms.common.util.DataSqueezer;
import jeus.jms.common.util.DoubleAdaptor;
import jeus.jms.common.util.FloatAdaptor;
import jeus.jms.common.util.IntegerAdaptor;
import jeus.jms.common.util.LongAdaptor;
import jeus.jms.common.util.ShortAdaptor;
import jeus.jms.common.util.StringAdaptor;
import jeus.jms.server.config.DurableSubscriptionConfig;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.message.ServerMessage;
import jeus.jms.server.persistence.DestinationRecoveryListener;
import jeus.jms.server.persistence.DurableSubscriberRecoveryListener;
import jeus.jms.server.persistence.GlobalTransactionContext;
import jeus.jms.server.persistence.LifecycleLogger;
import jeus.jms.server.persistence.LocalTransactionContext;
import jeus.jms.server.persistence.MessageRecoveryListener;
import jeus.jms.server.persistence.ReliabilityLevel;
import jeus.jms.server.persistence.Storage;
import jeus.jms.server.persistence.StorageCursor;
import jeus.jms.server.persistence.StorageException;
import jeus.jms.server.persistence.StorageTransactionContext;
import jeus.jms.server.persistence.XALogger;
import jeus.jms.server.persistence.database.DatabaseConstants;
import jeus.jms.server.persistence.database.DatabaseCursor;
import jeus.jms.server.persistence.database.DatabaseLifecycleLogger;
import jeus.jms.server.persistence.database.DatabasePlatform;
import jeus.jms.server.persistence.database.DatabaseXALogger;
import jeus.jms.server.persistence.database.GlobalDatabaseTransactionContext;
import jeus.jms.server.persistence.database.LocalDatabaseTransactionContext;
import jeus.jms.server.persistence.database.SQLCommand;
import jeus.jms.server.persistence.database.SQLCommandExecutor;
import jeus.jms.server.persistence.database.Trashcan;
import jeus.jms.server.persistence.database.command.CheckDurableMessageCommand;
import jeus.jms.server.persistence.database.command.CompositeSQLCommand;
import jeus.jms.server.persistence.database.command.ConditionalSQLCommand;
import jeus.jms.server.persistence.database.command.DeleteDestinationCommand;
import jeus.jms.server.persistence.database.command.DeleteDurableMessageCommand;
import jeus.jms.server.persistence.database.command.DeleteDurableMessagesCommand;
import jeus.jms.server.persistence.database.command.DeleteDurableSubscriberCommand;
import jeus.jms.server.persistence.database.command.DeleteDurableSubscribersCommand;
import jeus.jms.server.persistence.database.command.DeleteMessageCommand;
import jeus.jms.server.persistence.database.command.DeleteMessagesCommand;
import jeus.jms.server.persistence.database.command.DeleteStaleMessagesCommand;
import jeus.jms.server.persistence.database.command.GetDurableMessageLifecycleCommand;
import jeus.jms.server.persistence.database.command.GetMessageLifecycleCommand;
import jeus.jms.server.persistence.database.command.InsertDestinationCommand;
import jeus.jms.server.persistence.database.command.InsertDurableMessageCommand;
import jeus.jms.server.persistence.database.command.InsertDurableSubscriberCommand;
import jeus.jms.server.persistence.database.command.InsertMessageCommand;
import jeus.jms.server.persistence.database.command.MakeDestinationInvalidCommand;
import jeus.jms.server.persistence.database.command.RecoverDestinationCommand;
import jeus.jms.server.persistence.database.command.RecoverDurableMessageCommand;
import jeus.jms.server.persistence.database.command.RecoverDurableSubscriberCommand;
import jeus.jms.server.persistence.database.command.RecoverMessageCommand;
import jeus.jms.server.persistence.database.command.UpdateDestinationCommand;
import jeus.jms.server.persistence.database.command.UpdateDestinationVersionCommand;
import jeus.jms.server.persistence.database.command.UpdateDurableMessageLifeCycleCommand;
import jeus.jms.server.persistence.database.command.UpdateDurableSubscriberCommand;
import jeus.jms.server.persistence.database.command.UpdateMessageLifeCycleCommand;
import jeus.jms.server.transaction.TransactionalWorks;
import jeus.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import jeus.util.concurrent.Sync;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class DatabaseStorage
implements Storage,
LifeCycle,
DatabaseConstants {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private DatabasePlatform platform;
    private DataSource dataSource;
    private String destinationTableName;
    private String durableSubscriberTableName;
    private String messageTableName;
    private String userPropertyTableName;
    private String durableMessageTableName;
    private String xaTableName;
    private boolean deleteInvalidDestinations;
    private SQLCommandExecutor sqlExecutor;
    private Trashcan trashcan;
    private LifecycleLogger lifecycleLogger;
    private XALogger xaLogger;
    private long lastSyncTime;
    private long lastExecuteTime = System.currentTimeMillis();
    private ReliabilityLevel level;
    private ReentrantWriterPreferenceReadWriteLock lock;
    private DataSqueezer dataSqueezer;

    public DatabaseStorage(DataSource dataSource, String destinationTableName, String durableSubscriberTableName, String messageTableName, String userPropertyTableName, String durableMessageTableName, String xaTableName, boolean deleteInvalidDestinations, long sqlPoolTimeout, boolean waitSqlExecutor, ReliabilityLevel level) {
        this.dataSource = dataSource;
        this.destinationTableName = destinationTableName;
        this.durableSubscriberTableName = durableSubscriberTableName;
        this.messageTableName = messageTableName;
        this.userPropertyTableName = userPropertyTableName;
        this.durableMessageTableName = durableMessageTableName;
        this.xaTableName = xaTableName;
        this.deleteInvalidDestinations = deleteInvalidDestinations;
        this.sqlExecutor = new SQLCommandExecutor(this, "SQLExecutor", sqlPoolTimeout, waitSqlExecutor);
        this.level = level;
        this.lifecycleLogger = this.createLifecycleLogger();
        this.xaLogger = this.createXALogger();
        this.trashcan = new Trashcan(this);
        this.lock = new ReentrantWriterPreferenceReadWriteLock();
        this.dataSqueezer = new DataSqueezer();
        this.dataSqueezer.register(new BooleanAdaptor());
        this.dataSqueezer.register(new ByteAdaptor());
        this.dataSqueezer.register(new ShortAdaptor());
        this.dataSqueezer.register(new IntegerAdaptor());
        this.dataSqueezer.register(new LongAdaptor());
        this.dataSqueezer.register(new FloatAdaptor());
        this.dataSqueezer.register(new DoubleAdaptor());
        this.dataSqueezer.register(new StringAdaptor());
    }

    private LifecycleLogger createLifecycleLogger() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5561_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5561_LEVEL, JeusMessage_JMS5._5561, this.level.toString());
        }
        return new DatabaseLifecycleLogger(this.level, this);
    }

    private XALogger createXALogger() {
        return new DatabaseXALogger(this);
    }

    public boolean executeWithoutException(SQLCommand command) {
        try {
            this.execute(command);
            return true;
        }
        catch (Exception e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5562_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5562_LEVEL, JeusMessage_JMS5._5562, command.getName(), (Throwable)e);
            }
            return false;
        }
    }

    public void executeWithoutException(StorageTransactionContext context, SQLCommand command) {
        block2: {
            try {
                this.execute(context, command);
            }
            catch (Exception e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5563_LEVEL)) break block2;
                LogUtils.log(logger, JeusMessage_JMS5._5563_LEVEL, JeusMessage_JMS5._5563, command.getName(), (Throwable)e);
            }
        }
    }

    public void executeWithStorageException(SQLCommand command) throws StorageException {
        try {
            this.execute(command);
        }
        catch (Exception e) {
            StorageException.throwStorageException(e);
        }
    }

    public void executeWithIOException(SQLCommand command) throws IOException {
        try {
            this.execute(command);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    public void executeWithStorageException(StorageTransactionContext context, SQLCommand command) throws StorageException {
        try {
            this.execute(context, command);
        }
        catch (Exception e) {
            StorageException.throwStorageException(e);
        }
    }

    public void execute(SQLCommand command) throws StorageException {
        this.sqlExecutor.execute(command);
    }

    public void execute(StorageTransactionContext context, SQLCommand command) throws StorageException {
        this.execute(context, command, false);
    }

    public void execute(StorageTransactionContext context, SQLCommand command, boolean exclusive) throws StorageException {
        Sync sync = exclusive ? this.lock.writeLock() : this.lock.readLock();
        boolean acquired = false;
        try {
            sync.acquire();
            acquired = true;
            this.sqlExecutor.execute(context, command);
        }
        catch (InterruptedException e) {
            throw new StorageException(e.getMessage());
        }
        finally {
            if (acquired) {
                sync.release();
            }
        }
    }

    public LifecycleLogger getLifecycleLogger() {
        return this.lifecycleLogger;
    }

    public XALogger getXALogger() {
        return this.xaLogger;
    }

    public void recover(DestinationRecoveryListener listener) throws StorageException {
        RecoverDestinationCommand command = new RecoverDestinationCommand(this, listener);
        this.execute(null, command, true);
    }

    public void recover(DurableSubscriberRecoveryListener listener) throws StorageException {
        RecoverDurableSubscriberCommand command = new RecoverDurableSubscriberCommand(this, listener);
        this.execute(null, command, true);
    }

    public void recover(MessageRecoveryListener listener) throws StorageException {
        CompositeSQLCommand command = new CompositeSQLCommand("RECOVER_MESSAGE", this, new SQLCommand[]{new RecoverMessageCommand(this, listener), new RecoverDurableMessageCommand(this, listener)});
        this.execute(null, command, true);
    }

    public void persist(JeusDestination destination) throws StorageException {
        long version = System.currentTimeMillis();
        InsertDestinationCommand command = new InsertDestinationCommand(this, destination, version);
        this.execute(command);
        destination.setVersion(version);
    }

    public void persist(DurableSubscriptionConfig config) throws StorageException {
        DestinationManager manager = null;
        try {
            manager = DestinationUtil.getLocalDestinationManager(config.getDestinationName());
        }
        catch (InvalidDestinationException e) {
            StorageException.throwStorageException((Exception)((Object)e));
        }
        InsertDurableSubscriberCommand command = new InsertDurableSubscriberCommand(this, config, manager.getId());
        this.execute(command);
    }

    public void prepareProduce(StorageTransactionContext context, long destinationId, long version, ServerMessage message, byte lifeCycle) throws StorageException {
        InsertMessageCommand command = new InsertMessageCommand(this, destinationId, version, message, lifeCycle);
        this.execute(context, command);
    }

    public StorageCursor createStorageCursor(ServerMessage message) {
        return new DatabaseCursor(this, message.getId());
    }

    public boolean enqueue(long messageId, long durableSubscriberId, boolean recovered) {
        InsertDurableMessageCommand command = new InsertDurableMessageCommand(this, messageId, durableSubscriberId);
        if (recovered) {
            CheckDurableMessageCommand booleanCommand = new CheckDurableMessageCommand(this, messageId, durableSubscriberId);
            return this.executeWithoutException(new ConditionalSQLCommand(this, booleanCommand, command));
        }
        return this.executeWithoutException(command);
    }

    public boolean enqueued(long messageId) {
        return this.lifecycleLogger.enqueued(messageId);
    }

    public boolean distributed(long messageId) {
        return this.lifecycleLogger.distributed(messageId);
    }

    public boolean dispatched(long messageId) {
        return this.lifecycleLogger.dispatched(messageId);
    }

    public boolean dispatched(long messageId, long durableSubscriberId) {
        return this.lifecycleLogger.dispatched(messageId, durableSubscriberId);
    }

    public boolean completed(long messageId, boolean queue) {
        return this.deleteMessage(messageId, queue);
    }

    public boolean completed(long messageId, long durableSubscriberId) {
        return this.deleteDurableMessage(messageId, durableSubscriberId);
    }

    public boolean expired(long messageId, boolean queue) {
        return this.deleteMessage(messageId, queue);
    }

    public boolean prepareConsume(StorageTransactionContext context, long messageId, long durableSubscriberId) throws StorageException {
        DeleteDurableMessageCommand command = new DeleteDurableMessageCommand(this, messageId, durableSubscriberId);
        this.execute(context, command);
        return true;
    }

    public boolean prepareConsume(StorageTransactionContext context, long messageId) throws StorageException {
        DeleteMessageCommand command = new DeleteMessageCommand(this, messageId);
        this.execute(context, command);
        return true;
    }

    public void update(JeusDestination destination) throws StorageException {
        UpdateDestinationCommand command = new UpdateDestinationCommand(this, destination);
        this.execute(command);
    }

    public void update(JeusDestination destination, DurableSubscriptionConfig config) throws StorageException {
        UpdateDurableSubscriberCommand command = new UpdateDurableSubscriberCommand(this, destination, config);
        this.execute(command);
    }

    boolean changeLifeCycle(long messageId, byte lifeCycle) {
        UpdateMessageLifeCycleCommand command = new UpdateMessageLifeCycleCommand(this, messageId, lifeCycle);
        return this.executeWithoutException(command);
    }

    boolean changeLifeCycle(long messageId, long durableSubscriberId, byte lifeCycle) {
        UpdateDurableMessageLifeCycleCommand command = new UpdateDurableMessageLifeCycleCommand(this, messageId, durableSubscriberId, lifeCycle);
        return this.executeWithoutException(command);
    }

    public void deleteDestination(JeusDestination destination) throws StorageException {
        long id = destination.getId();
        CompositeSQLCommand command = new CompositeSQLCommand("DELETE_DESTINATION", this, new SQLCommand[]{new MakeDestinationInvalidCommand(this, id), new DeleteDurableSubscribersCommand(this, id), new DeleteMessagesCommand(this, id), new DeleteDestinationCommand(this, id)});
        this.executeWithStorageException(command);
    }

    public void deleteStaleMessages(JeusDestination destination) throws StorageException {
        long version = destination.getVersion() - 1L;
        long id = destination.getId();
        DeleteStaleMessagesCommand command = new DeleteStaleMessagesCommand(this, id, version);
        this.executeWithStorageException(command);
    }

    public void deleteAllMessages(JeusDestination destination) throws StorageException {
        long version = destination.getVersion();
        long id = destination.getId();
        long newVersion = version + 1L;
        CompositeSQLCommand command = new CompositeSQLCommand("DELETE_ALL_MESSAGES", this, new SQLCommand[]{new UpdateDestinationVersionCommand(this, id, newVersion), new DeleteStaleMessagesCommand(this, id, version)});
        this.executeWithStorageException(command);
        destination.setVersion(newVersion);
    }

    public void deleteAllMessages(long durableSubscriberId) throws StorageException {
        DeleteDurableMessagesCommand command = new DeleteDurableMessagesCommand(this, durableSubscriberId);
        this.execute(command);
    }

    public boolean deleteMessage(long messageId, boolean queue) {
        return this.trashcan.throwAway(messageId, queue);
    }

    public void deleteDurableSubscriber(long id) throws StorageException {
        CompositeSQLCommand command = new CompositeSQLCommand("DELETE_DURABLE_SUBSCRIBER", this, new SQLCommand[]{new DeleteDurableMessagesCommand(this, id), new DeleteDurableSubscriberCommand(this, id)});
        this.executeWithStorageException(command);
    }

    public boolean deleteDurableMessage(long messageId, long durableSubscriberId) {
        return this.trashcan.throwAway(messageId, durableSubscriberId);
    }

    public boolean supportsXA() {
        return this.platform.supportsXA();
    }

    public boolean supportsLocalTransaction() {
        return this.platform.supportsLocalTransaction();
    }

    public LocalTransactionContext createLocalTransactionContext() throws StorageException {
        try {
            return new LocalDatabaseTransactionContext(this, this.platform, this.dataSource);
        }
        catch (SQLException e) {
            throw new StorageException(e.getMessage());
        }
    }

    public GlobalTransactionContext createGlobalTransactionContext(TransactionalWorks works) throws XAException {
        try {
            return new GlobalDatabaseTransactionContext(this, this.platform, this.dataSource);
        }
        catch (SQLException e) {
            XAException xaException = new XAException(e.getMessage());
            xaException.errorCode = -7;
            throw xaException;
        }
    }

    public byte getMessageLifecycle(MessageID msgID) throws StorageException {
        GetMessageLifecycleCommand command = new GetMessageLifecycleCommand(this, msgID);
        this.execute(command);
        return command.getLifecycle();
    }

    public byte getDurableMessageLifecycle(long durableSubscriberId, MessageID messageID) throws StorageException {
        GetDurableMessageLifecycleCommand command = new GetDurableMessageLifecycleCommand(this, durableSubscriberId, messageID);
        this.execute(command);
        return command.getLifecycle();
    }

    public long sync() throws IOException {
        this.lastSyncTime = System.currentTimeMillis();
        return 0L;
    }

    public long getLastSyncTime() {
        return this.lastSyncTime;
    }

    public void init() throws Exception {
        this.platform = DatabasePlatform.getPlatform(this.dataSource);
        this.lifecycleLogger.init();
        this.xaLogger.init();
        this.sqlExecutor.init();
        this.trashcan.init();
    }

    public void start() throws IOException {
        this.lifecycleLogger.start();
        this.xaLogger.start();
        this.sqlExecutor.start();
        this.trashcan.start();
    }

    public void prepareShutdown() {
        this.trashcan.prepareShutdown();
        this.sqlExecutor.prepareShutdown();
        this.xaLogger.prepareShutdown();
        this.lifecycleLogger.prepareShutdown();
    }

    public void shutdown() {
        this.shutdownAll();
    }

    public void shutdownAll() {
        this.trashcan.shutdownAll();
        this.sqlExecutor.shutdownAll();
        this.xaLogger.shutdownAll();
        this.lifecycleLogger.shutdownAll();
    }

    long getLastExecuteTime() {
        return this.lastExecuteTime;
    }

    public String getDestinationTableName() {
        return this.destinationTableName;
    }

    public String getDurableSubscriberTableName() {
        return this.durableSubscriberTableName;
    }

    public String getMessageTableName() {
        return this.messageTableName;
    }

    public String getUserPropertyTableName() {
        return this.userPropertyTableName;
    }

    public String getDurableMessageTableName() {
        return this.durableMessageTableName;
    }

    public String getXATableName() {
        return this.xaTableName;
    }

    public boolean isDeleteInvalidDestinations() {
        return this.deleteInvalidDestinations;
    }

    public Connection getConnection() throws SQLException {
        return this.platform.getConnection(this.dataSource);
    }

    public XAConnection getXAConnection() throws SQLException {
        return this.platform.getXAConnection(this.dataSource);
    }

    public DatabasePlatform getDatabasePlatform() {
        return this.platform;
    }

    public DataSqueezer getDataSqueezer() {
        return this.dataSqueezer;
    }

    public void handleXAException(XAException e) {
        this.platform.handleXAException(e);
    }

    public boolean isNull() {
        return false;
    }

    public void setDebug(boolean enable, String level) {
        this.platform.setDebug(enable, level);
    }
}

