/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import jeus.jms.server.persistence.LocalTransactionContext;
import jeus.jms.server.persistence.Storage;
import jeus.jms.server.persistence.StorageException;
import jeus.jms.server.persistence.database.DatabasePlatform;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.DatabaseTransactionContext;

public class LocalDatabaseTransactionContext
implements LocalTransactionContext,
DatabaseTransactionContext {
    private DatabasePlatform platform;
    private Connection connection;
    private DataSource dataSource;
    private DatabaseStorage storage;

    public LocalDatabaseTransactionContext(DatabaseStorage storage, DatabasePlatform platform, DataSource dataSource) throws SQLException {
        this.storage = storage;
        this.platform = platform;
        this.dataSource = dataSource;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.platform.getConnection(this.dataSource);
            this.connection.setAutoCommit(false);
        }
        return this.connection;
    }

    public synchronized boolean releaseResource() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.platform.releaseConnection(this.dataSource, this.connection);
                this.connection = null;
            }
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
            return false;
        }
        return true;
    }

    public void commit() throws StorageException {
        try {
            this.getConnection();
            this.connection.commit();
        }
        catch (SQLException sqlEx) {
            StorageException jmsEx = new StorageException(sqlEx.getMessage());
            jmsEx.setLinkedException(sqlEx);
            throw jmsEx;
        }
    }

    public void rollback() throws StorageException {
        try {
            this.getConnection();
            this.connection.rollback();
        }
        catch (SQLException sqlEx) {
            StorageException jmsEx = new StorageException(sqlEx.getMessage());
            jmsEx.setLinkedException(sqlEx);
            throw jmsEx;
        }
    }

    public Storage getStorage() {
        return this.storage;
    }

    public boolean isXA() {
        return false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.releaseResource();
    }
}

