/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import jeus.jms.common.JMSProperties;
import jeus.jms.common.LifeCycle;
import jeus.jms.server.persistence.StorageException;
import jeus.jms.server.persistence.StorageTransactionContext;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.DatabaseTransactionContext;
import jeus.jms.server.persistence.database.SQLCommand;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.concurrent.SynchronizedInt;
import jeus.util.concurrent50.concurrent.LinkedBlockingQueue;
import jeus.util.concurrent50.concurrent.TimeUnit;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class SQLCommandExecutor
extends Thread
implements LifeCycle {
    private static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms.server.persistence");
    private static final boolean NEED_LOGGING = logger.isLoggable(Level.FINEST);
    private LinkedBlockingQueue queue;
    private SynchronizedBoolean suspend;
    private DatabaseStorage storage;
    private boolean waitSqlExecutor;
    private long sqlPollTimeout;
    private long sqlIdleTime;
    private SynchronizedInt highPriorityCmds = new SynchronizedInt(0);
    private SynchronizedInt noWaitForIdleCmds = new SynchronizedInt(0);

    public SQLCommandExecutor(DatabaseStorage storage, String name, long sqlPollTimeout, boolean waitSqlExecutor) {
        super(name);
        this.storage = storage;
        this.sqlPollTimeout = sqlPollTimeout;
        this.waitSqlExecutor = waitSqlExecutor;
        this.suspend = new SynchronizedBoolean(false);
        this.sqlIdleTime = JMSProperties.SQL_IDLE_TIME > 0L ? JMSProperties.SQL_IDLE_TIME : sqlPollTimeout * 4L;
    }

    public void init() throws Exception {
        this.queue = new LinkedBlockingQueue();
    }

    public void execute(SQLCommand command) throws StorageException {
        this.execute(null, command);
    }

    public void execute(StorageTransactionContext context, SQLCommand command) throws StorageException {
        if (this.suspend.get()) {
            throw new IllegalStateException("SQLCommandExecutor is suspeded.");
        }
        if (command == null) {
            throw new IllegalArgumentException("SQLCommand is null.");
        }
        if (context != null && !command.isSynchronous()) {
            throw new IllegalArgumentException("Transacted SQLCommand must be synchronous.");
        }
        if (command.isSynchronous()) {
            try {
                this.executeInternal(context, command);
            }
            catch (Exception e) {
                StorageException.throwStorageException(e);
            }
        } else {
            this.queue.offer((Object)command);
        }
    }

    public void run() {
        while (!(this.queue.isEmpty() && this.suspend.get() || SQLCommandExecutor.interrupted())) {
            try {
                SQLCommand command = (SQLCommand)this.queue.poll(this.sqlPollTimeout, TimeUnit.MILLISECONDS);
                if (command == null) continue;
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5531_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._5531_LEVEL, JeusMessage_JMS5._5531, command.getName());
                }
                try {
                    this.executeInternal(null, command);
                }
                catch (Exception e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5532_LEVEL)) continue;
                    LogUtils.log(logger, JeusMessage_JMS5._5532_LEVEL, JeusMessage_JMS5._5532, command.getName(), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5533_LEVEL)) continue;
                LogUtils.log(logger, JeusMessage_JMS5._5533_LEVEL, JeusMessage_JMS5._5533, e);
            }
        }
    }

    private void executeInternal(StorageTransactionContext context, SQLCommand command) throws Exception {
        Connection connection;
        block31: {
            if (!command.waitForIdle()) {
                this.noWaitForIdleCmds.increment();
            }
            if (command.isHighPriority()) {
                this.highPriorityCmds.increment();
            } else {
                if (command.waitForIdle()) {
                    long idleTime = 0L;
                    while (true) {
                        Thread.sleep(this.sqlPollTimeout);
                        if (this.noWaitForIdleCmds.get() == 0) {
                            if (!command.waitForIdle() || (idleTime += this.sqlPollTimeout) < this.sqlIdleTime) continue;
                            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5534_LEVEL)) {
                                LogUtils.log(logger, JeusMessage_JMS5._5534_LEVEL, JeusMessage_JMS5._5534);
                            }
                            break block31;
                        }
                        idleTime = 0L;
                    }
                }
                if (this.highPriorityCmds.get() > 0) {
                    long startTime = System.currentTimeMillis();
                    do {
                        Thread.sleep(this.sqlPollTimeout);
                    } while (this.highPriorityCmds.get() != 0 && System.currentTimeMillis() - startTime < JMSProperties.LOW_PRIORITY_SQL_DELAY);
                }
            }
        }
        boolean transacted = false;
        if (context != null) {
            connection = ((DatabaseTransactionContext)((Object)context)).getConnection();
            transacted = true;
        } else {
            connection = this.storage.getConnection();
        }
        try {
            if (!transacted) {
                connection.setAutoCommit(command.isAutoCommit());
            }
            if (NEED_LOGGING) {
                command.log();
            }
            command.execute(connection);
            if (!transacted && !command.isAutoCommit()) {
                connection.commit();
            }
        }
        catch (Exception e) {
            block33: {
                if (connection != null && !transacted && !command.isAutoCommit()) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException rollbackEx) {
                        if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5535_LEVEL)) break block33;
                        LogUtils.log(logger, JeusMessage_JMS5._5535_LEVEL, JeusMessage_JMS5._5535, rollbackEx);
                    }
                }
            }
            if (!command.isSynchronous() && command.retry()) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5536_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._5536_LEVEL, JeusMessage_JMS5._5536, command.getName());
                }
                this.queue.offer((Object)command);
            }
            throw e;
        }
        finally {
            block34: {
                if (!transacted && connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5537_LEVEL)) break block34;
                        LogUtils.log(logger, JeusMessage_JMS5._5537_LEVEL, JeusMessage_JMS5._5537, e);
                    }
                }
            }
            if (command.isHighPriority()) {
                this.highPriorityCmds.decrement();
            }
            if (!command.waitForIdle()) {
                this.noWaitForIdleCmds.decrement();
            }
        }
    }

    public void prepareShutdown() {
        this.suspend.commit(false, true);
    }

    public void shutdown() {
        this.shutdownAll();
    }

    public void shutdownAll() {
        if (this.waitSqlExecutor) {
            try {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5538_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._5538_LEVEL, JeusMessage_JMS5._5538);
                }
                this.join();
            }
            catch (InterruptedException e) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5539_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._5539_LEVEL, JeusMessage_JMS5._5539, e);
                }
            }
        } else {
            this.interrupt();
        }
    }
}

