/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database;

import java.io.IOException;
import jeus.jms.common.JMSProperties;
import jeus.jms.common.LifeCycle;
import jeus.jms.server.JMSSession;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.command.BatchDeleteMessagesCommand;
import jeus.jms.server.transaction.TransactionManager;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.concurrent50.concurrent.BlockingQueue;
import jeus.util.concurrent50.concurrent.LinkedBlockingQueue;
import jeus.util.concurrent50.concurrent.TimeUnit;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class Trashcan
implements LifeCycle,
Runnable {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms.server.persistence");
    private LinkedBlockingQueue trashQueue;
    private DatabaseStorage storage;
    private SynchronizedBoolean suspend = new SynchronizedBoolean(true);
    private Thread thread;

    public Trashcan(DatabaseStorage storage) {
        this.storage = storage;
    }

    public void run() {
        block8: {
            try {
                long[] trashes = new long[JMSProperties.BATCH_DELETE_SIZE];
                int i = 0;
                long lastFlushTime = System.currentTimeMillis();
                while (!Thread.currentThread().isInterrupted() && !this.suspend.get()) {
                    boolean timeover;
                    Long id = (Long)this.trashQueue.poll(JMSProperties.TRASH_QUEUE_POLL_TIMEOUT, TimeUnit.MILLISECONDS);
                    boolean bl = timeover = System.currentTimeMillis() - lastFlushTime >= JMSProperties.FLUSH_TRASHCAN_INTERVAL;
                    if (id != null) {
                        trashes[i++] = id;
                    }
                    if (i != JMSProperties.BATCH_DELETE_SIZE && (!timeover || i <= 0)) continue;
                    if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5151_LEVEL)) {
                        LogUtils.log(logger, JeusMessage_JMS5._5151_LEVEL, JeusMessage_JMS5._5151, new Object[]{new Integer(i), timeover});
                    }
                    BatchDeleteMessagesCommand command = new BatchDeleteMessagesCommand(this.storage, trashes, i);
                    try {
                        this.storage.execute(command);
                    }
                    catch (Exception e) {
                        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5152_LEVEL)) {
                            LogUtils.log(logger, JeusMessage_JMS5._5152_LEVEL, JeusMessage_JMS5._5152, e.getMessage(), (Throwable)e);
                        }
                        command.recover((BlockingQueue)this.trashQueue);
                    }
                    lastFlushTime = System.currentTimeMillis();
                    i = 0;
                }
            }
            catch (Exception e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5153_LEVEL)) break block8;
                LogUtils.log(logger, JeusMessage_JMS5._5153_LEVEL, JeusMessage_JMS5._5153, e.getMessage());
            }
        }
    }

    private boolean isTransactionAssociated() {
        return TransactionManager.isGlobalTransactionAssociated() || JMSSession.isLocalTransactionAssociated();
    }

    public boolean throwAway(long messageId, boolean queue) {
        if (queue && this.isTransactionAssociated()) {
            return true;
        }
        if (this.suspend.get()) {
            return false;
        }
        if (!this.isTransactionAssociated()) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5154_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5154_LEVEL, JeusMessage_JMS5._5154);
            }
            this.storage.getLifecycleLogger().completed(messageId);
        }
        this.trashQueue.add((Object)new Long(messageId));
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5155_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5155_LEVEL, JeusMessage_JMS5._5155, new Long(messageId));
        }
        return true;
    }

    public boolean throwAway(long messageId, long durableSubscriberId) {
        if (this.isTransactionAssociated()) {
            return true;
        }
        if (this.suspend.get()) {
            return false;
        }
        if (!this.isTransactionAssociated()) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5156_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5156_LEVEL, JeusMessage_JMS5._5156);
            }
            return this.storage.getLifecycleLogger().completed(messageId, durableSubscriberId);
        }
        return true;
    }

    public void init() throws Exception {
        this.trashQueue = new LinkedBlockingQueue();
        this.thread = new Thread((Runnable)this, "JMSDatabaseStorage-Trashcan");
        this.thread.setDaemon(true);
    }

    public void start() throws IOException {
        this.suspend.commit(true, false);
        if (this.thread != null) {
            this.thread.start();
        }
    }

    public void prepareShutdown() {
        this.suspend.commit(false, true);
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void shutdown() {
        this.shutdownAll();
    }

    public void shutdownAll() {
        if (this.trashQueue != null) {
            this.trashQueue.clear();
        }
    }
}

