/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.util.logging.Level;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLCommand;
import jeus.jms.server.persistence.database.command.BooleanSQLCommand;
import jeus.jms.server.persistence.database.command.SQLCommandBase;

public class ConditionalSQLCommand
extends SQLCommandBase {
    private static final boolean NEED_LOGGING = logger.isLoggable(Level.FINEST);
    private BooleanSQLCommand booleanCommand;
    private SQLCommand command;

    public ConditionalSQLCommand(DatabaseStorage storage, BooleanSQLCommand booleanCommand, SQLCommand command) {
        super(storage);
        this.booleanCommand = booleanCommand;
        this.command = command;
    }

    public final boolean isAutoCommit() {
        return false;
    }

    public final boolean isHighPriority() {
        return true;
    }

    public final boolean isSynchronous() {
        return true;
    }

    public void execute(Connection connection) throws Exception {
        this.booleanCommand.execute(connection);
        if (this.booleanCommand.isTrue()) {
            if (this.command.isSynchronous()) {
                if (NEED_LOGGING) {
                    this.command.log();
                }
                this.command.execute(connection);
            } else {
                this.storage.execute(this.command);
            }
        }
    }

    public String getName() {
        return this.command.getName();
    }

    public String getSQL() {
        return this.command.getSQL();
    }
}

