/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import jeus.jms.common.util.JMSXid;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class DeleteXACommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "DELETE_XA_COMMAND";
    private JMSXid xid;

    public DeleteXACommand(DatabaseStorage storage, JMSXid xid) {
        super(storage);
        this.xid = xid;
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("XA_ID", String.valueOf(this.xid.hashCode())), new SQLParameter("XA_XID", this.xid.toString())};
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DELETE FROM ").append(this.storage.getXATableName());
        buffer.append(" WHERE ").append("XA_ID").append("=?");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setInt(1, this.xid.hashCode());
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }

    public String getName() {
        return COMMAND_NAME;
    }
}

