/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.LoopSQLCommand;

public abstract class DurableSubscriberLoopCommand
extends LoopSQLCommand {
    protected long destinationId;

    protected DurableSubscriberLoopCommand(DatabaseStorage storage, long destinationId) {
        super(storage);
        this.destinationId = destinationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator getIterator(Connection connection) throws Exception {
        ArrayList<Long> idList = new ArrayList<Long>();
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        ResultSet rs = null;
        try {
            stmt.setLong(1, this.destinationId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                idList.add(new Long(rs.getLong("DS_ID")));
            }
            rs.close();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
        return idList.iterator();
    }

    protected final String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT ");
        buffer.append("DS_ID");
        buffer.append(" FROM ").append(this.storage.getDurableSubscriberTableName());
        buffer.append(" WHERE ").append("DT_ID").append("=?");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("DT_ID", String.valueOf(this.destinationId))};
    }
}

