/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class GetMessageContentCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "GET_MESSAGE_CONTENT";
    private ContentListener listener;
    private long id;

    public GetMessageContentCommand(DatabaseStorage storage, long id, ContentListener listener) {
        super(storage);
        this.id = id;
        this.listener = listener;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT ");
        buffer.append("MG_CONTENT_LENGTH").append(", ");
        buffer.append("MG_CONTENT");
        buffer.append(" FROM ").append(this.storage.getMessageTableName());
        buffer.append(" WHERE ").append("MG_ID").append("=?");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("MG_ID", String.valueOf(this.id))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        ResultSet rs = null;
        byte[] bytes = null;
        try {
            stmt.setLong(1, this.id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                int length = rs.getInt("MG_CONTENT_LENGTH");
                bytes = this.getBlobData(rs, "MG_CONTENT", length);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
        this.listener.contentLoaded(bytes);
    }

    public String getName() {
        return COMMAND_NAME;
    }

    public static interface ContentListener {
        public void contentLoaded(byte[] var1);
    }
}

