/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;
import jeus.jms.server.util.MessageLifecycle;

public class InsertDurableMessageCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "INSERT_DURABLE_MESSGE";
    private long messageId;
    private long durableSubscriberId;

    public InsertDurableMessageCommand(DatabaseStorage storage, long messageId, long durableSubscriberId) {
        super(storage);
        this.messageId = messageId;
        this.durableSubscriberId = durableSubscriberId;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO ").append(this.storage.getDurableMessageTableName()).append("(");
        buffer.append("MG_ID").append(", ");
        buffer.append("DS_ID").append(", ");
        buffer.append("DM_LIFECYCLE").append(") ");
        buffer.append(" VALUES(?, ?, ?)");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("MG_ID", String.valueOf(this.messageId)), new SQLParameter("DS_ID", String.valueOf(this.durableSubscriberId)), new SQLParameter("DM_LIFECYCLE", MessageLifecycle.getStringValue(2))};
    }

    public String getName() {
        return COMMAND_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setLong(1, this.messageId);
            stmt.setLong(2, this.durableSubscriberId);
            stmt.setByte(3, (byte)2);
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }
}

