/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import jeus.jms.server.config.DurableSubscriptionConfig;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class InsertDurableSubscriberCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "INSERT_DURABLE_SUBSCRIBER";
    private DurableSubscriptionConfig config;
    private long destinationId;

    public InsertDurableSubscriberCommand(DatabaseStorage storage, DurableSubscriptionConfig config, long destinationId) {
        super(storage);
        this.config = config;
        this.destinationId = destinationId;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO ").append(this.storage.getDurableSubscriberTableName()).append("(");
        buffer.append("DS_ID").append(", ");
        buffer.append("DT_ID").append(", ");
        buffer.append("DS_CLIENT_ID").append(", ");
        buffer.append("DS_DURABLE_NAME").append(", ");
        buffer.append("DS_NOLOCAL").append(", ");
        buffer.append("DS_SELECTOR").append(", ");
        buffer.append("DS_CLUSTER").append(") ");
        buffer.append(" VALUES (?, ?, ?, ?, ?, ?, ?)");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("DS_ID", String.valueOf(this.config.getId())), new SQLParameter("DT_ID", String.valueOf(this.destinationId)), new SQLParameter("DS_CLIENT_ID", this.config.getClientID()), new SQLParameter("DS_DURABLE_NAME", this.config.getDurableName()), new SQLParameter("DS_NOLOCAL", String.valueOf(this.config.isNolocal())), new SQLParameter("DS_SELECTOR", this.config.getSelector()), new SQLParameter("DS_CLUSTER", String.valueOf(this.config.isCluster()))};
    }

    public String getName() {
        return COMMAND_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setLong(1, this.config.getId());
            stmt.setLong(2, this.destinationId);
            stmt.setString(3, this.config.getClientID());
            stmt.setString(4, this.config.getDurableName());
            stmt.setBoolean(5, this.config.isNolocal());
            stmt.setString(6, this.config.getSelector());
            stmt.setBoolean(7, this.config.isCluster());
            stmt.executeUpdate();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }
}

