/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class RangeDeleteMessagesCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "RANGE_DELETE_MESSAGES";
    private long destinationId;
    private long from;
    private long to;

    public RangeDeleteMessagesCommand(DatabaseStorage storage, long destinationId, long from, long to) {
        super(storage);
        this.destinationId = destinationId;
        this.from = from;
        this.to = to;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DELETE FROM ").append(this.storage.getMessageTableName()).append(" WHERE ");
        buffer.append("DT_ID").append("=? AND ");
        buffer.append("MG_ID").append(" BETWEEN ? AND ? ");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("DT_ID", String.valueOf(this.destinationId)), new SQLParameter("MG_ID", String.valueOf(this.from)), new SQLParameter("MG_ID", String.valueOf(this.to))};
    }

    public boolean isHighPriority() {
        return false;
    }

    public String getName() {
        return COMMAND_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setLong(1, this.destinationId);
            stmt.setLong(2, this.from);
            stmt.setLong(3, this.to);
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }
}

