/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.server.manager.DestinationFactory;
import jeus.jms.server.persistence.DestinationRecoveryListener;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class RecoverDestinationCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "RECOVER_DESTINATION";
    private DestinationRecoveryListener listener;

    public RecoverDestinationCommand(DatabaseStorage storage, DestinationRecoveryListener listener) {
        super(storage);
        this.listener = listener;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT ");
        buffer.append("DT_ID").append(", ");
        buffer.append("DT_NAME").append(", ");
        buffer.append("DT_EXPORT_NAME").append(", ");
        buffer.append("DT_TYPE").append(", ");
        buffer.append("DT_BROKER_NAME").append(", ");
        buffer.append("DT_CONSUMER_LIMIT").append(", ");
        buffer.append("DT_CAPACITY_LOW_MARK").append(", ");
        buffer.append("DT_CAPACITY_HIGH_MARK").append(", ");
        buffer.append("DT_CAPACITY_LIMIT").append(", ");
        buffer.append("DT_MAX_PENDING_LIMIT").append(", ");
        buffer.append("DT_RESUME_DISPATCH_FACTOR").append(", ");
        buffer.append("DT_WEIGHT").append(", ");
        buffer.append("DT_DISTRIBUTE_TYPE").append(", ");
        buffer.append("DT_LOCAL_DISTRIBUTE_TYPE").append(", ");
        buffer.append("DT_MULTIPLE_RECEIVER").append(", ");
        buffer.append("DT_RELAY_TYPE").append(", ");
        buffer.append("DT_RELAYS").append(", ");
        buffer.append("DT_VALID").append(", ");
        buffer.append("DT_VERSION");
        buffer.append(" FROM ").append(this.storage.getDestinationTableName());
        buffer.append(" WHERE ").append("DT_ID").append(" != ").append(-1L);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        Statement stmt = connection.createStatement();
        ResultSet rs = null;
        try {
            if (this.listener != null) {
                this.listener.beginRecovery();
            }
            rs = stmt.executeQuery(this.getSQL());
            while (rs.next()) {
                JeusDestination destination = DestinationFactory.createDestination(rs.getByte("DT_TYPE"), rs.getString("DT_NAME"), rs.getString("DT_EXPORT_NAME"), rs.getBoolean("DT_MULTIPLE_RECEIVER"), rs.getString("DT_BROKER_NAME"));
                destination.setId(rs.getLong("DT_ID"));
                destination.setConsumerLimit(rs.getInt("DT_CONSUMER_LIMIT"));
                destination.setLowMark(rs.getInt("DT_CAPACITY_LOW_MARK"));
                destination.setHighMark(rs.getInt("DT_CAPACITY_HIGH_MARK"));
                destination.setLimit(rs.getInt("DT_CAPACITY_LIMIT"));
                destination.setMaxPendingLimit(rs.getInt("DT_MAX_PENDING_LIMIT"));
                destination.setResumeDispatchFactor(rs.getFloat("DT_RESUME_DISPATCH_FACTOR"));
                String relays = rs.getString("DT_RELAYS");
                if (relays != null) {
                    StringTokenizer stk = new StringTokenizer(relays, ",");
                    ArrayList<String> relayList = new ArrayList<String>();
                    while (stk.hasMoreTokens()) {
                        String relay = stk.nextToken();
                        relayList.add(relay);
                    }
                    if (!relayList.isEmpty()) {
                        destination.setRelays(relayList);
                    }
                }
                destination.setRelayType(rs.getByte("DT_RELAY_TYPE"));
                destination.setValid(rs.getBoolean("DT_VALID"));
                destination.setVersion(rs.getLong("DT_VERSION"));
                destination.setRecovered(true);
                if (this.listener == null) continue;
                this.listener.recovered(destination.getId(), destination);
            }
        }
        finally {
            if (this.listener != null) {
                this.listener.endRecovery();
            }
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
    }

    public String getName() {
        return COMMAND_NAME;
    }
}

