/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import jeus.jms.common.JMSProperties;
import jeus.jms.server.persistence.MessageRecoveryListener;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class RecoverDurableMessageCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "RECOVER_DURABLE_MESSAGE";
    private MessageRecoveryListener listener;

    public RecoverDurableMessageCommand(DatabaseStorage storage, MessageRecoveryListener listener) {
        super(storage);
        this.listener = listener;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT ");
        buffer.append("MG_ID").append(", ");
        buffer.append("DS_ID").append(", ");
        buffer.append("DM_LIFECYCLE");
        buffer.append(" FROM ").append(this.storage.getDurableMessageTableName());
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        Statement stmt = connection.createStatement();
        stmt.setFetchSize(JMSProperties.ROW_FETCH_SIZE);
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(this.getSQL());
            while (rs.next()) {
                if (this.listener == null) continue;
                this.listener.recovered(rs.getLong("MG_ID"), rs.getLong("DS_ID"), rs.getByte("DM_LIFECYCLE"));
            }
        }
        finally {
            if (this.listener != null) {
                this.listener.endRecovery();
            }
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
    }

    public String getName() {
        return COMMAND_NAME;
    }
}

