/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.jms.InvalidDestinationException;
import jeus.jms.server.config.DurableSubscriptionConfig;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.persistence.DurableSubscriberRecoveryListener;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class RecoverDurableSubscriberCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "RECOVER_DURABLE_SUBSCRIBER";
    private DurableSubscriberRecoveryListener listener;

    public RecoverDurableSubscriberCommand(DatabaseStorage storage, DurableSubscriberRecoveryListener listener) {
        super(storage);
        this.listener = listener;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT ");
        buffer.append("DS_ID").append(", ");
        buffer.append("DT_ID").append(", ");
        buffer.append("DS_CLIENT_ID").append(", ");
        buffer.append("DS_DURABLE_NAME").append(", ");
        buffer.append("DS_NOLOCAL").append(", ");
        buffer.append("DS_SELECTOR").append(", ");
        buffer.append("DS_CLUSTER");
        buffer.append(" FROM ").append(this.storage.getDurableSubscriberTableName());
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        Statement stmt = connection.createStatement();
        ResultSet rs = null;
        try {
            if (this.listener != null) {
                this.listener.beginRecovery();
            }
            rs = stmt.executeQuery(this.getSQL());
            while (rs.next()) {
                String destinationName;
                long id = rs.getLong("DS_ID");
                long destinationId = rs.getLong("DT_ID");
                try {
                    DestinationManager manager = DestinationUtil.getDestinationManager(destinationId);
                    destinationName = manager.getDestinationName();
                }
                catch (InvalidDestinationException e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5411_LEVEL)) continue;
                    LogUtils.log(logger, JeusMessage_JMS5._5411_LEVEL, JeusMessage_JMS5._5411, e);
                    continue;
                }
                DurableSubscriptionConfig config = new DurableSubscriptionConfig(destinationName, rs.getString("DS_CLIENT_ID"), rs.getString("DS_DURABLE_NAME"), rs.getString("DS_SELECTOR"), rs.getBoolean("DS_NOLOCAL"), rs.getBoolean("DS_CLUSTER"));
                config.setId(id);
                if (this.listener == null) continue;
                this.listener.recovered(id, config);
            }
        }
        finally {
            if (this.listener != null) {
                this.listener.endRecovery();
            }
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
    }

    public String getName() {
        return COMMAND_NAME;
    }
}

