/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;
import jeus.jms.server.util.MessageLifecycle;

public class UpdateDurableMessageLifeCycleCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "UPDATE_DURABLE_MESSAGE_LIFECYCLE";
    private long messageId;
    private long durableSubscriberId;
    private byte lifeCycle;

    public UpdateDurableMessageLifeCycleCommand(DatabaseStorage storage, long messageId, long durableSubscriberId, byte lifeCycle) {
        super(storage);
        this.messageId = messageId;
        this.durableSubscriberId = durableSubscriberId;
        this.lifeCycle = lifeCycle;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(this.storage.getDurableMessageTableName()).append(" SET ");
        buffer.append("DM_LIFECYCLE").append("=? ");
        buffer.append(" WHERE ").append("MG_ID").append("=? AND ");
        buffer.append("DS_ID").append("=?");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("DM_LIFECYCLE", MessageLifecycle.getStringValue(this.lifeCycle)), new SQLParameter("MG_ID", String.valueOf(this.messageId)), new SQLParameter("DS_ID", String.valueOf(this.durableSubscriberId))};
    }

    public String getName() {
        return COMMAND_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setLong(1, this.lifeCycle);
            stmt.setLong(2, this.messageId);
            stmt.setLong(3, this.durableSubscriberId);
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }
}

