/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.server.config.DurableSubscriptionConfig;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class UpdateDurableSubscriberCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "UPDATE_DURABLE_SUBSCRIBER";
    private DurableSubscriptionConfig config;
    private JeusDestination destination;

    public UpdateDurableSubscriberCommand(DatabaseStorage storage, JeusDestination destination, DurableSubscriptionConfig config) {
        super(storage);
        this.config = config;
        this.destination = destination;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(this.storage.getDurableSubscriberTableName()).append(" SET ");
        buffer.append("DT_ID").append("=?, ");
        buffer.append("DS_CLIENT_ID").append("=?, ");
        buffer.append("DS_DURABLE_NAME").append("=?, ");
        buffer.append("DS_NOLOCAL").append("=?, ");
        buffer.append("DS_SELECTOR").append("=?, ");
        buffer.append("DS_CLUSTER").append("=? WHERE ");
        buffer.append("DS_ID").append("=?");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("DT_ID", String.valueOf(this.destination.getId())), new SQLParameter("DS_CLIENT_ID", this.config.getClientID()), new SQLParameter("DS_DURABLE_NAME", this.config.getDurableName()), new SQLParameter("DS_NOLOCAL", String.valueOf(this.config.isNolocal())), new SQLParameter("DS_SELECTOR", this.config.getSelector()), new SQLParameter("DS_CLUSTER", String.valueOf(this.config.isCluster())), new SQLParameter("DS_ID", String.valueOf(this.config.getId()))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setLong(1, this.destination.getId());
            stmt.setString(2, this.config.getClientID());
            stmt.setString(3, this.config.getDurableName());
            stmt.setBoolean(4, this.config.isNolocal());
            stmt.setString(5, this.config.getSelector());
            stmt.setBoolean(6, this.config.isCluster());
            stmt.setLong(7, this.config.getId());
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }

    public String getName() {
        return COMMAND_NAME;
    }
}

