/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;
import jeus.jms.server.util.MessageLifecycle;

public class UpdateMessageLifeCycleCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "UPDATE_MESSAGE_LIFECYCLE";
    private long messageId;
    private byte lifeCycle;

    public UpdateMessageLifeCycleCommand(DatabaseStorage storage, long messageId, byte lifeCycle) {
        super(storage);
        this.messageId = messageId;
        this.lifeCycle = lifeCycle;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(this.storage.getMessageTableName()).append(" SET ");
        buffer.append("MG_LIFECYCLE").append("=? ");
        buffer.append(" WHERE ").append("MG_ID").append("=?");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("MG_LIFECYCLE", MessageLifecycle.getStringValue(this.lifeCycle)), new SQLParameter("MG_ID", String.valueOf(this.messageId))};
    }

    public String getName() {
        return COMMAND_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setLong(1, this.lifeCycle);
            stmt.setLong(2, this.messageId);
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }
}

