/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.transaction.xa.XAException;
import jeus.jms.client.facility.factory.JeusConnectionFactory;
import jeus.jms.client.facility.factory.JeusXAConnectionFactory;
import jeus.jms.common.util.JMSXid;
import jeus.jms.server.JMSServer;
import jeus.jms.server.comm.JMSBroker;
import jeus.jms.server.persistence.Storage;
import jeus.jms.server.persistence.XALogger;
import jeus.jms.server.persistence.XARecoveryListener;
import jeus.jms.server.transaction.RecoveredTransactionBranch;
import jeus.jms.server.transaction.TransactionBranch;
import jeus.jms.server.transaction.TransactionContext;
import jeus.jms.server.transaction.TransactionHandler;
import jeus.transaction.RecoveryThread;
import jeus.transaction.XAResourceFactory;
import jeus.transaction.logging.JEUSXAResourceFactory;
import jeus.util.JeusException;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS5;

public class TransactionManager
implements TransactionHandler,
XARecoveryListener {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    public static final long NO_TRANSACTION = -1L;
    public static final long LOCAL_TRANSACTION = -2L;
    private static ThreadLocal currentTxContext = new ThreadLocal();
    private static final TransactionManager instance = new TransactionManager();
    private Map txContexts = Collections.synchronizedMap(new HashMap());
    private Map inDoubtTxContexts = Collections.synchronizedMap(new HashMap());
    private XALogger xaLogger;

    private TransactionManager() {
    }

    public void init(Storage storage) {
        this.xaLogger = storage.getXALogger();
        if (this.xaLogger != null) {
            this.xaLogger.recover(this);
        }
    }

    public static TransactionManager getInstance() {
        return instance;
    }

    private static void associateTransactionContext(TransactionContext txContext) {
        currentTxContext.set(txContext);
    }

    private static void dissociateTransactionContext() {
        currentTxContext.set(null);
    }

    public static TransactionContext getCurrentTransactionContext() {
        return (TransactionContext)currentTxContext.get();
    }

    public static boolean isGlobalTransactionAssociated() {
        return TransactionManager.getCurrentTransactionContext() != null;
    }

    public void prepared(JMSXid xid) {
        TransactionContext context;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7021_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7021_LEVEL, JeusMessage_JMS5._7021, xid.toString());
        }
        if ((context = (TransactionContext)this.inDoubtTxContexts.get(xid.getGtIdHashCode())) == null) {
            context = this.createContext(xid, true);
            this.inDoubtTxContexts.put(xid.getGtIdHashCode(), context);
        }
        context.addBranchContext(xid, new RecoveredTransactionBranch(context, xid));
    }

    public void completed(JMSXid xid) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7022_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7022_LEVEL, JeusMessage_JMS5._7022, xid.toString());
        }
        if (this.xaLogger != null) {
            this.xaLogger.completed(xid, true);
        }
    }

    public TransactionBranch getTransactionBranch(JMSXid xid) throws XAException {
        TransactionContext txContext = this.peekContext(xid);
        if (txContext == null) {
            throw new XAException(-4);
        }
        return txContext.getBranchContext(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionBranch startTransaction(JMSXid xid, int flag, long timeout, boolean remote) throws XAException {
        TransactionContext txContext;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7023_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7023_LEVEL, JeusMessage_JMS5._7023, new Object[]{new Integer(flag), new Long(timeout), xid});
        }
        if ((txContext = this.peekContext(xid)) == null) {
            if (flag == 0) {
                txContext = this.createContext(xid);
            } else {
                throw new XAException(-4);
            }
        }
        try {
            TransactionManager.associateTransactionContext(txContext);
            TransactionBranch transactionBranch = txContext.start(xid, flag, timeout);
            return transactionBranch;
        }
        finally {
            TransactionManager.dissociateTransactionContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction(JMSXid xid, int flag, long timeout, boolean remote) throws XAException {
        TransactionContext txContext;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7024_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7024_LEVEL, JeusMessage_JMS5._7024, new Object[]{new Integer(flag), xid});
        }
        if ((txContext = this.peekContext(xid)) == null) {
            throw new XAException(-4);
        }
        try {
            TransactionManager.associateTransactionContext(txContext);
            txContext.end(xid, flag, timeout);
        }
        finally {
            TransactionManager.dissociateTransactionContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(JMSXid xid, long timeout, boolean remote) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7025_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7025_LEVEL, JeusMessage_JMS5._7025, xid.toString());
        }
        TransactionContext txContext = this.getContext(xid);
        try {
            TransactionManager.associateTransactionContext(txContext);
            if (this.xaLogger != null) {
                this.xaLogger.preparing(xid, remote);
            }
            int result = txContext.prepare(xid, timeout);
            if (this.xaLogger != null) {
                if (result == 0) {
                    this.xaLogger.prepared(xid, remote);
                } else {
                    this.xaLogger.completed(xid, remote);
                }
            }
            int n = result;
            return n;
        }
        finally {
            TransactionManager.dissociateTransactionContext();
            if (txContext.isEmpty()) {
                this.removeContext(xid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(JMSXid xid, boolean remote) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7026_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7026_LEVEL, JeusMessage_JMS5._7026, xid.toString());
        }
        TransactionContext txContext = this.getContext(xid);
        try {
            TransactionManager.associateTransactionContext(txContext);
            TransactionBranch branch = txContext.rolllback(xid);
            if (this.xaLogger != null) {
                this.xaLogger.rolledback(xid, branch.getState() == 2, remote);
            }
        }
        finally {
            TransactionManager.dissociateTransactionContext();
            if (txContext.isEmpty()) {
                this.removeContext(xid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(JMSXid xid, boolean onePhase, long timeout, boolean remote) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7027_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7027_LEVEL, JeusMessage_JMS5._7027, new Object[]{onePhase, xid});
        }
        TransactionContext txContext = this.getContext(xid);
        try {
            TransactionManager.associateTransactionContext(txContext);
            txContext.commit(xid, onePhase, timeout);
            if (this.xaLogger != null) {
                this.xaLogger.committed(xid, !onePhase, remote);
            }
        }
        finally {
            TransactionManager.dissociateTransactionContext();
            if (txContext.isEmpty()) {
                this.removeContext(xid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(JMSXid xid) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7028_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7028_LEVEL, JeusMessage_JMS5._7028, xid.toString());
        }
        TransactionContext txContext = this.getContext(xid);
        try {
            TransactionManager.associateTransactionContext(txContext);
            txContext.forget(xid);
        }
        finally {
            TransactionManager.dissociateTransactionContext();
            this.removeContext(xid);
        }
    }

    public boolean hasInDoubtTransactions() {
        return !this.inDoubtTxContexts.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSXid[] recover(int flag) throws XAException {
        switch (flag) {
            case 0: 
            case 0x800000: 
            case 0x1000000: 
            case 0x1800000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        Map contexts = this.hasInDoubtTransactions() ? this.inDoubtTxContexts : this.txContexts;
        Map map = contexts;
        synchronized (map) {
            HashSet<JMSXid> xidSet = new HashSet<JMSXid>();
            for (TransactionContext context : contexts.values()) {
                Collection branches = context.getTransactionBranches();
                for (TransactionBranch branch : branches) {
                    if (branch.getState() != 2) continue;
                    JMSXid xid = branch.getTransactionID();
                    xidSet.add(xid);
                }
            }
            return xidSet.toArray(new JMSXid[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionContext getContext(JMSXid xid) throws XAException {
        Map map = this.txContexts;
        synchronized (map) {
            TransactionContext txContext = this.peekContext(xid);
            if (txContext == null) {
                throw new XAException(-4);
            }
            return txContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionContext createContext(JMSXid xid, boolean prepared) {
        Map map = this.txContexts;
        synchronized (map) {
            TransactionContext txContext = new TransactionContext(xid, prepared);
            this.txContexts.put(xid.getGtIdHashCode(), txContext);
            return txContext;
        }
    }

    private TransactionContext createContext(JMSXid xid) {
        return this.createContext(xid, false);
    }

    private TransactionContext peekContext(JMSXid xid) {
        if (this.inDoubtTxContexts.containsKey(xid.getGtIdHashCode())) {
            return (TransactionContext)this.inDoubtTxContexts.get(xid.getGtIdHashCode());
        }
        return (TransactionContext)this.txContexts.get(xid.getGtIdHashCode());
    }

    private TransactionContext removeContext(JMSXid xid) {
        if (this.inDoubtTxContexts.containsKey(xid.getGtIdHashCode())) {
            TransactionContext context = (TransactionContext)this.inDoubtTxContexts.remove(xid.getGtIdHashCode());
            if (!this.hasInDoubtTransactions()) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7029_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._7029_LEVEL, JeusMessage_JMS5._7029);
                }
                try {
                    JMSBroker.getLocalBroker().getSerialExecutor().execute(new Runnable(){

                        public void run() {
                            try {
                                JMSServer.getJMSServer().getJMSResource().initMessages();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return context;
        }
        return (TransactionContext)this.txContexts.remove(xid.getGtIdHashCode());
    }

    public synchronized void shutdown() {
        for (TransactionContext ctx : this.txContexts.values()) {
            if (ctx.isPrepared()) continue;
            ctx.shutdown();
        }
    }

    public static boolean resyncJMSServer(String exportName) throws JeusException {
        try {
            Object obj = new InitialContext().lookup(exportName);
            if (obj == null || !(obj instanceof JeusXAConnectionFactory)) {
                return false;
            }
            JeusConnectionFactory factory = (JeusConnectionFactory)obj;
            Reference ref = factory.getReference();
            RecoveryThread t = new RecoveryThread((XAResourceFactory)new JEUSXAResourceFactory(ref));
            t.setDaemon(true);
            t.start();
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7030_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._7030_LEVEL, JeusMessage_JMS5._7030, exportName);
            }
            return true;
        }
        catch (Throwable t) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7031_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._7031_LEVEL, JeusMessage_JMS5._7031, exportName);
            }
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7032_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._7032_LEVEL, JeusMessage_JMS5._7032, exportName, t);
            }
            throw new JeusException(JeusMessage_JMS._13020, (Object)exportName, t);
        }
    }
}

