/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import jeus.jms.common.util.ISerialExecutable;
import jeus.jms.server.message.ServerMessage;
import jeus.jms.server.util.ExecutionCycle;
import jeus.util.concurrent.SynchronizedBoolean;

public abstract class ServerSerialExecutable
extends ExecutionCycle
implements ISerialExecutable {
    private boolean suspend;
    private SynchronizedBoolean executing;
    private ServerMessage initialWork;
    private final LinkedList works;

    public ServerSerialExecutable() {
        this.works = new LinkedList();
        this.executing = new SynchronizedBoolean(false, (Object)this.works);
    }

    public ServerSerialExecutable(LinkedList works) {
        this.works = works;
        this.executing = new SynchronizedBoolean(false, (Object)works);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getWorks() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.getAll();
        }
    }

    private LinkedList getAll() {
        if (this.initialWork != null) {
            this.works.addFirst(this.initialWork);
            this.initialWork = null;
        }
        return this.works;
    }

    private void enqueueFirst(ServerMessage message) {
        if (this.initialWork == null) {
            this.initialWork = message;
        } else {
            this.works.addFirst(message);
        }
    }

    private void enqueueFirst(Collection messages) {
        if (this.initialWork != null) {
            this.works.addFirst(this.initialWork);
            this.initialWork = null;
        }
        this.works.addAll(0, messages);
    }

    private void enqueueLast(ServerMessage message) {
        if (this.checkEmpty()) {
            this.initialWork = message;
        } else {
            this.works.addLast(message);
        }
    }

    private ServerMessage dequeueFirst() {
        if (this.initialWork != null) {
            ServerMessage message = this.initialWork;
            this.initialWork = null;
            return message;
        }
        if (!this.works.isEmpty()) {
            return (ServerMessage)this.works.removeFirst();
        }
        return null;
    }

    private boolean checkEmpty() {
        return this.initialWork == null && this.works.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.works.size() + (this.initialWork == null ? 0 : 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.checkEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWorks() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.initialWork = null;
            this.works.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspend(boolean suspend) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.suspend = suspend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueWork(ServerMessage message) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.enqueueLast(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueuePriorityWork(ServerMessage message) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            if (this.checkEmpty()) {
                this.initialWork = message;
                return;
            }
            int priority = message.getJMSPriority();
            if (this.initialWork != null && this.initialWork.getJMSPriority() < priority) {
                this.works.addFirst(this.initialWork);
                this.initialWork = message;
                return;
            }
            ListIterator<ServerMessage> it = this.works.listIterator(0);
            while (it.hasNext()) {
                ServerMessage target = (ServerMessage)it.next();
                if (target.getJMSPriority() >= priority) continue;
                it.add(message);
                return;
            }
            this.enqueueLast(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeueMessage(ServerMessage message) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            if (message == this.initialWork) {
                this.initialWork = null;
            } else {
                this.works.remove(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerMessage dequeueWork() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.dequeueFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkExecutor() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return !this.suspend && !this.checkEmpty() && this.executing.commit(false, true);
        }
    }

    public boolean isExecuting() {
        return this.executing.get();
    }

    public void setExecuting(boolean execute) {
        this.executing.set(execute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(ServerMessage message) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.enqueueFirst(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(Collection messages) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.enqueueFirst(messages);
        }
    }

    public int queuedWorks() {
        return this.works.size();
    }

    public void run() {
        this.workStarted();
        ServerMessage message = this.removeFirstMessage();
        while (message != null) {
            this.startWork(message);
            message = this.removeFirstMessage();
        }
        this.worksCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerMessage removeFirstMessage() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            ServerMessage message = this.suspend ? null : this.dequeueFirst();
            this.executing.set(message != null);
            return message;
        }
    }
}

