/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.wrapper;

import java.util.Hashtable;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.Reference;
import jeus.jms.client.external.TransactionProvider;
import jeus.jms.wrapper.ConnectionFactoryWrapper;
import jeus.jms.wrapper.XAQueueConnectionFactoryWrapper;
import jeus.jms.wrapper.XATopicConnectionFactoryWrapper;
import jeus.transaction.RecoveryThread;
import jeus.transaction.XAResourceFactory;
import jeus.transaction.logging.JEUSXAResourceFactory;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusException;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS12;

public class ForeignJMSConnectionFactoryManager {
    private static Map conFactories = new Hashtable();
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public static synchronized boolean containsFactory(String exportName) {
        return conFactories.containsKey(exportName);
    }

    public static synchronized Object getFactory(Reference ref) {
        String exportName = (String)ref.get(1).getContent();
        String vendor = (String)ref.get(3).getContent();
        Object conFactory = conFactories.get(exportName);
        if (conFactory != null) {
            return conFactory;
        }
        int resourceType = Integer.parseInt((String)ref.get(2).getContent());
        try {
            TransactionProvider provider;
            switch (resourceType) {
                case 5: {
                    conFactory = new XAQueueConnectionFactoryWrapper(ref, exportName, false, 5, vendor);
                    break;
                }
                case 6: {
                    conFactory = new XATopicConnectionFactoryWrapper(ref, exportName, false, 6, vendor);
                    break;
                }
                case 7: {
                    conFactory = new XAQueueConnectionFactoryWrapper(ref, exportName, true, 7, vendor);
                    break;
                }
                case 8: {
                    conFactory = new XATopicConnectionFactoryWrapper(ref, exportName, true, 8, vendor);
                    break;
                }
                default: {
                    throw new JMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._13016, (Object)exportName));
                }
            }
            if ((resourceType == 7 || resourceType == 8) && (provider = TransactionProvider.getTransactionProvider()) != null) {
                provider.registerXAConnectionFactory(ref, exportName);
            }
            conFactories.put(exportName, conFactory);
            return conFactory;
        }
        catch (Throwable t) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS12._12091_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS12._12091_LEVEL, JeusMessage_JMS12._12091, exportName, t);
            }
            throw new JeusRuntimeException(JeusMessage_JMS._13017, (Object)exportName, t);
        }
    }

    public static XAConnection getControlConnection(Reference ref) throws JMSException {
        int resourceType = Integer.parseInt((String)ref.get(2).getContent());
        String exportName = (String)ref.get(1).getContent();
        if (resourceType == 5) {
            return ((XAQueueConnectionFactory)XAQueueConnectionFactoryWrapper.getFactoryFromReference(ref, exportName)).createXAQueueConnection();
        }
        return ((XATopicConnectionFactory)XATopicConnectionFactoryWrapper.getFactoryFromReference(ref, exportName)).createXATopicConnection();
    }

    public static boolean resyncJMSServer(String exportName) throws JeusException {
        ConnectionFactoryWrapper conFactory = (ConnectionFactoryWrapper)conFactories.get(exportName);
        try {
            Reference ref;
            if (conFactory == null) {
                new InitialContext().lookup(exportName);
                conFactory = (ConnectionFactoryWrapper)conFactories.get(exportName);
                if (conFactory == null) {
                    return false;
                }
                ref = conFactory.getReference();
            } else {
                ref = conFactory.getReference();
            }
            if (conFactory.getResourceType() != 5 && conFactory.getResourceType() != 6) {
                return false;
            }
            RecoveryThread t = new RecoveryThread((XAResourceFactory)new JEUSXAResourceFactory(ref));
            t.setDaemon(true);
            t.start();
            if (LogUtils.isLoggable(logger, JeusMessage_JMS12._12092_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS12._12092_LEVEL, JeusMessage_JMS12._12092, exportName);
            }
            return true;
        }
        catch (Throwable t) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS12._12093_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS12._12093_LEVEL, JeusMessage_JMS12._12093, exportName, t);
            }
            throw new JeusException(JeusMessage_JMS._13020, (Object)exportName, t);
        }
    }
}

