/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.wrapper;

import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import jeus.jms.client.external.TransactionProvider;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.wrapper.JMSLocalXAResourceWrapper;
import jeus.jms.wrapper.JMSTransaction;
import jeus.jms.wrapper.JMSXAResourceWrapper;
import jeus.transaction.TransactionImpl;
import jeus.transaction.resources.LocalXAResourceWrapper;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS12;

public class JMSTransactionHandler
implements JMSTransaction {
    private Session Ses;
    private XAResource xaRsc;
    private boolean isLocalTransaction;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public JMSTransactionHandler(Session Ses, boolean isLocalTransaction) {
        this.Ses = Ses;
        this.isLocalTransaction = isLocalTransaction;
    }

    public void enlistXAResource() throws JMSException {
        if (this.xaRsc != null) {
            return;
        }
        try {
            TransactionImpl tx = (TransactionImpl)TransactionProvider.getUnsharedTransaction();
            if (tx == null) {
                return;
            }
            if (this.isLocalTransaction) {
                this.xaRsc = new JMSLocalXAResourceWrapper(this.Ses, this);
                tx.setLocalXAResource((LocalXAResourceWrapper)((JMSLocalXAResourceWrapper)((Object)this.xaRsc)));
            } else {
                this.xaRsc = new JMSXAResourceWrapper(((XASession)this.Ses).getXAResource(), this);
                tx.enlistResource(this.xaRsc);
            }
            if (LogUtils.isLoggable(logger, JeusMessage_JMS12._12031_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS12._12031_LEVEL, JeusMessage_JMS12._12031, tx.getGTID());
            }
        }
        catch (Throwable ex) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4901);
        }
    }

    public void enforceEnd() {
        this.xaRsc = null;
    }
}

