/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.wrapper;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import jeus.jms.client.external.TransactionProvider;
import jeus.jms.wrapper.JMSTransactionHandler;
import jeus.jms.wrapper.SessionWrapper;
import jeus.jms.wrapper.TopicPublisherWrapper;
import jeus.jms.wrapper.TopicSubscriberWrapper;

public class TopicSessionWrapper
extends JMSTransactionHandler
implements TopicSession,
SessionWrapper {
    private TopicSession session;
    private String vendor;

    public TopicSessionWrapper(TopicSession Tses, boolean isLocalTransaction, String vendor) {
        super((Session)Tses, isLocalTransaction);
        this.session = Tses;
        this.vendor = vendor;
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.session.getAcknowledgeMode();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return this.session.createProducer(destination);
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.session.createTopic(topicName);
    }

    public Queue createQueue(String queueName) throws JMSException {
        throw new IllegalStateException("Queue operation not supported");
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        throw new IllegalStateException("Queue operation not supported");
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        throw new IllegalStateException("Queue operation not supported");
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new IllegalStateException("Queue operation not supported");
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return new TopicSubscriberWrapper(this.session.createSubscriber((Topic)destination), this);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return new TopicSubscriberWrapper(this.session.createSubscriber((Topic)destination, messageSelector, false), this);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return new TopicSubscriberWrapper(this.session.createSubscriber((Topic)destination, messageSelector, noLocal), this);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return new TopicSubscriberWrapper(this.session.createSubscriber(topic), this);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return new TopicSubscriberWrapper(this.session.createSubscriber(topic, messageSelector, noLocal), this);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return new TopicSubscriberWrapper(this.session.createDurableSubscriber(topic, name), this);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return new TopicSubscriberWrapper(this.session.createDurableSubscriber(topic, name, messageSelector, noLocal), this);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return new TopicPublisherWrapper(this.session.createPublisher(topic), this);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.session.createTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException {
        this.session.unsubscribe(name);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.session.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.session.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.session.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.session.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.session.createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.session.createTextMessage(text);
    }

    public boolean getTransacted() throws JMSException {
        return this.session.getTransacted();
    }

    public void commit() throws JMSException {
        this.session.commit();
    }

    public void rollback() throws JMSException {
        this.session.rollback();
    }

    public void close() throws JMSException {
        this.session.close();
    }

    public void recover() throws JMSException {
        this.session.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.session.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.session.setMessageListener(listener);
    }

    public void run() {
        if (this.vendor.equals("ibmmq")) {
            try {
                TransactionProvider.beginUnsharedTransaction();
                this.enlistXAResource();
            }
            catch (Exception jmse) {
                throw new RuntimeException(jmse.toString());
            }
        }
        this.session.run();
    }

    public Session getDelegate() {
        return this.session;
    }
}

