/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.wrapper;

import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import jeus.jms.wrapper.XATopicSessionWrapper;

public class XATopicConnectionWrapper
implements XATopicConnection {
    private TopicConnection Tcon;
    private boolean isLocalTransaction;
    private String vendor;

    public XATopicConnectionWrapper(TopicConnection Tcon, boolean isLocalTransaction, String vendor) {
        this.Tcon = Tcon;
        this.isLocalTransaction = isLocalTransaction;
        this.vendor = vendor;
    }

    public XATopicSession createXATopicSession() throws JMSException {
        if (this.isLocalTransaction) {
            return new XATopicSessionWrapper((Session)this.Tcon.createTopicSession(true, 1), true, this.vendor);
        }
        return new XATopicSessionWrapper((Session)((XATopicConnection)this.Tcon).createXATopicSession(), false, this.vendor);
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createXATopicSession().getTopicSession();
    }

    public XASession createXASession() throws JMSException {
        if (this.isLocalTransaction) {
            return new XATopicSessionWrapper((Session)this.Tcon.createTopicSession(true, 1), true, this.vendor);
        }
        return new XATopicSessionWrapper((Session)((XATopicConnection)this.Tcon).createXATopicSession(), false, this.vendor);
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createXATopicSession().getTopicSession();
    }

    public ConnectionConsumer createConnectionConsumer(Destination topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.Tcon.createConnectionConsumer(topic, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.Tcon.createConnectionConsumer(topic, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.Tcon.createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    public String getClientID() throws JMSException {
        return this.Tcon.getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        this.Tcon.setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.Tcon.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.Tcon.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.Tcon.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.Tcon.start();
    }

    public void stop() throws JMSException {
        this.Tcon.stop();
    }

    public void close() throws JMSException {
        this.Tcon.close();
    }
}

