/*
 * Decompiled with CFR 0.152.
 */
package jeus.nio;

import jeus.nio.BufferOverflowException;
import jeus.nio.BufferUnderflowException;
import jeus.nio.InvalidMarkException;

abstract class Buffer {
    private int mark = -1;
    private int position = 0;
    private int limit;
    private int capacity;
    long address;

    Buffer(int mark, int pos, int lim, int cap) {
        if (cap < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = cap;
        this.limit(lim);
        this.position(pos);
        if (mark > 0) {
            if (mark > pos) {
                throw new IllegalArgumentException();
            }
            this.mark = mark;
        }
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int position() {
        return this.position;
    }

    public final Buffer position(int newPosition) {
        if (newPosition > this.limit || newPosition < 0) {
            throw new IllegalArgumentException();
        }
        this.position = newPosition;
        if (this.mark > this.position) {
            this.mark = -1;
        }
        return this;
    }

    public final int limit() {
        return this.limit;
    }

    public final Buffer limit(int newLimit) {
        if (newLimit > this.capacity || newLimit < 0) {
            throw new IllegalArgumentException();
        }
        this.limit = newLimit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        if (this.mark > this.limit) {
            this.mark = -1;
        }
        return this;
    }

    public final Buffer mark() {
        this.mark = this.position;
        return this;
    }

    public final Buffer reset() {
        int m = this.mark;
        if (m < 0) {
            throw new InvalidMarkException();
        }
        this.position = m;
        return this;
    }

    public final Buffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public final Buffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final Buffer rewind() {
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    public abstract boolean isReadOnly();

    final int nextGetIndex() {
        if (this.position >= this.limit) {
            throw new BufferUnderflowException();
        }
        return this.position++;
    }

    final int nextGetIndex(int nb) {
        if (this.position + nb > this.limit) {
            throw new BufferUnderflowException();
        }
        int p = this.position;
        this.position += nb;
        return p;
    }

    final int nextPutIndex() {
        if (this.position >= this.limit) {
            throw new BufferOverflowException();
        }
        return this.position++;
    }

    final int nextPutIndex(int nb) {
        if (this.position + nb > this.limit) {
            throw new BufferOverflowException();
        }
        int p = this.position;
        this.position += nb;
        return p;
    }

    final int checkIndex(int i) {
        if (i < 0 || i >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return i;
    }

    final int checkIndex(int i, int nb) {
        if (i < 0 || i + nb > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return i;
    }

    final int markValue() {
        return this.mark;
    }

    static void checkBounds(int off, int len, int size) {
        if ((off | len | off + len | size - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }
}

