/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.tar;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.bzip2.CBZip2InputStream;
import org.codehaus.plexus.archiver.tar.TarEntry;
import org.codehaus.plexus.archiver.tar.TarInputStream;
import org.codehaus.plexus.archiver.util.EnumeratedAttribute;
import org.codehaus.plexus.archiver.zip.AbstractZipUnArchiver;

public class TarUnArchiver
extends AbstractZipUnArchiver {
    private UntarCompressionMethod compression = new UntarCompressionMethod();

    public TarUnArchiver() {
    }

    public TarUnArchiver(File sourceFile) {
        super(sourceFile);
    }

    public void setCompression(UntarCompressionMethod method) {
        this.compression = method;
    }

    public void setEncoding(String encoding) {
        this.getLogger().warn("The TarUnArchiver doesn't support the encoding attribute");
    }

    protected void execute() throws ArchiverException {
        TarInputStream tis = null;
        try {
            TarEntry te;
            this.getLogger().info("Expanding: " + this.getSourceFile() + " into " + this.getDestDirectory());
            tis = new TarInputStream(this.compression.decompress(this.getSourceFile(), new BufferedInputStream(new FileInputStream(this.getSourceFile()))));
            while ((te = tis.getNextEntry()) != null) {
                this.extractFile(this.getSourceFile(), this.getDestDirectory(), tis, te.getName(), te.getModTime(), te.isDirectory(), new Integer(te.getMode()));
            }
            this.getLogger().debug("expand complete");
        }
        catch (IOException ioe) {
            throw new ArchiverException("Error while expanding " + this.getSourceFile().getAbsolutePath(), ioe);
        }
        finally {
            if (tis != null) {
                try {
                    tis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static final class UntarCompressionMethod
    extends EnumeratedAttribute {
        private static final String NONE = "none";
        private static final String GZIP = "gzip";
        private static final String BZIP2 = "bzip2";

        public UntarCompressionMethod() {
            try {
                this.setValue(NONE);
            }
            catch (ArchiverException archiverException) {
                // empty catch block
            }
        }

        public UntarCompressionMethod(String method) {
            try {
                this.setValue(method);
            }
            catch (ArchiverException archiverException) {
                // empty catch block
            }
        }

        public String[] getValues() {
            return new String[]{NONE, GZIP, BZIP2};
        }

        private InputStream decompress(File file, InputStream istream) throws IOException, ArchiverException {
            String value = this.getValue();
            if (GZIP.equals(value)) {
                return new GZIPInputStream(istream);
            }
            if (BZIP2.equals(value)) {
                char[] magic = new char[]{'B', 'Z'};
                for (int i = 0; i < magic.length; ++i) {
                    if (istream.read() == magic[i]) continue;
                    throw new ArchiverException("Invalid bz2 file." + file.toString());
                }
                return new CBZip2InputStream(istream);
            }
            return istream;
        }
    }
}

