/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.opensaml.BindingException;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLAuthorityBinding;
import org.opensaml.SAMLBinding;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SOAPException;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class SAMLSOAPBinding
implements SAMLBinding {
    private static Logger log = Logger.getLogger((String)(class$org$opensaml$SAMLSOAPBinding == null ? (class$org$opensaml$SAMLSOAPBinding = SAMLSOAPBinding.class$("org.opensaml.SAMLSOAPBinding")) : class$org$opensaml$SAMLSOAPBinding).getName());
    protected SAMLConfig config = SAMLConfig.instance();
    static /* synthetic */ Class class$org$opensaml$SAMLSOAPBinding;

    public SAMLResponse send(SAMLAuthorityBinding sAMLAuthorityBinding, SAMLRequest sAMLRequest) throws SAMLException {
        try {
            Object object;
            Object object2;
            Object object3;
            String string;
            Object object4;
            NDC.push((String)"send");
            Document document = sAMLRequest.toDOM().getOwnerDocument();
            Element element = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://schemas.xmlsoap.org/soap/envelope/");
            Element element2 = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            element.appendChild(element2);
            element2.appendChild(sAMLRequest.toDOM());
            if (document.getDocumentElement() == null) {
                document.appendChild(element);
            } else {
                document.replaceChild(element, document.getDocumentElement());
            }
            log.debug((Object)("connecting to SAML authority at " + sAMLAuthorityBinding.getLocation()));
            URLConnection uRLConnection = new URL(sAMLAuthorityBinding.getLocation()).openConnection();
            uRLConnection.setAllowUserInteraction(false);
            uRLConnection.setDoOutput(true);
            ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
            ((HttpURLConnection)uRLConnection).setRequestMethod("POST");
            ((HttpURLConnection)uRLConnection).setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
            ((HttpURLConnection)uRLConnection).setRequestProperty("SOAPAction", "http://www.oasis-open.org/committees/security");
            if (uRLConnection instanceof HttpsURLConnection && (object4 = this.config.getProperty("ssl-keystore")) != null) {
                string = this.config.getProperty("ssl-alias");
                object3 = this.config.getProperty("ssl-keystore-pwd");
                object2 = this.config.getProperty("ssl-key-pwd");
                object = KeyStore.getInstance("JKS");
                ((KeyStore)object).load(new FileInputStream((String)object4), object3 != null ? ((String)object3).toCharArray() : null);
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyManagerFactory.init((KeyStore)object, object2 != null ? ((String)object2).toCharArray() : null);
                sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
                ((HttpsURLConnection)uRLConnection).setSSLSocketFactory(sSLContext.getSocketFactory());
            }
            object4 = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            uRLConnection.connect();
            uRLConnection.getOutputStream().write(object4.canonicalizeSubtree((Node)element));
            string = ((HttpURLConnection)uRLConnection).getContentType();
            if (!string.startsWith("text/xml")) {
                log.error((Object)("send() received an invalid content type in the response (" + string + "), with the following content:"));
                object3 = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                log.error((Object)((BufferedReader)object3).readLine());
                throw new BindingException(SAMLException.RESPONDER, "send() detected an invalid content type in the response: " + string);
            }
            element = XML.parserPool.parse(uRLConnection.getInputStream()).getDocumentElement();
            if (!XML.isElementNamed(element, "http://schemas.xmlsoap.org/soap/envelope/", "Envelope")) {
                throw new MalformedException(SAMLException.RESPONDER, "SAMLSOAPBinding::send() detected an incompatible or missing SOAP envelope");
            }
            object3 = XML.getFirstChildElement(element);
            if (XML.isElementNamed((Element)object3, "http://schemas.xmlsoap.org/soap/envelope/", "Header")) {
                for (object2 = object3.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                    if (object2.getNodeType() != 1 || ((Element)object2).getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand") == null || !((Element)object2).getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand").equals("1")) continue;
                    throw new SOAPException(SAMLException.RESPONDER, "SAMLSOAPBinding::send() detected a mandatory SOAP header");
                }
                object3 = XML.getNextSiblingElement((Node)object3);
            }
            if (object3 != null && (object3 = XML.getFirstChildElement((Node)object3)) != null) {
                if (object3.getNodeType() == 1 && XML.isElementNamed((Element)object3, "http://schemas.xmlsoap.org/soap/envelope/", "Fault")) {
                    object2 = object3.getElementsByTagNameNS(null, "faultstring");
                    object = object2 != null && object2.getLength() > 0 ? object2.item(0).getFirstChild().getNodeValue() : "SAMLSOAPBinding::send() detected a SOAP fault";
                    object2 = object3.getElementsByTagNameNS(null, "faultstring");
                    if (object2 != null && object2.getLength() > 0) {
                        throw new SOAPException(QName.getQNameTextNode((Text)object2.item(0).getFirstChild()), (String)object);
                    }
                    throw new SOAPException(SOAPException.SERVER, (String)object);
                }
                object2 = new SAMLResponse((Element)object3);
                if (!((SAMLResponse)object2).getInResponseTo().equals(sAMLRequest.getId())) {
                    throw new BindingException("SAMLSOAPBinding.send() unable to match SAML InResponseTo value to request");
                }
                object = object2;
                return object;
            }
            try {
                throw new SOAPException(SOAPException.SERVER, "SAMLSOAPBinding::send() unable to find a SAML response or fault in SOAP body");
            }
            catch (KeyStoreException keyStoreException) {
                throw new SAMLException("SAMLSOAPBinding.send() caught a keystore exception", (Exception)keyStoreException);
            }
            catch (CertificateException certificateException) {
                throw new SAMLException("SAMLSOAPBinding.send() caught a certificate exception", (Exception)certificateException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SAMLException("SAMLSOAPBinding.send() caught a JCE exception", (Exception)noSuchAlgorithmException);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                throw new SAMLException("SAMLSOAPBinding.send() caught a key exception", (Exception)unrecoverableKeyException);
            }
            catch (KeyManagementException keyManagementException) {
                throw new SAMLException("SAMLSOAPBinding.send() caught a key mgmt exception", (Exception)keyManagementException);
            }
            catch (MalformedURLException malformedURLException) {
                throw new SAMLException("SAMLSOAPBinding.send() detected a malformed URL in the binding provided", (Exception)malformedURLException);
            }
            catch (SAXException sAXException) {
                throw new SAMLException("SAMLSOAPBinding.send() caught an XML exception while parsing the response", (Exception)sAXException);
            }
            catch (InvalidCanonicalizerException invalidCanonicalizerException) {
                throw new SAMLException("SAMLSOAPBinding.send() caught a C14N exception while serializing the request", (Exception)((Object)invalidCanonicalizerException));
            }
            catch (CanonicalizationException canonicalizationException) {
                throw new SAMLException("SAMLSOAPBinding.send() caught a C14N exception while serializing the request", (Exception)((Object)canonicalizationException));
            }
            catch (IOException iOException) {
                throw new SAMLException("SAMLSOAPBinding.send() caught an I/O exception", (Exception)iOException);
            }
        }
        finally {
            NDC.pop();
        }
    }

    public SAMLRequest receive(Object object, StringBuffer stringBuffer) throws SAMLException {
        stringBuffer.setLength(0);
        HttpServletRequest httpServletRequest = (HttpServletRequest)object;
        X509Certificate[] x509CertificateArray = (X509Certificate[])httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(x509CertificateArray[0].getSubjectDN().getName(), ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (!string.startsWith("CN=")) continue;
                stringBuffer.append(string.substring(3));
                break;
            }
            log.debug((Object)("Requester name: " + stringBuffer));
        } else {
            log.debug((Object)"No Requester name available.");
        }
        return this.receive(object);
    }

    public SAMLRequest receive(Object object) throws SAMLException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)object;
        if (!httpServletRequest.getMethod().equals("POST") || !httpServletRequest.getContentType().startsWith("text/xml")) {
            throw new BindingException(SAMLException.REQUESTER, "SAMLSOAPBinding.receive() found a bad HTTP method or content type");
        }
        try {
            Node node;
            Document document = XML.parserPool.parse((InputStream)httpServletRequest.getInputStream());
            Element element = document.getDocumentElement();
            if (!XML.isElementNamed(element, "http://schemas.xmlsoap.org/soap/envelope/", "Envelope")) {
                throw new SOAPException(SOAPException.VERSION, "SAMLSOAPBinding.receive() detected an incompatible or missing SOAP envelope");
            }
            for (node = element.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
            }
            if (XML.isElementNamed((Element)node, "http://schemas.xmlsoap.org/soap/envelope/", "Header")) {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getNodeType() != 1 || !((Element)node2).getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand").equals("1")) continue;
                    throw new SOAPException(SOAPException.MUSTUNDERSTAND, "SAMLSOAPBinding.receive() detected a mandatory SOAP header");
                }
                for (node = node.getNextSibling(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
                }
            }
            if (node != null) {
                for (node = node.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
                }
            }
            return new SAMLRequest((Element)node);
        }
        catch (SAXException sAXException) {
            throw new SOAPException(SOAPException.CLIENT, "SAMLSOAPBinding.receive() detected an XML parsing error: " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new SOAPException(SOAPException.SERVER, "SAMLSOAPBinding.receive() detected an I/O error: " + iOException.getMessage());
        }
    }

    public void respond(Object object, SAMLResponse sAMLResponse, SAMLException sAMLException) throws IOException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)object;
        try {
            Document document = sAMLException == null ? sAMLResponse.toDOM().getOwnerDocument() : XML.parserPool.newDocument();
            Element element = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:Envelope");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soap", "http://schemas.xmlsoap.org/soap/envelope/");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (document.getDocumentElement() == null) {
                document.appendChild(element);
            } else {
                document.replaceChild(element, document.getDocumentElement());
            }
            Element element2 = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:Body");
            element.appendChild(element2);
            if (sAMLException != null) {
                Iterator iterator;
                Element element3 = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:Fault");
                element2.appendChild(element3);
                Element element4 = document.createElementNS(null, "faultcode");
                if (sAMLException instanceof SOAPException) {
                    iterator = sAMLException.getCodes();
                    if (iterator.hasNext()) {
                        element4.appendChild(document.createTextNode("soap:" + ((QName)iterator.next()).getLocalName()));
                    } else {
                        element4.appendChild(document.createTextNode("soap:" + SOAPException.SERVER.getLocalName()));
                    }
                } else {
                    element4.appendChild(document.createTextNode("soap:" + SOAPException.SERVER.getLocalName()));
                }
                element3.appendChild(element4);
                element4 = document.createElementNS(null, "faultstring");
                element3.appendChild(element4).appendChild(document.createTextNode(sAMLException.getMessage()));
                httpServletResponse.setStatus(500);
                iterator = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                httpServletResponse.getOutputStream().write(iterator.canonicalizeSubtree(element));
                return;
            }
            element2.appendChild(sAMLResponse.toDOM());
            Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            httpServletResponse.setContentType("text/xml; charset=UTF-8");
            httpServletResponse.getOutputStream().write(canonicalizer.canonicalizeSubtree((Node)element));
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            invalidCanonicalizerException.printStackTrace();
            httpServletResponse.sendError(500, "SAMLSOAPBinding.respond() unable to serialize XML document instance");
        }
        catch (CanonicalizationException canonicalizationException) {
            canonicalizationException.printStackTrace();
            httpServletResponse.sendError(500, "SAMLSOAPBinding.respond() unable to serialize XML document instance");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            httpServletResponse.sendError(500, "SAMLSOAPBinding.respond() caught an unexpected exception: " + exception.getClass().getName() + " " + exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

