/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.transport.servlet.AbstractCXFServlet;
import org.apache.cxf.transport.servlet.ServletContextResourceResolver;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class CXFServlet
extends AbstractCXFServlet {
    private GenericApplicationContext childCtx;

    public static Logger getLogger() {
        return LogUtils.getL7dLogger(CXFServlet.class);
    }

    public void loadBus(ServletConfig servletConfig) throws ServletException {
        String springCls = "org.springframework.context.ApplicationContext";
        try {
            ClassLoaderUtils.loadClass((String)springCls, ((Object)((Object)this)).getClass());
            this.loadSpringBus(servletConfig);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.SEVERE, "FAILED_TO_LOAD_SPRING_BUS", new Object[]{e});
            new ServletException("Can't load bus with Spring context class", (Throwable)e);
        }
    }

    private void loadSpringBus(ServletConfig servletConfig) throws ServletException {
        ServletContext svCtx = this.getServletContext();
        ApplicationContext ctx = (ApplicationContext)svCtx.getAttribute("interface org.springframework.web.context.WebApplicationContext.ROOT");
        if (ctx == null) {
            Object ctxObject = svCtx.getAttribute("org.springframework.web.context.WebApplicationContext.ROOT");
            if (ctxObject instanceof ApplicationContext) {
                ctx = (ApplicationContext)ctxObject;
            } else if (ctxObject != null) {
                Exception ex = (Exception)ctxObject;
                throw new ServletException((Throwable)ex);
            }
        }
        if (ctx == null) {
            LOG.info("LOAD_BUS_WITHOUT_APPLICATION_CONTEXT");
            this.bus = new SpringBusFactory().createBus();
            ctx = (ApplicationContext)this.bus.getExtension(BusApplicationContext.class);
        } else {
            LOG.info("LOAD_BUS_WITH_APPLICATION_CONTEXT");
            this.bus = new SpringBusFactory(ctx).createBus();
        }
        ResourceManager resourceManager = (ResourceManager)this.bus.getExtension(ResourceManager.class);
        resourceManager.addResourceResolver((ResourceResolver)new ServletContextResourceResolver(servletConfig.getServletContext()));
        this.replaceDestinationFactory();
        this.controller = this.createServletController(servletConfig);
        this.loadAdditionalConfig(ctx, servletConfig);
    }

    private void loadAdditionalConfig(ApplicationContext ctx, ServletConfig servletConfig) throws ServletException {
        String location = servletConfig.getInitParameter("config-location");
        if (location == null) {
            location = "/WEB-INF/cxf-servlet.xml";
        }
        InputStream is = null;
        try {
            URIResolver resolver;
            is = servletConfig.getServletContext().getResourceAsStream(location);
            if ((is == null || is.available() == -1) && (resolver = new URIResolver(location)).isResolved()) {
                is = resolver.getInputStream();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (is != null) {
            LOG.log(Level.INFO, "BUILD_ENDPOINTS_FROM_CONFIG_LOCATION", new Object[]{location});
            this.childCtx = new GenericApplicationContext(ctx);
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.childCtx);
            reader.setValidationMode(3);
            reader.loadBeanDefinitions((Resource)new InputStreamResource(is, location));
            this.childCtx.refresh();
        }
    }

    public void destroy() {
        if (this.childCtx != null) {
            this.childCtx.destroy();
        }
        super.destroy();
    }
}

