/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.email;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.email.Mailer;
import org.apache.tools.mail.MailMessage;

class PlainMailer
extends Mailer {
    PlainMailer() {
    }

    public void send() {
        try {
            MailMessage mailMessage = new MailMessage(this.host, this.port);
            mailMessage.from(this.from.toString());
            Enumeration e = this.toList.elements();
            while (e.hasMoreElements()) {
                mailMessage.to(e.nextElement().toString());
            }
            e = this.ccList.elements();
            while (e.hasMoreElements()) {
                mailMessage.cc(e.nextElement().toString());
            }
            e = this.bccList.elements();
            while (e.hasMoreElements()) {
                mailMessage.bcc(e.nextElement().toString());
            }
            if (this.subject != null) {
                mailMessage.setSubject(this.subject);
            }
            mailMessage.setHeader("Date", this.getDate());
            mailMessage.setHeader("Content-Type", this.message.getMimeType());
            PrintStream out = mailMessage.getPrintStream();
            this.message.print(out);
            e = this.files.elements();
            while (e.hasMoreElements()) {
                File file = (File)e.nextElement();
                this.attach(file, out);
            }
            mailMessage.sendAndClose();
        }
        catch (IOException ioe) {
            throw new BuildException("IO error sending mail", ioe);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void attach(File file, PrintStream out) throws IOException {
        if (!file.exists() || !file.canRead()) {
            throw new BuildException("File \"" + file.getName() + "\" does not exist or is not " + "readable.");
        }
        if (this.includeFileNames) {
            out.println();
            String filename = file.getName();
            int filenamelength = filename.length();
            out.println(filename);
            int star = 0;
            while (star < filenamelength) {
                out.print('=');
                ++star;
            }
            out.println();
        }
        byte[] buf = new byte[1024];
        FileInputStream finstr = new FileInputStream(file);
        try {
            int length;
            BufferedInputStream in = new BufferedInputStream(finstr, buf.length);
            while ((length = in.read(buf)) != -1) {
                void filename;
                out.write(buf, 0, (int)filename);
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            finstr.close();
            throw throwable;
        }
        finstr.close();
    }
}

