/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo.support;

import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.support.DaoSupport;
import org.springframework.orm.jdo.JdoTemplate;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;

public abstract class JdoDaoSupport
extends DaoSupport {
    private JdoTemplate jdoTemplate;

    public final void setPersistenceManagerFactory(PersistenceManagerFactory persistenceManagerFactory) {
        if (this.jdoTemplate == null || persistenceManagerFactory != this.jdoTemplate.getPersistenceManagerFactory()) {
            this.jdoTemplate = this.createJdoTemplate(persistenceManagerFactory);
        }
    }

    protected JdoTemplate createJdoTemplate(PersistenceManagerFactory persistenceManagerFactory) {
        return new JdoTemplate(persistenceManagerFactory);
    }

    public final PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.jdoTemplate != null ? this.jdoTemplate.getPersistenceManagerFactory() : null;
    }

    public final void setJdoTemplate(JdoTemplate jdoTemplate) {
        this.jdoTemplate = jdoTemplate;
    }

    public final JdoTemplate getJdoTemplate() {
        return this.jdoTemplate;
    }

    protected final void checkDaoConfig() {
        if (this.jdoTemplate == null) {
            throw new IllegalArgumentException("persistenceManagerFactory or jdoTemplate is required");
        }
    }

    protected final PersistenceManager getPersistenceManager() {
        return this.getPersistenceManager(this.jdoTemplate.isAllowCreate());
    }

    protected final PersistenceManager getPersistenceManager(boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        return PersistenceManagerFactoryUtils.getPersistenceManager(this.getPersistenceManagerFactory(), allowCreate);
    }

    protected final DataAccessException convertJdoAccessException(JDOException ex) {
        return this.jdoTemplate.convertJdoAccessException(ex);
    }

    protected final void releasePersistenceManager(PersistenceManager pm) {
        PersistenceManagerFactoryUtils.releasePersistenceManager(pm, this.getPersistenceManagerFactory());
    }
}

