/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.javadoc.JavadocReport;
import org.apache.maven.plugin.javadoc.JavadocUtil;
import org.apache.maven.plugin.javadoc.options.BootclasspathArtifact;
import org.apache.maven.plugin.javadoc.options.DocletArtifact;
import org.apache.maven.plugin.javadoc.options.Group;
import org.apache.maven.plugin.javadoc.options.JavadocPathArtifact;
import org.apache.maven.plugin.javadoc.options.OfflineLink;
import org.apache.maven.plugin.javadoc.options.ResourcesArtifact;
import org.apache.maven.plugin.javadoc.options.Tag;
import org.apache.maven.plugin.javadoc.options.Taglet;
import org.apache.maven.plugin.javadoc.options.TagletArtifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.wagon.PathUtils;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractJavadocMojo
extends AbstractMojo {
    protected static final String DEBUG_JAVADOC_SCRIPT_NAME = "javadoc." + (SystemUtils.IS_OS_WINDOWS ? "bat" : "sh");
    protected static final String OPTIONS_FILE_NAME = "options";
    protected static final String PACKAGES_FILE_NAME = "packages";
    protected static final String ARGFILE_FILE_NAME = "argfile";
    protected static final String FILES_FILE_NAME = "files";
    private static final String RESOURCE_DIR = ClassUtils.getPackageName((Class)JavadocReport.class).replace('.', '/');
    private static final String DEFAULT_CSS_NAME = "stylesheet.css";
    private static final String RESOURCE_CSS_DIR = RESOURCE_DIR + "/css";
    private static final float SINCE_JAVADOC_1_4 = 1.4f;
    private static final float SINCE_JAVADOC_1_4_2 = 1.42f;
    private static final float SINCE_JAVADOC_1_5 = 1.5f;
    private static final float SINCE_JAVADOC_1_6 = 1.6f;
    private ArchiverManager archiverManager;
    private ArtifactFactory factory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactResolver resolver;
    private MavenProjectBuilder mavenProjectBuilder;
    private MavenSession session;
    private Settings settings;
    protected MavenProject project;
    private boolean isOffline;
    private File javadocDirectory;
    private String additionalparam;
    private String additionalJOption;
    private ResourcesArtifact[] resourcesArtifacts;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private List reactorProjects;
    protected boolean aggregate;
    private boolean debug;
    private String javadocExecutable;
    private String javadocVersion;
    private float fJavadocVersion = 0.0f;
    protected boolean skip;
    protected boolean failOnError;
    protected boolean useStandardDocletOptions;
    private String bootclasspath;
    private BootclasspathArtifact[] bootclasspathArtifacts;
    private boolean breakiterator;
    private String doclet;
    private DocletArtifact docletArtifact;
    private DocletArtifact[] docletArtifacts;
    private String docletPath;
    private String encoding;
    private String excludePackageNames;
    private String extdirs;
    private String locale;
    private String maxmemory;
    private String minmemory;
    private boolean old;
    private File overview;
    private String proxyHost;
    private int proxyPort;
    private boolean quiet;
    private String show;
    private String source;
    private String sourcepath;
    private String subpackages;
    private boolean verbose;
    private boolean author;
    private String bottom;
    private String charset;
    private String docencoding;
    private boolean docfilessubdirs;
    private String doctitle;
    private String excludedocfilessubdir;
    private String footer;
    private Group[] groups;
    private String header;
    private String helpfile;
    private boolean keywords;
    protected ArrayList links;
    private boolean linksource;
    private boolean nocomment;
    private boolean nodeprecated;
    private boolean nodeprecatedlist;
    private boolean nohelp;
    private boolean noindex;
    private boolean nonavbar;
    private boolean nooverview;
    private String noqualifier;
    private boolean nosince;
    private boolean notimestamp;
    private boolean notree;
    private OfflineLink[] offlineLinks;
    protected File outputDirectory;
    private String packagesheader;
    private boolean serialwarn;
    private int sourcetab;
    private boolean splitindex;
    private String stylesheet;
    private String stylesheetfile;
    private String taglet;
    private TagletArtifact tagletArtifact;
    private TagletArtifact[] tagletArtifacts;
    private String tagletpath;
    private Taglet[] taglets;
    private Tag[] tags;
    private String top;
    private boolean use;
    private boolean version;
    private String windowtitle;

    protected boolean isAggregator() {
        return false;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsoluteFile().toString();
    }

    protected List getProjectBuildOutputDirs(MavenProject p) {
        if (StringUtils.isEmpty((String)p.getBuild().getOutputDirectory())) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(p.getBuild().getOutputDirectory());
    }

    protected List getProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getPackaging().toLowerCase())) {
            return Collections.EMPTY_LIST;
        }
        return p.getCompileSourceRoots();
    }

    protected List getExecutionProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getExecutionProject().getPackaging().toLowerCase())) {
            return Collections.EMPTY_LIST;
        }
        return p.getExecutionProject().getCompileSourceRoots();
    }

    protected List getProjectArtifacts(MavenProject p) {
        return p.getCompileArtifacts();
    }

    protected File getJavadocDirectory() {
        return this.javadocDirectory;
    }

    protected String getDoctitle() {
        return this.doctitle;
    }

    protected File getOverview() {
        return this.overview;
    }

    protected String getWindowtitle() {
        return this.windowtitle;
    }

    private String getCharset() {
        return StringUtils.isEmpty((String)this.charset) ? this.getDocencoding() : this.charset;
    }

    private String getDocencoding() {
        return StringUtils.isEmpty((String)this.docencoding) ? "UTF-8" : this.docencoding;
    }

    private String getEncoding() {
        return StringUtils.isEmpty((String)this.encoding) ? ReaderFactory.FILE_ENCODING : this.encoding;
    }

    protected void executeReport(Locale unusedLocale) throws MavenReportException {
        String jExecutable;
        List sourcePaths;
        List files;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping javadoc generation");
            return;
        }
        if (this.isAggregator() && !this.project.isExecutionRoot()) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.debug = true;
        }
        if (!this.canGenerateReport(files = this.getFiles(sourcePaths = this.getSourcePaths()))) {
            return;
        }
        List packageNames = this.getPackageNames(sourcePaths, files);
        List filesWithUnnamedPackages = this.getFilesWithUnnamedPackages(sourcePaths, files);
        try {
            jExecutable = this.getJavadocExecutable();
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to find javadoc command: " + e.getMessage(), (Exception)e);
        }
        this.setFJavadocVersion(new File(jExecutable));
        File javadocOutputDirectory = new File(this.getOutputDirectory());
        if (javadocOutputDirectory.exists() && !javadocOutputDirectory.isDirectory()) {
            throw new MavenReportException("IOException: " + this.getOutputDirectory() + " is not a directory.");
        }
        if (javadocOutputDirectory.exists() && !javadocOutputDirectory.canWrite()) {
            throw new MavenReportException("IOException: " + this.getOutputDirectory() + " is not writable.");
        }
        javadocOutputDirectory.mkdirs();
        this.copyAllResources(javadocOutputDirectory);
        Commandline cmd = new Commandline();
        cmd.getShell().setQuotedArgumentsEnabled(false);
        cmd.setWorkingDirectory(javadocOutputDirectory.getAbsolutePath());
        cmd.setExecutable(jExecutable);
        this.addMemoryArg(cmd, "-Xmx", this.maxmemory);
        this.addMemoryArg(cmd, "-Xms", this.minmemory);
        this.addProxyArg(cmd);
        if (StringUtils.isNotEmpty((String)this.additionalJOption)) {
            cmd.createArg().setValue(this.additionalJOption);
        }
        ArrayList arguments = new ArrayList();
        this.addJavadocOptions(arguments, sourcePaths);
        if (StringUtils.isEmpty((String)this.doclet) || this.useStandardDocletOptions) {
            this.addStandardDocletOptions(javadocOutputDirectory, arguments);
        }
        if (arguments.size() > 0) {
            this.addCommandLineOptions(cmd, arguments, javadocOutputDirectory);
        }
        if (!packageNames.isEmpty()) {
            this.addCommandLinePackages(cmd, javadocOutputDirectory, packageNames);
            if (!filesWithUnnamedPackages.isEmpty()) {
                this.addCommandLineArgFile(cmd, javadocOutputDirectory, filesWithUnnamedPackages);
            }
        } else if (!files.isEmpty()) {
            this.addCommandLineArgFile(cmd, javadocOutputDirectory, files);
        }
        this.executeJavadocCommandLine(cmd, javadocOutputDirectory);
    }

    protected List getFiles(List sourcePaths) {
        ArrayList files = new ArrayList();
        if (StringUtils.isEmpty((String)this.subpackages)) {
            String[] excludedPackages = this.getExcludedPackages();
            Iterator i = sourcePaths.iterator();
            while (i.hasNext()) {
                File sourceDirectory = new File((String)i.next());
                JavadocUtil.addFilesFromSource(files, sourceDirectory, excludedPackages);
            }
        }
        return files;
    }

    protected List getSourcePaths() {
        List<String> sourcePaths;
        if (StringUtils.isEmpty((String)this.sourcepath)) {
            File javadocDir;
            sourcePaths = new ArrayList(JavadocUtil.pruneDirs(this.project, this.getProjectSourceRoots(this.project)));
            if (this.project.getExecutionProject() != null) {
                sourcePaths.addAll(JavadocUtil.pruneDirs(this.project, this.getExecutionProjectSourceRoots(this.project)));
            }
            if (this.getJavadocDirectory() != null && (javadocDir = this.getJavadocDirectory()).exists() && javadocDir.isDirectory()) {
                List l = JavadocUtil.pruneDirs(this.project, Collections.singletonList(this.getJavadocDirectory().getAbsolutePath()));
                sourcePaths.addAll(l);
            }
            if (this.isAggregator() && this.project.isExecutionRoot()) {
                Iterator i = this.reactorProjects.iterator();
                while (i.hasNext()) {
                    ArtifactHandler artifactHandler;
                    MavenProject subProject = (MavenProject)i.next();
                    if (subProject == this.project) continue;
                    List sourceRoots = this.getProjectSourceRoots(subProject);
                    if (subProject.getExecutionProject() != null) {
                        sourceRoots.addAll(this.getExecutionProjectSourceRoots(subProject));
                    }
                    if ("java".equals((artifactHandler = subProject.getArtifact().getArtifactHandler()).getLanguage())) {
                        sourcePaths.addAll(JavadocUtil.pruneDirs(subProject, sourceRoots));
                    }
                    String javadocDirRelative = PathUtils.toRelative((File)this.project.getBasedir(), (String)this.getJavadocDirectory().getAbsolutePath());
                    File javadocDir2 = new File(subProject.getBasedir(), javadocDirRelative);
                    if (!javadocDir2.exists() || !javadocDir2.isDirectory()) continue;
                    List l = JavadocUtil.pruneDirs(subProject, Collections.singletonList(javadocDir2.getAbsolutePath()));
                    sourcePaths.addAll(l);
                }
            }
        } else {
            sourcePaths = new ArrayList<String>(Arrays.asList(this.sourcepath.split("[;]")));
            sourcePaths = JavadocUtil.pruneDirs(this.project, sourcePaths);
            if (this.getJavadocDirectory() != null) {
                List l = JavadocUtil.pruneDirs(this.project, Collections.singletonList(this.getJavadocDirectory().getAbsolutePath()));
                sourcePaths.addAll(l);
            }
        }
        sourcePaths = JavadocUtil.pruneDirs(this.project, sourcePaths);
        return sourcePaths;
    }

    protected boolean canGenerateReport(List files) {
        boolean canGenerate = true;
        if (files.isEmpty() && StringUtils.isEmpty((String)this.subpackages)) {
            canGenerate = false;
        }
        return canGenerate;
    }

    protected List getCompileArtifacts(ArtifactResolutionResult result) {
        return JavadocUtil.getCompileArtifacts(result.getArtifacts(), false);
    }

    private String getExcludedPackages(List sourcePaths) {
        List excludedNames = null;
        if (StringUtils.isNotEmpty((String)this.sourcepath) && StringUtils.isNotEmpty((String)this.subpackages)) {
            String[] excludedPackages = this.getExcludedPackages();
            String[] subpackagesList = this.subpackages.split("[:]");
            excludedNames = JavadocUtil.getExcludedNames(sourcePaths, subpackagesList, excludedPackages);
        }
        String excludeArg = "";
        if (StringUtils.isNotEmpty((String)this.subpackages) && excludedNames != null) {
            Iterator it = excludedNames.iterator();
            while (it.hasNext()) {
                String str = (String)it.next();
                excludeArg = excludeArg + str;
                if (!it.hasNext()) continue;
                excludeArg = excludeArg + ":";
            }
        }
        return excludeArg;
    }

    private String getSourcePath(List sourcePaths) {
        String sourcePath = null;
        if (StringUtils.isEmpty((String)this.subpackages) || StringUtils.isNotEmpty((String)this.sourcepath)) {
            sourcePath = StringUtils.join(sourcePaths.iterator(), (String)File.pathSeparator);
        }
        return sourcePath;
    }

    private String[] getExcludedPackages() {
        String[] excludePackages = new String[]{};
        if (this.excludePackageNames != null) {
            excludePackages = this.excludePackageNames.split("[ ,:;]");
        }
        for (int i = 0; i < excludePackages.length; ++i) {
            excludePackages[i] = excludePackages[i].replace('.', File.separatorChar);
        }
        return excludePackages;
    }

    private String getClasspath() throws MavenReportException {
        ArrayList<File> classpathElements = new ArrayList<File>();
        HashMap compileArtifactMap = new HashMap();
        classpathElements.addAll(this.getProjectBuildOutputDirs(this.project));
        this.populateCompileArtifactMap(compileArtifactMap, this.getProjectArtifacts(this.project));
        if (this.isAggregator() && this.project.isExecutionRoot()) {
            try {
                Iterator i = this.reactorProjects.iterator();
                while (i.hasNext()) {
                    MavenProject subProject = (MavenProject)i.next();
                    if (subProject == this.project) continue;
                    classpathElements.addAll(this.getProjectBuildOutputDirs(subProject));
                    Set dependencyArtifacts = subProject.createArtifacts(this.factory, null, null);
                    if (dependencyArtifacts.isEmpty()) continue;
                    ArtifactResolutionResult result = null;
                    try {
                        result = this.resolver.resolveTransitively(dependencyArtifacts, subProject.getArtifact(), subProject.getManagedVersionMap(), this.localRepository, subProject.getRemoteArtifactRepositories(), this.artifactMetadataSource);
                    }
                    catch (MultipleArtifactsNotFoundException e) {
                        if (this.checkMissingArtifactsInReactor(dependencyArtifacts, e.getMissingArtifacts())) {
                            this.getLog().warn((CharSequence)"IGNORED to add some artifacts in the classpath. See above.");
                        }
                        throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
                    }
                    catch (ArtifactNotFoundException e) {
                        throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
                    }
                    catch (ArtifactResolutionException e) {
                        throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
                    }
                    if (result == null) continue;
                    this.populateCompileArtifactMap(compileArtifactMap, this.getCompileArtifacts(result));
                    if (!this.getLog().isDebugEnabled()) continue;
                    StringBuffer sb = new StringBuffer();
                    sb.append("Compiled artifacts for ");
                    sb.append(subProject.getGroupId()).append(":");
                    sb.append(subProject.getArtifactId()).append(":");
                    sb.append(subProject.getVersion()).append('\n');
                    Iterator it = compileArtifactMap.keySet().iterator();
                    while (it.hasNext()) {
                        String key = it.next().toString();
                        Artifact a = (Artifact)compileArtifactMap.get(key);
                        sb.append(a.getFile()).append('\n');
                    }
                    this.getLog().debug((CharSequence)sb.toString());
                }
            }
            catch (InvalidDependencyVersionException e) {
                throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
            }
        }
        Iterator it = compileArtifactMap.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            Artifact a = (Artifact)compileArtifactMap.get(key);
            classpathElements.add(a.getFile());
        }
        return StringUtils.join(classpathElements.iterator(), (String)File.pathSeparator);
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        try {
            ToolchainManager toolchainManager;
            if (this.session != null && (toolchainManager = (ToolchainManager)this.session.getContainer().lookup(ToolchainManager.ROLE)) != null) {
                tc = toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return tc;
    }

    private void populateCompileArtifactMap(Map compileArtifactMap, Collection artifactList) throws MavenReportException {
        if (artifactList != null) {
            Iterator i = artifactList.iterator();
            while (i.hasNext()) {
                Artifact newArtifact = (Artifact)i.next();
                File file = newArtifact.getFile();
                if (file == null) {
                    throw new MavenReportException("Error in plugin descriptor - dependency was not resolved for artifact: " + newArtifact.getGroupId() + ":" + newArtifact.getArtifactId() + ":" + newArtifact.getVersion());
                }
                if (compileArtifactMap.get(newArtifact.getDependencyConflictId()) != null) {
                    Artifact oldArtifact = (Artifact)compileArtifactMap.get(newArtifact.getDependencyConflictId());
                    DefaultArtifactVersion oldVersion = new DefaultArtifactVersion(oldArtifact.getVersion());
                    DefaultArtifactVersion newVersion = new DefaultArtifactVersion(newArtifact.getVersion());
                    if (newVersion.compareTo((Object)oldVersion) <= 0) continue;
                    compileArtifactMap.put(newArtifact.getDependencyConflictId(), newArtifact);
                    continue;
                }
                compileArtifactMap.put(newArtifact.getDependencyConflictId(), newArtifact);
            }
        }
    }

    private String getBottomText() {
        int actualYear = Calendar.getInstance().get(1);
        String year = String.valueOf(actualYear);
        String inceptionYear = this.project.getInceptionYear();
        String theBottom = StringUtils.replace((String)this.bottom, (String)"{currentYear}", (String)year);
        theBottom = inceptionYear != null ? (inceptionYear.equals(year) ? StringUtils.replace((String)theBottom, (String)"{inceptionYear}-", (String)"") : StringUtils.replace((String)theBottom, (String)"{inceptionYear}", (String)inceptionYear)) : StringUtils.replace((String)theBottom, (String)"{inceptionYear}-", (String)"");
        theBottom = this.project.getOrganization() == null ? StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)"") : (StringUtils.isNotEmpty((String)this.project.getOrganization().getName()) ? (StringUtils.isNotEmpty((String)this.project.getOrganization().getUrl()) ? StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)("<a href=\"" + this.project.getOrganization().getUrl() + "\">" + this.project.getOrganization().getName() + "</a>")) : StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)this.project.getOrganization().getName())) : StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)""));
        return theBottom;
    }

    private String getStylesheetFile(File javadocOutputDirectory) {
        String stylesheetfilePath = this.stylesheetfile;
        if (StringUtils.isEmpty((String)stylesheetfilePath) && "maven".equals(this.stylesheet)) {
            stylesheetfilePath = javadocOutputDirectory + File.separator + DEFAULT_CSS_NAME;
        }
        return stylesheetfilePath;
    }

    private String getAccessLevel() {
        String accessLevel;
        if ("public".equalsIgnoreCase(this.show) || "protected".equalsIgnoreCase(this.show) || "package".equalsIgnoreCase(this.show) || "private".equalsIgnoreCase(this.show)) {
            accessLevel = "-" + this.show;
        } else {
            if (this.getLog().isErrorEnabled()) {
                this.getLog().error((CharSequence)("Unrecognized access level to show '" + this.show + "'. Defaulting to protected."));
            }
            accessLevel = "-protected";
        }
        return accessLevel;
    }

    private String getBootclassPath() throws MavenReportException {
        StringBuffer path = new StringBuffer();
        if (this.bootclasspathArtifacts != null) {
            List bootclassPath = new ArrayList();
            for (int i = 0; i < this.bootclasspathArtifacts.length; ++i) {
                BootclasspathArtifact aBootclasspathArtifact = this.bootclasspathArtifacts[i];
                if (!StringUtils.isNotEmpty((String)aBootclasspathArtifact.getGroupId()) || !StringUtils.isNotEmpty((String)aBootclasspathArtifact.getArtifactId()) || !StringUtils.isNotEmpty((String)aBootclasspathArtifact.getVersion())) continue;
                bootclassPath.addAll(this.getArtifactsAbsolutePath(aBootclasspathArtifact));
            }
            bootclassPath = JavadocUtil.pruneFiles(bootclassPath);
            path.append(StringUtils.join(bootclassPath.iterator(), (String)File.pathSeparator));
        }
        if (StringUtils.isNotEmpty((String)this.bootclasspath)) {
            path.append(this.bootclasspath);
        }
        return path.toString();
    }

    private String getDocletPath() throws MavenReportException {
        StringBuffer path = new StringBuffer();
        if (!this.isDocletArtifactEmpty(this.docletArtifact)) {
            path.append(StringUtils.join(this.getArtifactsAbsolutePath(this.docletArtifact).iterator(), (String)File.pathSeparator));
        } else if (this.docletArtifacts != null) {
            for (int i = 0; i < this.docletArtifacts.length; ++i) {
                if (this.isDocletArtifactEmpty(this.docletArtifacts[i])) continue;
                path.append(StringUtils.join(this.getArtifactsAbsolutePath(this.docletArtifacts[i]).iterator(), (String)File.pathSeparator));
                if (i >= this.docletArtifacts.length - 1) continue;
                path.append(File.pathSeparator);
            }
        }
        if (!StringUtils.isEmpty((String)this.docletPath)) {
            path.append(this.docletPath);
        }
        if (StringUtils.isEmpty((String)path.toString()) && this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)"No docletpath option was found. Please review <docletpath/> or <docletArtifact/> or <doclets/>.");
        }
        return path.toString();
    }

    private boolean isDocletArtifactEmpty(DocletArtifact aDocletArtifact) {
        if (aDocletArtifact == null) {
            return true;
        }
        return StringUtils.isEmpty((String)aDocletArtifact.getGroupId()) && StringUtils.isEmpty((String)aDocletArtifact.getArtifactId()) && StringUtils.isEmpty((String)aDocletArtifact.getVersion());
    }

    private String getTagletPath() throws MavenReportException {
        int i;
        List<String> tagletsPath;
        StringBuffer path = new StringBuffer();
        if (this.tagletArtifact != null && StringUtils.isNotEmpty((String)this.tagletArtifact.getGroupId()) && StringUtils.isNotEmpty((String)this.tagletArtifact.getArtifactId()) && StringUtils.isNotEmpty((String)this.tagletArtifact.getVersion())) {
            path.append(StringUtils.join(this.getArtifactsAbsolutePath(this.tagletArtifact).iterator(), (String)File.pathSeparator));
        }
        if (this.tagletArtifacts != null) {
            tagletsPath = new ArrayList();
            for (i = 0; i < this.tagletArtifacts.length; ++i) {
                TagletArtifact aTagletArtifact = this.tagletArtifacts[i];
                if (!StringUtils.isNotEmpty((String)aTagletArtifact.getGroupId()) || !StringUtils.isNotEmpty((String)aTagletArtifact.getArtifactId()) || !StringUtils.isNotEmpty((String)aTagletArtifact.getVersion())) continue;
                tagletsPath.addAll(this.getArtifactsAbsolutePath(aTagletArtifact));
            }
            tagletsPath = JavadocUtil.pruneFiles(tagletsPath);
            path.append(StringUtils.join(tagletsPath.iterator(), (String)File.pathSeparator));
        }
        if (this.taglets != null) {
            tagletsPath = new ArrayList();
            for (i = 0; i < this.taglets.length; ++i) {
                Taglet current = this.taglets[i];
                if (current == null) continue;
                if (current.getTagletArtifact() != null && StringUtils.isNotEmpty((String)current.getTagletArtifact().getGroupId()) && StringUtils.isNotEmpty((String)current.getTagletArtifact().getArtifactId()) && StringUtils.isNotEmpty((String)current.getTagletArtifact().getVersion())) {
                    tagletsPath.addAll(this.getArtifactsAbsolutePath(current.getTagletArtifact()));
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)current.getTagletpath())) continue;
                tagletsPath.add(current.getTagletpath());
            }
            tagletsPath = JavadocUtil.pruneFiles(tagletsPath);
            path.append(StringUtils.join(tagletsPath.iterator(), (String)File.pathSeparator));
        }
        if (StringUtils.isNotEmpty((String)this.tagletpath)) {
            path.append(this.tagletpath);
        }
        return path.toString();
    }

    private List getArtifactsAbsolutePath(JavadocPathArtifact javadocArtifact) throws MavenReportException {
        if (StringUtils.isEmpty((String)javadocArtifact.getGroupId()) && StringUtils.isEmpty((String)javadocArtifact.getArtifactId()) && StringUtils.isEmpty((String)javadocArtifact.getVersion())) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> path = new ArrayList<String>();
        try {
            Artifact artifact = this.createAndResolveArtifact(javadocArtifact);
            path.add(artifact.getFile().getAbsolutePath());
            MavenProject artifactProject = this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository);
            Set dependencyArtifacts = artifactProject.createArtifacts(this.factory, null, null);
            if (!dependencyArtifacts.isEmpty()) {
                ArtifactResolutionResult result = this.resolver.resolveTransitively(dependencyArtifacts, artifactProject.getArtifact(), artifactProject.getRemoteArtifactRepositories(), this.localRepository, this.artifactMetadataSource);
                Set artifacts = result.getArtifacts();
                HashMap compileArtifactMap = new HashMap();
                this.populateCompileArtifactMap(compileArtifactMap, artifacts);
                Iterator it = compileArtifactMap.keySet().iterator();
                while (it.hasNext()) {
                    String key = it.next().toString();
                    Artifact a = (Artifact)compileArtifactMap.get(key);
                    path.add(a.getFile().getAbsolutePath());
                }
            }
            return path;
        }
        catch (ArtifactResolutionException e) {
            throw new MavenReportException("Unable to resolve artifact:" + javadocArtifact, (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MavenReportException("Unable to find artifact:" + javadocArtifact, (Exception)((Object)e));
        }
        catch (ProjectBuildingException e) {
            throw new MavenReportException("Unable to build the Maven project for the artifact:" + javadocArtifact, (Exception)((Object)e));
        }
        catch (InvalidDependencyVersionException e) {
            throw new MavenReportException("Unable to resolve artifact:" + javadocArtifact, (Exception)((Object)e));
        }
    }

    private Artifact createAndResolveArtifact(JavadocPathArtifact javadocArtifact) throws ArtifactResolutionException, ArtifactNotFoundException, ProjectBuildingException {
        Artifact artifact = this.factory.createProjectArtifact(javadocArtifact.getGroupId(), javadocArtifact.getArtifactId(), javadocArtifact.getVersion(), "compile");
        if (artifact.getFile() == null) {
            MavenProject pluginProject = this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository);
            artifact = pluginProject.getArtifact();
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        }
        return artifact;
    }

    private void addMemoryArg(Commandline cmd, String arg, String memory) {
        block3: {
            if (StringUtils.isNotEmpty((String)memory)) {
                try {
                    cmd.createArg().setValue("-J" + arg + JavadocUtil.parseJavadocMemory(memory));
                }
                catch (IllegalArgumentException e) {
                    if (!this.getLog().isErrorEnabled()) break block3;
                    this.getLog().error((CharSequence)("Malformed memory pattern for '" + arg + memory + "'. Ignore this option."));
                }
            }
        }
    }

    private void addProxyArg(Commandline cmd) {
        if (StringUtils.isNotEmpty((String)this.proxyHost)) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)"The Javadoc plugin parameter 'proxyHost' is deprecated since 2.4. Please configure an active proxy in your settings.xml.");
            }
            cmd.createArg().setValue("-J-DproxyHost=" + this.proxyHost);
            if (this.proxyPort > 0) {
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)"The Javadoc plugin parameter 'proxyPort' is deprecated since 2.4. Please configure an active proxy in your settings.xml.");
                }
                cmd.createArg().setValue("-J-DproxyPort=" + this.proxyPort);
            }
        }
        if (this.settings == null) {
            return;
        }
        Proxy activeProxy = this.settings.getActiveProxy();
        if (activeProxy != null) {
            String protocol;
            String string = protocol = StringUtils.isNotEmpty((String)activeProxy.getProtocol()) ? activeProxy.getProtocol() + "." : "";
            if (StringUtils.isNotEmpty((String)activeProxy.getHost())) {
                cmd.createArg().setValue("-J-D" + protocol + "proxySet=true");
                cmd.createArg().setValue("-J-D" + protocol + "proxyHost=" + activeProxy.getHost());
                if (activeProxy.getPort() > 0) {
                    cmd.createArg().setValue("-J-D" + protocol + "proxyPort=" + activeProxy.getPort());
                }
                if (StringUtils.isNotEmpty((String)activeProxy.getNonProxyHosts())) {
                    cmd.createArg().setValue("-J-D" + protocol + "nonProxyHosts=\"" + activeProxy.getNonProxyHosts() + "\"");
                }
                if (StringUtils.isNotEmpty((String)activeProxy.getUsername())) {
                    cmd.createArg().setValue("-J-Dhttp.proxyUser=\"" + activeProxy.getUsername() + "\"");
                    if (StringUtils.isNotEmpty((String)activeProxy.getPassword())) {
                        cmd.createArg().setValue("-J-Dhttp.proxyPassword=\"" + activeProxy.getPassword() + "\"");
                    }
                }
            }
        }
    }

    private String getJavadocExecutable() throws IOException {
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in javadoc-plugin: " + tc));
            if (this.javadocExecutable != null) {
                this.getLog().warn((CharSequence)("Toolchains are ignored, 'javadocExecutable' parameter is set to " + this.javadocExecutable));
            } else {
                this.javadocExecutable = tc.findTool("javadoc");
            }
        }
        String javadocCommand = "javadoc" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        if (StringUtils.isNotEmpty((String)this.javadocExecutable)) {
            File javadocExe = new File(this.javadocExecutable);
            if (javadocExe.isDirectory()) {
                javadocExe = new File(javadocExe, javadocCommand);
            }
            if (SystemUtils.IS_OS_WINDOWS && javadocExe.getName().indexOf(46) < 0) {
                javadocExe = new File(javadocExe.getPath() + ".exe");
            }
            if (!javadocExe.isFile()) {
                throw new IOException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. Verify the <javadocExecutable/> parameter.");
            }
            return javadocExe.getAbsolutePath();
        }
        File javadocExe = SystemUtils.IS_OS_AIX ? new File(SystemUtils.getJavaHome() + File.separator + ".." + File.separator + "sh", javadocCommand) : (SystemUtils.IS_OS_MAC_OSX ? new File(SystemUtils.getJavaHome() + File.separator + "bin", javadocCommand) : new File(SystemUtils.getJavaHome() + File.separator + ".." + File.separator + "bin", javadocCommand));
        if (!javadocExe.exists() || !javadocExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            String javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).exists() || !new File(javaHome).isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javadocExe = new File(env.getProperty("JAVA_HOME") + File.separator + "bin", javadocCommand);
        }
        if (!javadocExe.exists() || !javadocExe.isFile()) {
            throw new IOException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javadocExe.getAbsolutePath();
    }

    private void setFJavadocVersion(File jExecutable) throws MavenReportException {
        float jVersion;
        try {
            jVersion = JavadocUtil.getJavadocVersion(jExecutable);
        }
        catch (IOException e) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("Unable to find the javadoc version: " + e.getMessage()));
                this.getLog().warn((CharSequence)("Using the Java version instead of, i.e. " + SystemUtils.JAVA_VERSION_FLOAT));
            }
            jVersion = SystemUtils.JAVA_VERSION_FLOAT;
        }
        catch (CommandLineException e) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("Unable to find the javadoc version: " + e.getMessage()));
                this.getLog().warn((CharSequence)("Using the Java the version instead of, i.e. " + SystemUtils.JAVA_VERSION_FLOAT));
            }
            jVersion = SystemUtils.JAVA_VERSION_FLOAT;
        }
        catch (IllegalArgumentException e) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("Unable to find the javadoc version: " + e.getMessage()));
                this.getLog().warn((CharSequence)("Using the Java the version instead of, i.e. " + SystemUtils.JAVA_VERSION_FLOAT));
            }
            jVersion = SystemUtils.JAVA_VERSION_FLOAT;
        }
        if (StringUtils.isNotEmpty((String)this.javadocVersion)) {
            try {
                this.fJavadocVersion = Float.parseFloat(this.javadocVersion);
            }
            catch (NumberFormatException e) {
                throw new MavenReportException("Unable to parse javadoc version: " + e.getMessage(), (Exception)e);
            }
            if (this.fJavadocVersion != jVersion && this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("Are you sure about the <javadocVersion/> parameter? It seems to be " + jVersion));
            }
        } else {
            this.fJavadocVersion = jVersion;
        }
    }

    private boolean isJavaDocVersionAtLeast(float requiredVersion) {
        return this.fJavadocVersion >= requiredVersion;
    }

    private void addArgIf(List arguments, boolean b, String value) {
        if (b) {
            arguments.add(value);
        }
    }

    private void addArgIf(List arguments, boolean b, String value, float requiredJavaVersion) {
        if (b) {
            if (this.isJavaDocVersionAtLeast(requiredJavaVersion)) {
                this.addArgIf(arguments, b, value);
            } else if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)(value + " option is not supported on Java version < " + requiredJavaVersion + ". Ignore this option."));
            }
        }
    }

    private void addArgIfNotEmpty(List arguments, String key, String value) {
        this.addArgIfNotEmpty(arguments, key, value, false);
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, boolean repeatKey, boolean splitValue, float requiredJavaVersion) {
        if (StringUtils.isNotEmpty((String)value)) {
            if (this.isJavaDocVersionAtLeast(requiredJavaVersion)) {
                this.addArgIfNotEmpty(arguments, key, value, repeatKey, splitValue);
            } else if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)(key + " option is not supported on Java version < " + requiredJavaVersion + ". Ignore this option."));
            }
        }
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, boolean repeatKey, boolean splitValue) {
        if (StringUtils.isNotEmpty((String)value)) {
            if (StringUtils.isNotEmpty((String)key)) {
                arguments.add(key);
            }
            if (splitValue) {
                StringTokenizer token = new StringTokenizer(value, ",");
                while (token.hasMoreTokens()) {
                    String current = token.nextToken().trim();
                    if (!StringUtils.isNotEmpty((String)current)) continue;
                    arguments.add(current);
                    if (!token.hasMoreTokens() || !repeatKey) continue;
                    arguments.add(key);
                }
            } else {
                arguments.add(value);
            }
        }
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, boolean repeatKey) {
        this.addArgIfNotEmpty(arguments, key, value, repeatKey, true);
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, float requiredJavaVersion) {
        this.addArgIfNotEmpty(arguments, key, value, requiredJavaVersion, false);
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, float requiredJavaVersion, boolean repeatKey) {
        if (StringUtils.isNotEmpty((String)value)) {
            if (this.isJavaDocVersionAtLeast(requiredJavaVersion)) {
                this.addArgIfNotEmpty(arguments, key, value, repeatKey);
            } else if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)(key + " option is not supported on Java version < " + requiredJavaVersion));
            }
        }
    }

    private void addLinkofflineArguments(List arguments) {
        ArrayList<OfflineLink> offlineLinksList;
        ArrayList<OfflineLink> arrayList = offlineLinksList = this.offlineLinks != null ? new ArrayList<OfflineLink>(Arrays.asList(this.offlineLinks)) : new ArrayList();
        if (!this.isAggregator() && this.reactorProjects != null) {
            MavenProject p;
            String javadocDirRelative = PathUtils.toRelative((File)this.project.getBasedir(), (String)this.getOutputDirectory());
            Iterator it = this.reactorProjects.iterator();
            while (it.hasNext() && !(p = (MavenProject)it.next()).getId().equals(this.project.getId())) {
                if (p.getUrl() == null) continue;
                String url = p.getUrl() + "/apidocs";
                File location = new File(p.getBasedir(), javadocDirRelative);
                if (!location.exists()) continue;
                OfflineLink ol = new OfflineLink();
                ol.setUrl(url);
                ol.setLocation(location.getAbsolutePath());
                offlineLinksList.add(ol);
            }
        }
        if (offlineLinksList != null) {
            for (int i = 0; i < offlineLinksList.size(); ++i) {
                OfflineLink offlineLink = (OfflineLink)offlineLinksList.get(i);
                this.addArgIfNotEmpty(arguments, "-linkoffline", JavadocUtil.quotedPathArgument(offlineLink.getUrl()) + " " + JavadocUtil.quotedPathArgument(offlineLink.getLocation()), true);
            }
        }
    }

    private void addLinkArguments(List arguments) {
        if (this.links != null) {
            for (int i = 0; i < this.links.size(); ++i) {
                String link = (String)this.links.get(i);
                if (StringUtils.isEmpty((String)link)) continue;
                if (link.endsWith("/")) {
                    link = link.substring(0, link.length() - 1);
                }
                try {
                    URI linkUri = link.trim().toLowerCase(Locale.ENGLISH).startsWith("http") || link.trim().toLowerCase(Locale.ENGLISH).startsWith("https") || link.trim().toLowerCase(Locale.ENGLISH).startsWith("ftp") || link.trim().toLowerCase(Locale.ENGLISH).startsWith("file") ? new URI(link + "/package-list") : new File(this.getOutputDirectory(), link + "/package-list").toURI();
                    JavadocUtil.fetchURL(this.settings, linkUri.toURL());
                    this.addArgIfNotEmpty(arguments, "-link", JavadocUtil.quotedPathArgument(link), true);
                    continue;
                }
                catch (URISyntaxException e) {
                    if (!this.getLog().isErrorEnabled()) continue;
                    this.getLog().error((CharSequence)("Malformed link: " + link + "/package-list. Ignored it."));
                    continue;
                }
                catch (IOException e) {
                    if (!this.getLog().isErrorEnabled()) continue;
                    this.getLog().error((CharSequence)("Error fetching link: " + link + "/package-list. Ignored it."));
                }
            }
        }
    }

    private InputStream getStream(String resource) {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource);
    }

    private void copyAllResources(File javadocOutputDirectory) throws MavenReportException {
        try {
            this.copyDefaultStylesheet(javadocOutputDirectory);
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to copy default stylesheet: " + e.getMessage(), (Exception)e);
        }
        if (this.docfilessubdirs) {
            try {
                this.copyJavadocResources(javadocOutputDirectory);
            }
            catch (IOException e) {
                throw new MavenReportException("Unable to copy javadoc resources: " + e.getMessage(), (Exception)e);
            }
        }
        this.copyAdditionalJavadocResources(javadocOutputDirectory);
    }

    private void copyDefaultStylesheet(File anOutputDirectory) throws IOException {
        if (anOutputDirectory == null || !anOutputDirectory.exists()) {
            throw new IOException("The outputDirectory " + anOutputDirectory + " doesn't exists.");
        }
        InputStream is = this.getStream(RESOURCE_CSS_DIR + "/" + DEFAULT_CSS_NAME);
        if (is == null) {
            throw new IOException("The resource stylesheet.css doesn't exists.");
        }
        File outputFile = new File(anOutputDirectory, DEFAULT_CSS_NAME);
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        FileOutputStream w = new FileOutputStream(outputFile);
        IOUtil.copy((InputStream)is, (OutputStream)w);
        IOUtil.close((InputStream)is);
        IOUtil.close((OutputStream)w);
    }

    private void copyJavadocResources(File anOutputDirectory) throws IOException {
        if (anOutputDirectory == null || !anOutputDirectory.exists()) {
            throw new IOException("The outputDirectory " + anOutputDirectory + " doesn't exists.");
        }
        if (this.getJavadocDirectory() != null) {
            JavadocUtil.copyJavadocResources(anOutputDirectory, this.getJavadocDirectory(), this.excludedocfilessubdir);
        }
        if (this.isAggregator() && this.project.isExecutionRoot()) {
            Iterator i = this.reactorProjects.iterator();
            while (i.hasNext()) {
                MavenProject subProject = (MavenProject)i.next();
                if (subProject == this.project) continue;
                String javadocDirRelative = PathUtils.toRelative((File)this.project.getBasedir(), (String)this.getJavadocDirectory().getAbsolutePath());
                File javadocDir = new File(subProject.getBasedir(), javadocDirRelative);
                JavadocUtil.copyJavadocResources(anOutputDirectory, javadocDir, this.excludedocfilessubdir);
            }
        }
    }

    private void copyAdditionalJavadocResources(File anOutputDirectory) throws MavenReportException {
        if (this.resourcesArtifacts != null && this.resourcesArtifacts.length > 0) {
            UnArchiver unArchiver;
            try {
                unArchiver = this.archiverManager.getUnArchiver("jar");
            }
            catch (NoSuchArchiverException e) {
                throw new MavenReportException("Unable to extract resources artifact. No archiver for 'jar' available.", (Exception)((Object)e));
            }
            for (int i = 0; i < this.resourcesArtifacts.length; ++i) {
                Artifact artifact;
                ResourcesArtifact item = this.resourcesArtifacts[i];
                try {
                    artifact = this.createAndResolveArtifact(item);
                }
                catch (ArtifactResolutionException e) {
                    throw new MavenReportException("Unable to resolve artifact:" + item, (Exception)((Object)e));
                }
                catch (ArtifactNotFoundException e) {
                    throw new MavenReportException("Unable to find artifact:" + item, (Exception)((Object)e));
                }
                catch (ProjectBuildingException e) {
                    throw new MavenReportException("Unable to build the Maven project for the artifact:" + item, (Exception)((Object)e));
                }
                unArchiver.setSourceFile(artifact.getFile());
                unArchiver.setDestDirectory(anOutputDirectory);
                this.getLog().info((CharSequence)("Extracting contents of resources artifact: " + artifact.getArtifactId()));
                try {
                    unArchiver.extract();
                    continue;
                }
                catch (ArchiverException e) {
                    throw new MavenReportException("Extraction of resources failed. Artifact that failed was: " + artifact.getArtifactId(), (Exception)((Object)e));
                }
            }
        }
    }

    private List getPackageNames(List sourcePaths, List files) {
        return this.getPackageNamesOrFilesWithUnnamedPackages(sourcePaths, files, true);
    }

    private List getFilesWithUnnamedPackages(List sourcePaths, List files) {
        return this.getPackageNamesOrFilesWithUnnamedPackages(sourcePaths, files, false);
    }

    private List getPackageNamesOrFilesWithUnnamedPackages(List sourcePaths, List files, boolean onlyPackageName) {
        ArrayList<String> returnList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.sourcepath)) {
            return returnList;
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            String currentFile = (String)it.next();
            currentFile = currentFile.replace('\\', '/');
            Iterator it2 = sourcePaths.iterator();
            while (it2.hasNext()) {
                String currentSourcePath = (String)it2.next();
                if (!(currentSourcePath = currentSourcePath.replace('\\', '/')).endsWith("/")) {
                    currentSourcePath = currentSourcePath + "/";
                }
                if (currentFile.indexOf(currentSourcePath) == -1) continue;
                String packagename = currentFile.substring(currentSourcePath.length() + 1);
                if (onlyPackageName && packagename.lastIndexOf("/") != -1) {
                    packagename = packagename.substring(0, packagename.lastIndexOf("/"));
                    if (!returnList.contains(packagename = packagename.replace('/', '.'))) {
                        returnList.add(packagename);
                    }
                }
                if (onlyPackageName || packagename.lastIndexOf("/") != -1) continue;
                returnList.add(currentFile);
            }
        }
        return returnList;
    }

    private void addCommandLineOptions(Commandline cmd, List arguments, File javadocOutputDirectory) throws MavenReportException {
        File optionsFile = new File(javadocOutputDirectory, OPTIONS_FILE_NAME);
        StringBuffer options = new StringBuffer();
        options.append(StringUtils.join((Object[])arguments.toArray(new String[0]), (String)SystemUtils.LINE_SEPARATOR));
        try {
            FileUtils.fileWrite((String)optionsFile.getAbsolutePath(), (String)options.toString());
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to write '" + optionsFile.getName() + "' temporary file for command execution", (Exception)e);
        }
        cmd.createArg().setValue("@options");
        if (!this.debug) {
            optionsFile.deleteOnExit();
        }
    }

    private void addCommandLineArgFile(Commandline cmd, File javadocOutputDirectory, List files) throws MavenReportException {
        File argfileFile = this.isJavaDocVersionAtLeast(1.4f) ? new File(javadocOutputDirectory, ARGFILE_FILE_NAME) : new File(javadocOutputDirectory, FILES_FILE_NAME);
        try {
            FileUtils.fileWrite((String)argfileFile.getAbsolutePath(), (String)StringUtils.join(files.iterator(), (String)SystemUtils.LINE_SEPARATOR));
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to write '" + argfileFile.getName() + "' temporary file for command execution", (Exception)e);
        }
        if (this.isJavaDocVersionAtLeast(1.4f)) {
            cmd.createArg().setValue("@argfile");
        } else {
            cmd.createArg().setValue("@files");
        }
        if (!this.debug) {
            argfileFile.deleteOnExit();
        }
    }

    private void addCommandLinePackages(Commandline cmd, File javadocOutputDirectory, List packageNames) throws MavenReportException {
        File packagesFile = new File(javadocOutputDirectory, PACKAGES_FILE_NAME);
        try {
            FileUtils.fileWrite((String)packagesFile.getAbsolutePath(), (String)StringUtils.join((Object[])packageNames.toArray(new String[0]), (String)SystemUtils.LINE_SEPARATOR));
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to write '" + packagesFile.getName() + "' temporary file for command execution", (Exception)e);
        }
        cmd.createArg().setValue("@packages");
        if (!this.debug) {
            packagesFile.deleteOnExit();
        }
    }

    private void validateJavadocOptions() throws MavenReportException {
        if (StringUtils.isNotEmpty((String)this.getEncoding()) && !JavadocUtil.validateEncoding(this.getEncoding())) {
            throw new MavenReportException("Encoding not supported: " + this.getEncoding());
        }
    }

    private void validateStandardDocletOptions() throws MavenReportException {
        if (StringUtils.isNotEmpty((String)this.getDocencoding()) && !JavadocUtil.validateEncoding(this.getDocencoding())) {
            throw new MavenReportException("Encoding not supported: " + this.getDocencoding());
        }
        if (StringUtils.isNotEmpty((String)this.helpfile) && this.nohelp) {
            throw new MavenReportException("Option <nohelp/> conflicts with <helpfile/>");
        }
        if (StringUtils.isNotEmpty((String)this.helpfile) && !new File(this.helpfile).exists()) {
            throw new MavenReportException("File not found: " + this.helpfile);
        }
        if (this.getOverview() != null && this.nooverview) {
            throw new MavenReportException("Option <nooverview/> conflicts with <overview/>");
        }
        if (this.splitindex && this.noindex) {
            throw new MavenReportException("Option <noindex/> conflicts with <splitindex/>");
        }
    }

    private boolean checkMissingArtifactsInReactor(Collection dependencyArtifacts, Collection missing) {
        HashSet<MavenProject> foundInReactor = new HashSet<MavenProject>();
        Iterator iter = missing.iterator();
        block0: while (iter.hasNext()) {
            Artifact mArtifact = (Artifact)iter.next();
            Iterator pIter = this.reactorProjects.iterator();
            while (pIter.hasNext()) {
                MavenProject p = (MavenProject)pIter.next();
                if (!p.getArtifactId().equals(mArtifact.getArtifactId()) || !p.getGroupId().equals(mArtifact.getGroupId()) || !p.getVersion().equals(mArtifact.getVersion())) continue;
                this.getLog().warn((CharSequence)("The dependency: [" + p.getId() + "] can't be resolved but has been found in the reactor (probably snapshots).\n" + "This dependency has been excluded from the Javadoc classpath. " + "You should rerun javadoc after executing mvn install."));
                foundInReactor.add(p);
                continue block0;
            }
        }
        return foundInReactor.size() == missing.size();
    }

    private void addJavadocOptions(List arguments, List sourcePaths) throws MavenReportException {
        this.validateJavadocOptions();
        this.addArgIfNotEmpty(arguments, "-locale", JavadocUtil.quotedArgument(this.locale));
        if (this.old && this.isJavaDocVersionAtLeast(1.4f)) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)"Javadoc 1.4+ doesn't support the -1.1 switch anymore. Ignore this option.");
            }
        } else {
            this.addArgIf(arguments, this.old, "-1.1");
        }
        this.addArgIfNotEmpty(arguments, "-bootclasspath", JavadocUtil.quotedPathArgument(this.getBootclassPath()));
        if (this.isJavaDocVersionAtLeast(1.5f)) {
            this.addArgIf(arguments, this.breakiterator, "-breakiterator", 1.5f);
        }
        this.addArgIfNotEmpty(arguments, "-classpath", JavadocUtil.quotedPathArgument(this.getClasspath()));
        if (StringUtils.isNotEmpty((String)this.doclet)) {
            this.addArgIfNotEmpty(arguments, "-doclet", JavadocUtil.quotedArgument(this.doclet));
            this.addArgIfNotEmpty(arguments, "-docletpath", JavadocUtil.quotedPathArgument(this.getDocletPath()));
        }
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.getLog().warn((CharSequence)("Source files encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
        }
        this.addArgIfNotEmpty(arguments, "-encoding", JavadocUtil.quotedArgument(this.getEncoding()));
        this.addArgIfNotEmpty(arguments, "-exclude", this.getExcludedPackages(sourcePaths), 1.4f);
        this.addArgIfNotEmpty(arguments, "-extdirs", JavadocUtil.quotedPathArgument(this.extdirs));
        if (this.getOverview() != null && this.getOverview().exists()) {
            this.addArgIfNotEmpty(arguments, "-overview", JavadocUtil.quotedPathArgument(this.getOverview().getAbsolutePath()));
        }
        arguments.add(this.getAccessLevel());
        if (this.isJavaDocVersionAtLeast(1.5f)) {
            this.addArgIf(arguments, this.quiet, "-quiet", 1.5f);
        }
        this.addArgIfNotEmpty(arguments, "-source", JavadocUtil.quotedArgument(this.source), 1.4f);
        if (StringUtils.isEmpty((String)this.sourcepath) && StringUtils.isNotEmpty((String)this.subpackages)) {
            this.sourcepath = StringUtils.join(sourcePaths.iterator(), (String)File.pathSeparator);
        }
        this.addArgIfNotEmpty(arguments, "-sourcepath", JavadocUtil.quotedPathArgument(this.getSourcePath(sourcePaths)));
        if (StringUtils.isNotEmpty((String)this.sourcepath) && this.isJavaDocVersionAtLeast(1.5f)) {
            this.addArgIfNotEmpty(arguments, "-subpackages", this.subpackages, 1.5f);
        }
        this.addArgIf(arguments, this.verbose, "-verbose");
        this.addArgIfNotEmpty(arguments, null, this.additionalparam);
    }

    private void addStandardDocletOptions(File javadocOutputDirectory, List arguments) throws MavenReportException {
        this.validateStandardDocletOptions();
        this.addArgIf(arguments, this.author, "-author");
        this.addArgIfNotEmpty(arguments, "-bottom", JavadocUtil.quotedArgument(this.getBottomText()), false, false);
        if (!this.isJavaDocVersionAtLeast(1.5f)) {
            this.addArgIf(arguments, this.breakiterator, "-breakiterator", 1.4f);
        }
        this.addArgIfNotEmpty(arguments, "-charset", JavadocUtil.quotedArgument(this.getCharset()));
        this.addArgIfNotEmpty(arguments, "-d", JavadocUtil.quotedPathArgument(javadocOutputDirectory.toString()));
        this.addArgIfNotEmpty(arguments, "-docencoding", JavadocUtil.quotedArgument(this.getDocencoding()));
        this.addArgIf(arguments, this.docfilessubdirs, "-docfilessubdirs", 1.4f);
        this.addArgIfNotEmpty(arguments, "-doctitle", JavadocUtil.quotedArgument(this.getDoctitle()), false, false);
        if (this.docfilessubdirs) {
            this.addArgIfNotEmpty(arguments, "-excludedocfilessubdir", JavadocUtil.quotedPathArgument(this.excludedocfilessubdir), 1.4f);
        }
        this.addArgIfNotEmpty(arguments, "-footer", JavadocUtil.quotedArgument(this.footer), false, false);
        this.addGroups(arguments);
        this.addArgIfNotEmpty(arguments, "-header", JavadocUtil.quotedArgument(this.header), false, false);
        this.addArgIfNotEmpty(arguments, "-helpfile", JavadocUtil.quotedPathArgument(this.helpfile));
        this.addArgIf(arguments, this.keywords, "-keywords", 1.42f);
        if (!this.isOffline) {
            this.addLinkArguments(arguments);
        }
        this.addLinkofflineArguments(arguments);
        this.addArgIf(arguments, this.linksource, "-linksource", 1.4f);
        if (this.sourcetab > 0) {
            if (this.fJavadocVersion == 1.42f) {
                this.addArgIfNotEmpty(arguments, "-linksourcetab", String.valueOf(this.sourcetab));
            }
            this.addArgIfNotEmpty(arguments, "-sourcetab", String.valueOf(this.sourcetab), 1.5f);
        }
        this.addArgIf(arguments, this.nocomment, "-nocomment", 1.4f);
        this.addArgIf(arguments, this.nodeprecated, "-nodeprecated");
        this.addArgIf(arguments, this.nodeprecatedlist, "-nodeprecatedlist");
        this.addArgIf(arguments, this.nohelp, "-nohelp");
        this.addArgIf(arguments, this.noindex, "-noindex");
        this.addArgIf(arguments, this.nonavbar, "-nonavbar");
        this.addArgIf(arguments, this.nooverview, "-nooverview");
        this.addArgIfNotEmpty(arguments, "-noqualifier", JavadocUtil.quotedArgument(this.noqualifier), 1.4f);
        this.addArgIf(arguments, this.nosince, "-nosince");
        this.addArgIf(arguments, this.notimestamp, "-notimestamp", 1.5f);
        this.addArgIf(arguments, this.notree, "-notree");
        this.addArgIfNotEmpty(arguments, "-packagesheader", JavadocUtil.quotedArgument(this.packagesheader), 1.42f);
        if (!this.isJavaDocVersionAtLeast(1.5f)) {
            this.addArgIf(arguments, this.quiet, "-quiet", 1.4f);
        }
        this.addArgIf(arguments, this.serialwarn, "-serialwarn");
        this.addArgIf(arguments, this.splitindex, "-splitindex");
        this.addArgIfNotEmpty(arguments, "-stylesheetfile", JavadocUtil.quotedPathArgument(this.getStylesheetFile(javadocOutputDirectory)));
        if (StringUtils.isNotEmpty((String)this.sourcepath) && !this.isJavaDocVersionAtLeast(1.5f)) {
            this.addArgIfNotEmpty(arguments, "-subpackages", this.subpackages, 1.4f);
        }
        this.addArgIfNotEmpty(arguments, "-taglet", JavadocUtil.quotedArgument(this.taglet), 1.4f);
        this.addTaglets(arguments);
        this.addTagletsFromTagletArtifacts(arguments);
        this.addArgIfNotEmpty(arguments, "-tagletpath", JavadocUtil.quotedPathArgument(this.getTagletPath()), 1.4f);
        this.addTags(arguments);
        this.addArgIfNotEmpty(arguments, "-top", JavadocUtil.quotedArgument(this.top), false, false, 1.6f);
        this.addArgIf(arguments, this.use, "-use");
        this.addArgIf(arguments, this.version, "-version");
        this.addArgIfNotEmpty(arguments, "-windowtitle", JavadocUtil.quotedArgument(this.getWindowtitle()), false, false);
    }

    private void addGroups(List arguments) {
        if (this.groups == null) {
            return;
        }
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] == null || StringUtils.isEmpty((String)this.groups[i].getTitle()) || StringUtils.isEmpty((String)this.groups[i].getPackages())) {
                if (!this.getLog().isWarnEnabled()) continue;
                this.getLog().warn((CharSequence)"A group option is empty. Ignore this option.");
                continue;
            }
            String groupTitle = StringUtils.replace((String)this.groups[i].getTitle(), (String)",", (String)"&#44;");
            this.addArgIfNotEmpty(arguments, "-group", JavadocUtil.quotedArgument(groupTitle) + " " + JavadocUtil.quotedArgument(this.groups[i].getPackages()), true);
        }
    }

    private void addTags(List arguments) {
        if (this.tags == null) {
            return;
        }
        for (int i = 0; i < this.tags.length; ++i) {
            if (StringUtils.isEmpty((String)this.tags[i].getName())) {
                if (!this.getLog().isWarnEnabled()) continue;
                this.getLog().warn((CharSequence)"A tag name is empty. Ignore this option.");
                continue;
            }
            String value = "\"" + this.tags[i].getName();
            if (StringUtils.isNotEmpty((String)this.tags[i].getPlacement())) {
                value = value + ":" + this.tags[i].getPlacement();
                if (StringUtils.isNotEmpty((String)this.tags[i].getHead())) {
                    value = value + ":" + this.tags[i].getHead();
                }
            }
            value = value + "\"";
            this.addArgIfNotEmpty(arguments, "-tag", value, 1.4f);
        }
    }

    private void addTaglets(List arguments) {
        if (this.taglets == null) {
            return;
        }
        for (int i = 0; i < this.taglets.length; ++i) {
            if (this.taglets[i] == null || StringUtils.isEmpty((String)this.taglets[i].getTagletClass())) {
                if (!this.getLog().isWarnEnabled()) continue;
                this.getLog().warn((CharSequence)"A taglet option is empty. Ignore this option.");
                continue;
            }
            this.addArgIfNotEmpty(arguments, "-taglet", JavadocUtil.quotedArgument(this.taglets[i].getTagletClass()), 1.4f);
        }
    }

    private void addTagletsFromTagletArtifacts(List arguments) throws MavenReportException {
        if (this.tagletArtifacts == null) {
            return;
        }
        List<String> tagletsPath = new ArrayList();
        for (int i = 0; i < this.tagletArtifacts.length; ++i) {
            Artifact artifact;
            TagletArtifact aTagletArtifact = this.tagletArtifacts[i];
            if (!StringUtils.isNotEmpty((String)aTagletArtifact.getGroupId()) || !StringUtils.isNotEmpty((String)aTagletArtifact.getArtifactId()) || !StringUtils.isNotEmpty((String)aTagletArtifact.getVersion())) continue;
            try {
                artifact = this.createAndResolveArtifact(aTagletArtifact);
            }
            catch (ArtifactResolutionException e) {
                throw new MavenReportException("Unable to resolve artifact:" + aTagletArtifact, (Exception)((Object)e));
            }
            catch (ArtifactNotFoundException e) {
                throw new MavenReportException("Unable to find artifact:" + aTagletArtifact, (Exception)((Object)e));
            }
            catch (ProjectBuildingException e) {
                throw new MavenReportException("Unable to build the Maven project for the artifact:" + aTagletArtifact, (Exception)((Object)e));
            }
            tagletsPath.add(artifact.getFile().getAbsolutePath());
        }
        tagletsPath = JavadocUtil.pruneFiles(tagletsPath);
        Iterator it = tagletsPath.iterator();
        while (it.hasNext()) {
            List tagletClasses;
            String tagletJar = (String)it.next();
            if (!tagletJar.toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
            try {
                tagletClasses = JavadocUtil.getTagletClassNames(new File(tagletJar));
            }
            catch (IOException e) {
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)("Unable to auto-detect Taglet class names from '" + tagletJar + "'. Try to specify them with <taglets/>."));
                }
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("IOException: " + e.getMessage()), (Throwable)e);
                continue;
            }
            catch (ClassNotFoundException e) {
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)("Unable to auto-detect Taglet class names from '" + tagletJar + "'. Try to specify them with <taglets/>."));
                }
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("ClassNotFoundException: " + e.getMessage()), (Throwable)e);
                continue;
            }
            catch (NoClassDefFoundError e) {
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)("Unable to auto-detect Taglet class names from '" + tagletJar + "'. Try to specify them with <taglets/>."));
                }
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("NoClassDefFoundError: " + e.getMessage()), (Throwable)e);
                continue;
            }
            if (tagletClasses == null || tagletClasses.isEmpty()) continue;
            Iterator it2 = tagletClasses.iterator();
            while (it2.hasNext()) {
                String tagletClass = (String)it2.next();
                this.addArgIfNotEmpty(arguments, "-taglet", JavadocUtil.quotedArgument(tagletClass), 1.4f);
            }
        }
    }

    private void executeJavadocCommandLine(Commandline cmd, File javadocOutputDirectory) throws MavenReportException {
        block10: {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)CommandLineUtils.toString((String[])cmd.getCommandline()).replaceAll("'", ""));
            }
            if (this.debug) {
                File commandLineFile = new File(javadocOutputDirectory, DEBUG_JAVADOC_SCRIPT_NAME);
                try {
                    FileUtils.fileWrite((String)commandLineFile.getAbsolutePath(), (String)CommandLineUtils.toString((String[])cmd.getCommandline()).replaceAll("'", ""));
                    if (!SystemUtils.IS_OS_WINDOWS) {
                        Runtime.getRuntime().exec(new String[]{"chmod", "a+x", commandLineFile.getAbsolutePath()});
                    }
                }
                catch (IOException e) {
                    if (!this.getLog().isWarnEnabled()) break block10;
                    this.getLog().warn((CharSequence)("Unable to write '" + commandLineFile.getName() + "' debug script file"), (Throwable)e);
                }
            }
        }
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        try {
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)new DefaultConsumer(), (StreamConsumer)err);
            if (exitCode != 0) {
                String cmdLine = CommandLineUtils.toString((String[])cmd.getCommandline()).replaceAll("'", "");
                cmdLine = JavadocUtil.hideProxyPassword(cmdLine, this.settings);
                StringBuffer msg = new StringBuffer("Exit code: " + exitCode + " - " + err.getOutput());
                msg.append('\n');
                msg.append("Command line was:" + cmdLine);
                throw new MavenReportException(msg.toString());
            }
        }
        catch (CommandLineException e) {
            throw new MavenReportException("Unable to execute javadoc command: " + e.getMessage(), (Exception)((Object)e));
        }
        if (StringUtils.isNotEmpty((String)err.getOutput()) && this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)"Javadoc Warnings");
            StringTokenizer token = new StringTokenizer(err.getOutput(), "\n");
            while (token.hasMoreTokens()) {
                String current = token.nextToken().trim();
                this.getLog().warn((CharSequence)current);
            }
        }
    }
}

