/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLException;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAudienceRestrictionCondition
extends SAMLCondition
implements Cloneable {
    protected ArrayList audiences = new ArrayList();

    public SAMLAudienceRestrictionCondition() {
    }

    public SAMLAudienceRestrictionCondition(Collection collection) throws SAMLException {
        if (collection != null) {
            this.audiences.addAll(collection);
        }
    }

    public SAMLAudienceRestrictionCondition(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAudienceRestrictionCondition(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAudienceRestrictionCondition.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        Object object;
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "AudienceRestrictionCondition")) {
            object = QName.getQNameAttribute(element, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Condition") && object != null && "urn:oasis:names:tc:SAML:1.0:assertion".equals(((QName)object).getNamespaceURI()) && "AudienceRestrictionConditionType".equals(((QName)object).getLocalName()))) {
                throw new MalformedException(SAMLException.RESPONDER, "SAMLAudienceRestrictionCondition() requires saml:AudienceRestrictionCondition at root");
            }
        }
        object = XML.getFirstChildElement(element);
        while (object != null) {
            String string = object.getFirstChild().getNodeValue();
            if (!XML.isEmpty(string)) {
                this.audiences.add(string);
            }
            object = XML.getNextSiblingElement((Node)object);
        }
        this.checkValidity();
    }

    public Iterator getAudiences() {
        return this.audiences.iterator();
    }

    public void setAudiences(Collection collection) {
        while (this.audiences.size() > 0) {
            this.removeAudience(0);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addAudience((String)iterator.next());
            }
        }
    }

    public void addAudience(String string) {
        if (!XML.isEmpty(string)) {
            if (this.root != null) {
                Element element = this.root.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Audience");
                element.appendChild(this.root.getOwnerDocument().createTextNode(string));
                Element element2 = XML.getLastChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Audience");
                if (element2 == null) {
                    this.root.insertBefore(element, this.root.getFirstChild());
                } else {
                    this.root.insertBefore(element, element2.getNextSibling());
                }
            }
        } else {
            throw new IllegalArgumentException("audience cannot be null or empty");
        }
        this.audiences.add(string);
    }

    public void removeAudience(int n) {
        this.audiences.remove(n);
        if (this.root != null) {
            Element element = XML.getFirstChildElement(this.root);
            while (element != null && n > 0) {
                element = XML.getNextSiblingElement(element);
                --n;
            }
            if (element != null) {
                this.root.removeChild(element);
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        this.root = super.toDOM(document, bl);
        if (this.root != null) {
            if (bl) {
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
            }
            return this.root;
        }
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AudienceRestrictionCondition");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        Iterator iterator = this.audiences.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (XML.isEmpty(string)) continue;
            element.appendChild(document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Audience")).appendChild(document.createTextNode(string));
        }
        this.root = element;
        return this.root;
    }

    public boolean eval(Collection collection) {
        if (collection == null || collection.size() == 0) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.audiences.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public void checkValidity() throws SAMLException {
        if (this.audiences == null || this.audiences.size() == 0) {
            throw new MalformedException(SAMLException.RESPONDER, "AudienceRestrictionCondition is invalid, requires at least one audience");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAudienceRestrictionCondition sAMLAudienceRestrictionCondition = (SAMLAudienceRestrictionCondition)super.clone();
        sAMLAudienceRestrictionCondition.audiences = (ArrayList)this.audiences.clone();
        return sAMLAudienceRestrictionCondition;
    }
}

