/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenProjectValueSource;
import org.apache.maven.shared.filtering.PropertiesEscapingBackSlashValueSource;
import org.apache.maven.shared.filtering.PropertyUtils;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.InterpolatorFilterReader;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class DefaultMavenFileFilter
implements MavenFileFilter {
    public void copyFile(File from, File to, boolean filtering, MavenProject mavenProject, List filters, boolean escapedBackslashesInFilePath, String encoding, MavenSession mavenSession) throws MavenFilteringException {
        List filterWrappers = this.getDefaultFilterWrappers(mavenProject, filters, escapedBackslashesInFilePath, mavenSession);
        this.copyFile(from, to, filtering, filterWrappers, encoding);
    }

    public void copyFile(File from, File to, boolean filtering, List filterWrappers, String encoding) throws MavenFilteringException {
        try {
            if (filtering) {
                FileUtils.FilterWrapper[] wrappers = filterWrappers.toArray(new FileUtils.FilterWrapper[filterWrappers.size()]);
                FileUtils.copyFile((File)from, (File)to, (String)encoding, (FileUtils.FilterWrapper[])wrappers);
            } else {
                FileUtils.copyFile((File)from, (File)to, (String)encoding, (FileUtils.FilterWrapper[])new FileUtils.FilterWrapper[0]);
            }
        }
        catch (IOException e) {
            throw new MavenFilteringException(e.getMessage(), e);
        }
    }

    public List getDefaultFilterWrappers(final MavenProject mavenProject, List filters, final boolean escapedBackslashesInFilePath, MavenSession mavenSession) throws MavenFilteringException {
        Properties baseProps = new Properties();
        baseProps.putAll((Map<?, ?>)(mavenProject.getProperties() == null ? Collections.EMPTY_MAP : mavenProject.getProperties()));
        if (mavenSession != null) {
            baseProps.putAll((Map<?, ?>)mavenSession.getExecutionProperties());
        }
        Properties filterProperties = new Properties();
        this.loadProperties(filterProperties, filters, baseProps);
        this.loadProperties(filterProperties, mavenProject.getBuild().getFilters(), baseProps);
        filterProperties.putAll((Map<?, ?>)(mavenProject.getProperties() == null ? Collections.EMPTY_MAP : mavenProject.getProperties()));
        if (mavenSession != null) {
            filterProperties.putAll((Map<?, ?>)mavenSession.getExecutionProperties());
        }
        ArrayList<FileUtils.FilterWrapper> defaultFilterWrappers = new ArrayList<FileUtils.FilterWrapper>(3);
        final PropertiesEscapingBackSlashValueSource propertiesValueSource = new PropertiesEscapingBackSlashValueSource(escapedBackslashesInFilePath, filterProperties);
        FileUtils.FilterWrapper one = new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                RegexBasedInterpolator propertiesInterpolator = new RegexBasedInterpolator();
                propertiesInterpolator.addValueSource(propertiesValueSource);
                return new InterpolatorFilterReader(reader, (Interpolator)propertiesInterpolator);
            }
        };
        defaultFilterWrappers.add(one);
        FileUtils.FilterWrapper second = new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                RegexBasedInterpolator propertiesInterpolatorAtRegex = new RegexBasedInterpolator("\\@", "(.+?)\\@");
                propertiesInterpolatorAtRegex.addValueSource(propertiesValueSource);
                return new InterpolatorFilterReader(reader, (Interpolator)propertiesInterpolatorAtRegex, "@", "@");
            }
        };
        defaultFilterWrappers.add(second);
        FileUtils.FilterWrapper third = new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                RegexBasedInterpolator mavenProjectInterpolator = new RegexBasedInterpolator();
                MavenProjectValueSource valueSource = new MavenProjectValueSource(mavenProject, escapedBackslashesInFilePath);
                mavenProjectInterpolator.addValueSource((ValueSource)valueSource);
                return new InterpolatorFilterReader(reader, (Interpolator)mavenProjectInterpolator);
            }
        };
        defaultFilterWrappers.add(third);
        FileUtils.FilterWrapper fourth = new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                RegexBasedInterpolator mavenProjectInterpolator = new RegexBasedInterpolator("\\@", "(.+?)\\@");
                MavenProjectValueSource valueSource = new MavenProjectValueSource(mavenProject, escapedBackslashesInFilePath);
                mavenProjectInterpolator.addValueSource((ValueSource)valueSource);
                return new InterpolatorFilterReader(reader, (Interpolator)mavenProjectInterpolator, "@", "@");
            }
        };
        defaultFilterWrappers.add(fourth);
        return defaultFilterWrappers;
    }

    private void loadProperties(Properties filterProperties, List propertiesFilePaths, Properties baseProps) throws MavenFilteringException {
        if (propertiesFilePaths != null) {
            Iterator iterator = propertiesFilePaths.iterator();
            while (iterator.hasNext()) {
                String filterFile = (String)iterator.next();
                if (StringUtils.isEmpty((String)filterFile)) continue;
                try {
                    Properties properties = PropertyUtils.loadPropertyFile(new File(filterFile), baseProps);
                    filterProperties.putAll((Map<?, ?>)properties);
                }
                catch (IOException e) {
                    throw new MavenFilteringException("Error loading property file '" + filterFile + "'", e);
                }
            }
        }
    }
}

