/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

public class DefaultMavenResourcesFiltering
extends AbstractLogEnabled
implements MavenResourcesFiltering,
Initializable {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private List defaultNonFilteredFileExtensions;
    private MavenFileFilter mavenFileFilter;

    public void initialize() throws InitializationException {
        this.defaultNonFilteredFileExtensions = new ArrayList(5);
        this.defaultNonFilteredFileExtensions.add("jpg");
        this.defaultNonFilteredFileExtensions.add("jpeg");
        this.defaultNonFilteredFileExtensions.add("gif");
        this.defaultNonFilteredFileExtensions.add("bmp");
        this.defaultNonFilteredFileExtensions.add("png");
    }

    public void filterResources(List resources, File outputDirectory, MavenProject mavenProject, String encoding, List fileFilters, List nonFilteredFileExtensions, MavenSession mavenSession) throws MavenFilteringException {
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, outputDirectory, mavenProject, encoding, fileFilters, nonFilteredFileExtensions, mavenSession);
        mavenResourcesExecution.setUseDefaultFilterWrappers(true);
        this.filterResources(mavenResourcesExecution);
    }

    public void filterResources(List resources, File outputDirectory, String encoding, List filterWrappers, File resourcesBaseDirectory, List nonFilteredFileExtensions) throws MavenFilteringException {
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, outputDirectory, encoding, filterWrappers, resourcesBaseDirectory, nonFilteredFileExtensions);
        this.filterResources(mavenResourcesExecution);
    }

    public boolean filteredFileExtension(String fileName, List userNonFilteredFileExtensions) {
        ArrayList nonFilteredFileExtensions = new ArrayList(this.getDefaultNonFilteredFileExtensions());
        if (userNonFilteredFileExtensions != null) {
            nonFilteredFileExtensions.addAll(userNonFilteredFileExtensions);
        }
        return !nonFilteredFileExtensions.contains(StringUtils.lowerCase((String)FileUtils.extension((String)fileName)));
    }

    public List getDefaultNonFilteredFileExtensions() {
        return this.defaultNonFilteredFileExtensions;
    }

    public void filterResources(MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        if (mavenResourcesExecution == null) {
            throw new MavenFilteringException("mavenResourcesExecution cannot be null");
        }
        if (mavenResourcesExecution.getResources() == null) {
            this.getLogger().info("No resources configured skip copying/filtering");
            return;
        }
        if (mavenResourcesExecution.getOutputDirectory() == null) {
            throw new MavenFilteringException("outputDirectory cannot be null");
        }
        if (mavenResourcesExecution.isUseDefaultFilterWrappers()) {
            ArrayList filterWrappers = new ArrayList();
            if (mavenResourcesExecution.getFilterWrappers() != null) {
                filterWrappers.addAll(mavenResourcesExecution.getFilterWrappers());
            }
            filterWrappers.addAll(this.mavenFileFilter.getDefaultFilterWrappers(mavenResourcesExecution.getMavenProject(), mavenResourcesExecution.getFileFilters(), true, mavenResourcesExecution.getMavenSession()));
            mavenResourcesExecution.setFilterWrappers(filterWrappers);
        }
        if (mavenResourcesExecution.getEncoding() == null || mavenResourcesExecution.getEncoding().length() < 1) {
            this.getLogger().info("Using platform encoding (" + ReaderFactory.FILE_ENCODING + " actually) to copy filtered resources.");
        } else {
            this.getLogger().info("Using '" + mavenResourcesExecution.getEncoding() + "' encoding to copy filtered resources.");
        }
        Iterator i = mavenResourcesExecution.getResources().iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            String targetPath = resource.getTargetPath();
            File resourceDirectory = new File(resource.getDirectory());
            if (!resourceDirectory.isAbsolute()) {
                resourceDirectory = new File(mavenResourcesExecution.getResourcesBaseDirectory(), resourceDirectory.getPath());
            }
            if (!resourceDirectory.exists()) continue;
            File outputDirectory = mavenResourcesExecution.getOutputDirectory();
            if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
                throw new MavenFilteringException("Cannot create resource output directory: " + outputDirectory);
            }
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(resourceDirectory);
            if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
                scanner.setIncludes(resource.getIncludes().toArray(EMPTY_STRING_ARRAY));
            } else {
                scanner.setIncludes(DEFAULT_INCLUDES);
            }
            if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
                scanner.setExcludes(resource.getExcludes().toArray(EMPTY_STRING_ARRAY));
            }
            scanner.addDefaultExcludes();
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            this.getLogger().info("Copying " + includedFiles.size() + " resource" + (includedFiles.size() > 1 ? "s" : "") + (targetPath == null ? "" : " to " + targetPath));
            Iterator<String> j = includedFiles.iterator();
            while (j.hasNext()) {
                String name;
                String destination = name = j.next();
                if (targetPath != null) {
                    destination = targetPath + "/" + name;
                }
                File source = new File(resourceDirectory, name);
                File destinationFile = new File(outputDirectory, destination);
                if (!destinationFile.getParentFile().exists()) {
                    destinationFile.getParentFile().mkdirs();
                }
                boolean filteredExt = this.filteredFileExtension(source.getName(), mavenResourcesExecution.getNonFilteredFileExtensions());
                this.mavenFileFilter.copyFile(source, destinationFile, resource.isFiltering() && filteredExt, mavenResourcesExecution.getFilterWrappers(), mavenResourcesExecution.getEncoding());
            }
        }
    }
}

