/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.EventObject;
import com.sun.star.lang.XEventListener;
import com.sun.star.uno.UnoRuntime;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class InterfaceContainer
implements Cloneable {
    final boolean DEBUG = false;
    Object[] elementData;
    private int size;
    static /* synthetic */ Class class$com$sun$star$lang$XEventListener;

    public InterfaceContainer() {
        this(10);
    }

    public InterfaceContainer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new Object[n];
    }

    public synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.size < n) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.size];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.size);
        }
    }

    public synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            Object[] objectArray = this.elementData;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new Object[n3];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.size);
        }
    }

    public synchronized boolean add(Object object) {
        boolean bl = false;
        if (this.elementData != null && object != null) {
            this.ensureCapacity(this.size + 1);
            this.elementData[this.size++] = object;
            bl = true;
        }
        return bl;
    }

    public synchronized void add(int n, Object object) {
        if (this.elementData != null && object != null) {
            if (n > this.size || n < 0) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
            }
            this.ensureCapacity(this.size + 1);
            System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
            this.elementData[n] = object;
            ++this.size;
        }
    }

    public synchronized boolean addAll(Collection collection) {
        int n = collection.size();
        this.ensureCapacity(this.size + n);
        Iterator iterator = collection.iterator();
        for (int i = 0; i < n; ++i) {
            Object e = iterator.next();
            if (e == null) continue;
            this.elementData[this.size++] = e;
        }
        return n != 0;
    }

    public synchronized boolean addAll(int n, Collection collection) {
        boolean bl = false;
        if (this.elementData != null) {
            int n2;
            if (n > this.size || n < 0) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
            }
            int n3 = collection.size();
            Object[] objectArray = new Object[n3];
            Iterator iterator = collection.iterator();
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                Object e = iterator.next();
                if (e == null) continue;
                objectArray[n4++] = e;
            }
            n2 = n4;
            this.ensureCapacity(this.size + n2);
            int n5 = this.size - n;
            if (n5 > 0) {
                System.arraycopy(this.elementData, n, this.elementData, n + n2, n5);
            }
            for (int i = 0; i < n2; ++i) {
                this.elementData[n++] = objectArray[i];
            }
            this.size += n2;
            bl = n2 != 0;
        }
        return bl;
    }

    public synchronized void clear() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                this.elementData[i] = null;
            }
            this.size = 0;
        }
    }

    public synchronized boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public synchronized boolean containsAll(Collection collection) {
        boolean bl = true;
        if (this.elementData != null && collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (this.contains(e)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public synchronized Object get(int n) {
        if (this.elementData != null) {
            this.RangeCheck(n);
            return this.elementData[n];
        }
        return null;
    }

    public synchronized int indexOf(Object object) {
        int n = -1;
        if (this.elementData != null && object != null) {
            int n2;
            for (n2 = 0; n2 < this.size; ++n2) {
                if (object != this.elementData[n2]) continue;
                n = n2;
                break;
            }
            if (n == -1) {
                for (n2 = 0; n2 < this.size; ++n2) {
                    if (!UnoRuntime.areSame((Object)object, (Object)this.elementData[n2])) continue;
                    n = n2;
                    break;
                }
            }
        }
        return n;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized Iterator iterator() {
        if (this.elementData != null) {
            InterfaceContainer interfaceContainer = (InterfaceContainer)this.clone();
            return new Itr(interfaceContainer);
        }
        return null;
    }

    public synchronized int lastIndexOf(Object object) {
        int n = -1;
        if (this.elementData != null && object != null) {
            int n2;
            for (n2 = this.size - 1; n2 >= 0; --n2) {
                if (object != this.elementData[n2]) continue;
                n = n2;
                break;
            }
            if (n == -1) {
                for (n2 = this.size - 1; n2 >= 0; --n2) {
                    if (!UnoRuntime.areSame((Object)object, (Object)this.elementData[n2])) continue;
                    n = n2;
                    break;
                }
            }
        }
        return n;
    }

    public synchronized Object clone() {
        InterfaceContainer interfaceContainer = null;
        if (this.elementData != null) {
            InterfaceContainer interfaceContainer2 = new InterfaceContainer();
            interfaceContainer2.elementData = new Object[this.size];
            interfaceContainer2.size = this.size;
            System.arraycopy(this.elementData, 0, interfaceContainer2.elementData, 0, this.size);
            interfaceContainer = interfaceContainer2;
        }
        return interfaceContainer;
    }

    public synchronized ListIterator listIterator() {
        return this.listIterator(0);
    }

    public synchronized ListIterator listIterator(int n) {
        if (this.elementData != null) {
            InterfaceContainer interfaceContainer = (InterfaceContainer)this.clone();
            return new LstItr(interfaceContainer, n);
        }
        return null;
    }

    public synchronized Object remove(int n) {
        Object object = null;
        if (this.elementData != null) {
            this.RangeCheck(n);
            object = this.elementData[n];
            int n2 = this.size - n - 1;
            if (n2 > 0) {
                System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
            }
            this.elementData[--this.size] = null;
        }
        return object;
    }

    public synchronized boolean remove(Object object) {
        int n;
        boolean bl = false;
        if (this.elementData != null && object != null && (n = this.indexOf(object)) != -1) {
            bl = true;
            this.remove(n);
        }
        return bl;
    }

    public synchronized boolean removeAll(Collection collection) {
        boolean bl = false;
        if (this.elementData != null && collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                boolean bl2 = this.remove(e);
                if (!bl2) continue;
                bl = true;
            }
        }
        return bl;
    }

    public synchronized boolean retainAll(Collection collection) {
        boolean bl = false;
        if (this.elementData != null && collection != null) {
            Object[] objectArray = new Object[this.size];
            int n = 0;
            for (int i = 0; i < this.size; ++i) {
                Object object = this.elementData[i];
                Iterator iterator = collection.iterator();
                boolean bl2 = false;
                while (iterator.hasNext()) {
                    if (object != iterator.next()) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (e == null || !UnoRuntime.areSame(e, (Object)object)) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (!bl2) continue;
                objectArray[n++] = object;
            }
            boolean bl3 = bl = this.size != n;
            if (n > 0) {
                this.elementData = objectArray;
                this.size = n;
            }
        }
        return bl;
    }

    public synchronized Object set(int n, Object object) {
        Object object2 = null;
        if (this.elementData != null && object != null) {
            this.RangeCheck(n);
            object2 = this.elementData[n];
            this.elementData[n] = object;
        }
        return object2;
    }

    public synchronized int size() {
        if (this.elementData != null) {
            return this.size;
        }
        return 0;
    }

    public synchronized Object[] toArray() {
        if (this.elementData != null) {
            Object[] objectArray = new Object[this.size];
            System.arraycopy(this.elementData, 0, objectArray, 0, this.size);
            return objectArray;
        }
        return null;
    }

    public synchronized Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        if (this.elementData != null) {
            System.arraycopy(this.elementData, 0, objectArray, 0, this.size);
        }
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    private void RangeCheck(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAndClear(EventObject eventObject) {
        Iterator iterator;
        InterfaceContainer interfaceContainer = this;
        synchronized (interfaceContainer) {
            iterator = this.iterator();
            this.clear();
            this.elementData = null;
            this.size = 0;
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                try {
                    XEventListener xEventListener = (XEventListener)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XEventListener == null ? InterfaceContainer.class$("com.sun.star.lang.XEventListener") : class$com$sun$star$lang$XEventListener), (Object)(interfaceContainer = iterator.next()));
                    if (xEventListener == null) continue;
                    xEventListener.disposing(eventObject);
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class LstItr
    extends Itr
    implements ListIterator {
        LstItr(InterfaceContainer interfaceContainer2, int n) {
            super(interfaceContainer2);
            this.cursor = n;
        }

        public synchronized void add(Object object) {
            InterfaceContainer.this.add(object);
            this.dataIt.add(this.cursor++, object);
            this.lastRet = -1;
            this.lastRetObj = null;
        }

        public synchronized boolean hasPrevious() {
            return this.cursor != 0;
        }

        public synchronized int nextIndex() {
            return this.cursor;
        }

        public synchronized Object previous() {
            try {
                Object object = this.dataIt.get(--this.cursor);
                this.lastRet = this.cursor;
                this.lastRetObj = object;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public synchronized int previousIndex() {
            return this.cursor - 1;
        }

        public synchronized void set(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private class Itr
    implements Iterator {
        InterfaceContainer dataIt;
        int cursor = 0;
        int lastRet = -1;
        Object lastRetObj = null;

        Itr(InterfaceContainer interfaceContainer2) {
            this.dataIt = interfaceContainer2;
        }

        public synchronized boolean hasNext() {
            return this.cursor != this.dataIt.size();
        }

        public synchronized Object next() {
            try {
                Object object = this.dataIt.get(this.cursor);
                this.lastRet = this.cursor++;
                this.lastRetObj = object;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public synchronized void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            InterfaceContainer.this.remove(this.lastRetObj);
            this.dataIt.remove(this.lastRet);
            if (this.lastRet < this.cursor) {
                --this.cursor;
            }
            this.lastRet = -1;
            this.lastRetObj = null;
        }
    }
}

